# Contributing to The Static Web Server project

Looking to contribute? You’re welcome!

## [Code of Conduct](./docs/CODE_OF_CONDUCT.md)

First, **all** project interactions must follow [the code of conduct](./docs/CODE_OF_CONDUCT.md) to ensure everyone is treated with respect.

## [Issues](https://github.com/static-web-server/static-web-server/issues/new/choose)

- Filing an issue is a valuable contribution. Reporting bugs and providing details helps us improve SWS and stay informed about issues we might not have noticed otherwise.
- [Security issues](./SECURITY.md) has some consideration to take into your account first.

## [Pull Requests](./docs/PULL_REQUESTS.md)

Consider checking the [list of issues](https://github.com/static-web-server/static-web-server/issues) if you want to submit something.

- [Submitting a Pull Request](./docs/PULL_REQUESTS.md#submitting-a-pull-request)
- [Commit Guidelines](./docs/COMMITS.md)

## Documentation

Improving SWS documentation greatly helps everyone trying to use it.

- The main website documentation is hosted in the repository and can be improved by following [the documentation instructions](https://static-web-server.net/building-from-source/#building-documentation-from-source).
- The API documentation (rendered at [docs.rs/static-web-server](https://docs.rs/static-web-serve)) is stored as rustdoc comments directly in the source.

## Help

Helping others integrate SWS into their workflows is a valuable way to contribute:

- Answer questions in SWS's Discussions or on our Discord.
- Write blog posts about using SWS, contributing features, or debugging issues. Your posts add unique insights and examples that may not fit in the SWS repo, helping more users find solutions and explore new use cases.
