/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/
#include "about.h"
#include "version.h"
#define REC_PATH ":/" //QDir::currentPath()+"/resources/"

About::About(QWidget *parent)
        : QDialog(parent)
{
    setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    btnClose->setIcon(QIcon(QString(REC_PATH) + QString("dialog-close.png")));

    QPixmap pm(QString(REC_PATH) + QString("mdic-48.png"));
    lblIcon->setPixmap(pm);
    lblVersion->setText( QString("MDic %1").arg(VERSION) );

    txtAbout->setTextFormat(Qt::RichText);
    txtAbout->setText(tr("<br/>\
                          <br/>\
                          <br/>MDic is a Multi-Lingual Dictionary for GNU/Linux.\
                          <br/>\
                          <br/>(C) 2007-2010, MDic Developers\
                          <br/>\
                          <a href='http://mdic.gnufolks.org/'>http://mdic.gnufolks.org/</a>\
                          <br/>\
                          <br/>\
                          <br/>\
                          <br/>\
                          <b>Enjoy MDic!?</b>\
                          <br/><a href='http://mdic.gnufolks.org/contribute.html'>Make a donation</a>,\
                          And help us keeping it up...\
                          "));


    txtAuthors->setTextFormat(Qt::RichText);
    txtAuthors->setText(tr("<br/>Please use <a href='https://bugs.launchpad.net/mdic'>https://bugs.launchpad.net/mdic</a> to report bugs.\
                          <br/>\
                          <br/>\
                          <br/>Majid Ramezanpour (maour)\
                          <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='mailto:majid.ramezanpour@gmail.com'>majid.ramezanpour@gmail.com</a>\
                          <br/>\
                            <br/>Mehrdad Momeny (mtux)\
                            <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='mailto:mehrdad.momeny@gmail.com'>mehrdad.momeny@gmail.com</a>"));
    this->setWindowFlags(Qt::Dialog);
}

#include "about.moc"
