/*
   This file is part of MDic Dictionary
   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/


#include "configdialog.h"
#include "generalconfig.h"
#include "resultsconfig.h"
#include "dictionaryconfig.h"
#include "speechconfig.h"
#include <QTabWidget>
#include <QVBoxLayout>
#include <qdialogbuttonbox.h>
#include <QDebug>
#include "settings.h"

class ConfigDialog::Private
{
public:
    Private(QWidget* parent, Qt::WindowFlags f)
            : setting(new QSettings("MGroup", "MDic")) {
        general = new GeneralConfigWidget(parent, f);
        results = new ResultsConfigWidget(parent, f);
        dic = new DictionaryConfigWidget(parent, f);
        speech = new SpeechConfigWidget(parent, f);
    }
    GeneralConfigWidget *general;
    ResultsConfigWidget *results;
    DictionaryConfigWidget *dic;
    SpeechConfigWidget *speech;
    QSettings *setting;
};

ConfigDialog::ConfigDialog(QWidget* parent, Qt::WindowFlags f)
        : QDialog(parent, f), d(new Private(parent, f))
{
    setAttribute(Qt::WA_DeleteOnClose);
    setWindowTitle(tr("Configure MDic"));
    setupUi();
    resize(d->setting->value("ConfigDialogSize", QSize(500, 400)).toSize());
}

ConfigDialog::~ConfigDialog()
{
    d->setting->setValue(QLatin1String("ConfigDialogSize"), this->size());
    delete d;
}

void ConfigDialog::setupUi()
{
    QVBoxLayout *layout = new QVBoxLayout(this);
    QTabWidget *mainWidget = new QTabWidget(this);
    layout->addWidget(mainWidget);
    mainWidget->addTab(d->general, tr("General"));
    mainWidget->addTab(d->results, tr("Results"));
    mainWidget->addTab(d->dic, tr("Dictionaries"));
    mainWidget->addTab(d->speech, tr("Speech"));

    QDialogButtonBox *buttons = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel,
            Qt::Horizontal, this);
    layout->addWidget(buttons);
    connect(buttons, SIGNAL(accepted()), SLOT(accept()));
    connect(buttons, SIGNAL(rejected()), SLOT(reject()));
}

void ConfigDialog::accept()
{
    qDebug() << "Accepted";
    d->general->save();
    d->dic->save();
    d->results->save();
    d->speech->save();
    Settings::self()->writeConfig();
    QDialog::accept();
}

#include "configdialog.moc"
