/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/


#include "resultsconfig.h"
#include "ui_resultsconfigbase.h"
#include <settings.h>
#include <QFontDialog>
#include <QMessageBox>

class ResultsConfigWidget::Private
{
public:
    Ui_ResultsConfigBase ui;
};

ResultsConfigWidget::ResultsConfigWidget(QWidget* parent, Qt::WindowFlags f)
        : QWidget(parent, f), d(new Private)
{
    d->ui.setupUi(this);
    connect(d->ui.comboDisplaymode, SIGNAL(currentIndexChanged(int)),
            SLOT(slotCurrentDisplayModeChanged(int)));
    connect(d->ui.chkOnTop, SIGNAL(toggled(bool)),
            SLOT(slotOnTopChanged(bool)));
    connect(d->ui.btnFont, SIGNAL(clicked(bool)), SLOT(selectResultFont()));
    load();
}

ResultsConfigWidget::~ResultsConfigWidget()
{
    delete d;
}

void ResultsConfigWidget::load()
{
    d->ui.chkStay->setChecked(Settings::self()->stay);
    d->ui.chkOnTop->setChecked(Settings::self()->onTop);
    d->ui.chkJustFirst->setChecked(Settings::self()->showJustFirst);
    d->ui.chkMove->setChecked(Settings::self()->isMove);
    d->ui.chkNotify->setChecked(Settings::self()->notifyNotAvailable);

    d->ui.comboDisplaymode->setCurrentIndex(Settings::self()->output);
    d->ui.spnInterval->setValue(Settings::self()->showInterval);
}

void ResultsConfigWidget::save()
{
    Settings::self()->stay = d->ui.chkStay->isChecked();
    Settings::self()->onTop = d->ui.chkOnTop->isChecked();
    Settings::self()->showJustFirst = d->ui.chkJustFirst->isChecked();
    Settings::self()->isMove = d->ui.chkMove->isChecked();
    Settings::self()->notifyNotAvailable = d->ui.chkNotify->isChecked();

    Settings::self()->output = (Settings::OutputTypes) d->ui.comboDisplaymode->currentIndex();
    Settings::self()->showInterval = d->ui.spnInterval->value();
}

void ResultsConfigWidget::selectResultFont()
{
    bool ok = false;
    Settings::self()->fontD = QFontDialog::getFont(&ok, Settings::self()->fontD,
                                 this, tr("Select Font for Result Box"));
}

void ResultsConfigWidget::slotCurrentDisplayModeChanged(int index)
{
    if (index == 0) { //Display sets on mainwindow
        d->ui.chkOnTop->setEnabled(false);
        d->ui.chkOnTop->setChecked(true);
    } else {
        d->ui.chkOnTop->setEnabled(true);
        d->ui.chkOnTop->setChecked(Settings::self()->onTop);
    }
}

void ResultsConfigWidget::slotOnTopChanged(bool newStatus)
{
    if (Settings::self()->onTop != newStatus)
        QMessageBox::information(this, tr("Restart needs"),
                                 tr("Change On Top option, will take effect after MDic restart"));
}

#include "resultsconfig.moc"
