/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "dbusadaptor.h"
#include <QApplication>
#include <QDBusConnection>
#include "mainwindow.h"

DBusAdaptor::DBusAdaptor(QApplication *app)
    : QDBusAbstractAdaptor(app)
{
    QDBusConnection connection = QDBusConnection::sessionBus();
    if( connection.registerService("org.mdic.dbus") &&
        connection.registerObject("/mdic", app) )
        registrationSuccessed = true;
    else
        registrationSuccessed = false;
}

bool DBusAdaptor::isFirstService()
{
    return registrationSuccessed;
}

void DBusAdaptor::setMainWindow(MainWindow* mainWindow)
{
    m_mainWindow = mainWindow;
}

bool DBusAdaptor::mainWindowVisible() const
{
    return m_mainWindow->isVisible();
}

void DBusAdaptor::setMainWindowVisible(bool visible)
{
    m_mainWindow->setVisible(visible);
}

bool DBusAdaptor::selectionScannerEnable() const
{
    return Settings::self()->clipboardWatcher;
}

void DBusAdaptor::setSelectionScannerEnable(bool enable)
{
    m_mainWindow->setSelectionScannerEnabled(enable);
}

void DBusAdaptor::toggleMainWindowVisible()
{
    setMainWindowVisible(!mainWindowVisible());
}

void DBusAdaptor::toggleSelectionScannerEnable()
{
    setSelectionScannerEnable(!selectionScannerEnable());
}

void DBusAdaptor::showTranslation(const QString &text)
{
    m_mainWindow->getMean( MainWindow::Other, text);
}

QString DBusAdaptor::translate(const QString &text)
{
    return DictCore::self()->translate(text, true).first().translation();
}

#include "dbusadaptor.moc"

