/*
   This file is part of MDic Dictionary
   It's based on QStarDict dictcore.cpp

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "dictcore.h"

#include <QApplication>
#include <QFileInfoList>
#include <QFileInfo>
#include <QDir>
#include <QRegExp>
#include <QSettings>
/*#include <QDebug>*/
#include <QPluginLoader>
#include "dicts/dict.h"
#include "settings.h"
#include <QFont>
#include "dicts/mdict.h"
#include "dicts/gtranslate.h"


DictCore * DictCore::m_self = new DictCore;


DictCore* DictCore::self()
{
    return m_self;
}


DictCore::DictCore()
    : QObject(qApp)
{
}

DictCore::~DictCore()
{
}

QList<Translation> DictCore::translate(const QString& word, bool justFirst)
{
    //qDebug()<<"DictCore::translate";
    QList<Translation> resultList;
    foreach (const Dictionary &i, m_loadedDicts)
    {
        if( !i.isEnabled() )
            continue;
        if(i.backendType() == MDic)
            resultList<< MDict::translate(i, word);
        else if(Settings::self()->alwaysSearchRemoteResources)
            resultList<< GTranslate::translate(i, word);
        if( justFirst && !resultList.isEmpty() )
            return resultList;
    }
    return resultList;
}

QList< DictCore::Dictionary > DictCore::loadedRemoteDicts() const
{
    QList<Dictionary> dicts;
    foreach(const Dictionary &dic, m_loadedDicts){
        if(dic.backendType() == GoogleTranslate)
            dicts.append(dic);
    }
    return dicts;
}

void DictCore::setLoadedDicts(const QList<Dictionary> &loadedDicts)
{
    m_loadedDicts = loadedDicts;
}

QString DictCore::translationToHtml(const Translation& translation)
{
    QString dir="ltr";
    QString html ;
    if(translation.phrase().isRightToLeft())
        dir="rtl";
    html += "<span dir='"+ dir +"'><B>" + translation.phrase() + ":</B></span>";
    if(translation.translation().isRightToLeft())
        dir = "rtl";
    else
        dir = "ltr";
    html += "<div dir='" + dir + "'>" +
            fontToHtml(&(Settings::self()->fontD), translation.translation()) + "</div></p>";
    return html;
}

QString DictCore::fontToHtml(QFont* inFont, const QString& text, const QString& color)
{
    QString out;
    out += inFont->bold() ? "<B>" : QString();
    out += inFont->italic() ? "<I>" : QString();
    out += inFont->underline() ? "<U>" : QString();
    out += "<font Style='" + (color.isEmpty() ? QString() : "color:" + color + ';') + " font-family:" + inFont->family() + ";font-size:" + QVariant(inFont->pointSize()).toString() + "pt;font-weight:" + QVariant(inFont->weight()).toString() + "'>&nbsp;";
    out += text;
    out += "</font>";
    out += inFont->underline() ? "</U>" : QString();
    out += inFont->italic() ? "</I>" : QString();
    out += inFont->bold() ? "</B>" : QString();
    return out;
}

DictCore::Dictionary DictCore::dictionary(const QString& code)
{
    foreach(const Dictionary &dic, m_loadedDicts){
        if(dic.code() == code)
            return dic;
    }
}

#include "dictcore.moc"
