/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "mdict.h"
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSettings>
#include <QDebug>
#include <qsqlrecord.h>
#include <QSqlError>
#include <QDir>

MDict::MDict(QObject* parent)
    : QObject(parent)
{
//     qDebug("MDict::MDict");
}

MDict::~MDict()
{
//     qDebug("MDict::~MDict");
}

DictInfo MDict::dictInfo(const DictCore::Dictionary& dict)
{
    DictInfo info(dict.name());

    QSqlDatabase db = QSqlDatabase::database(dict.code(), true);
    QSqlQuery query(db);
    query.setForwardOnly(true);

    query.exec("SELECT * FROM dbinfo limit 1");
    //SELECT dbname,category,author,version,direction,origLang,destLang,license,description

    int dbnameNo = query.record().indexOf("dbname");
    int authorNo = query.record().indexOf("author");
    int versionNo = query.record().indexOf("version");
    int origLangNo = query.record().indexOf("origLang");
    int destLangNo = query.record().indexOf("destLang");
    int licenseNo = query.record().indexOf("license");
    int descriptionNo = query.record().indexOf("description");

    if (query.next()) {
        info.setName(query.value(dbnameNo).toString());
        info.setAuthor(query.value(authorNo).toString());
        info.setSourceLanguage(query.value(origLangNo).toString());
        info.setDestinationLanguage(query.value(destLangNo).toString());
        info.setLicense(query.value(licenseNo).toString());
        info.setDescription(query.value(descriptionNo).toString());
    }
    query.exec("select count(*) from word");
    if (query.next())
        info.setWordsCount(query.value(0).toUInt());

    return info;
}

QList<Translation> MDict::translate(const DictCore::Dictionary& dict, const QString& word)
{
    //qDebug()<<"MDict::translate";
    QString word2find = word;
    QList<Translation> result;

    while ((word2find[0] != '@') && ((word2find[0] < 97) || (word2find[0] > 122 && word2find[0] < 128))) { //for remove characters before word like ; . or ... except @ (we need @ for related words link in babylon databases)
        if (word2find.size() == 1)
            return result;
        word2find.remove(0, 1);
    }

    while ((word2find[word2find.length()-1] < 97) || (word2find[word2find.length()-1] > 122 && word2find[word2find.length()-1] < 128)) { //for remove characters after word like ; . or ...
        if (word2find.size() == 1)
            return result;
        word2find.remove(word2find.length() - 1, 1);
    }

    // use temp for test *s *ing *ed ...
    QString mainWord = word2find;

    // Store Mean of requested word from all Databases -no!-
    QString mean;
    QString nonHtmlMean;

    bool found, flgIes, flgNot, flgIly, flgUn, flgNess, flgOps, flgIed, flgNing, flgMent,
         flgIng, flgS, flgLy, flgEd, flgEs, flgEr, flgE;

    mean = "";
    word2find = mainWord;
    found = false;
    flgIes = flgNot = flgUn = flgIly = flgNess = flgOps = flgIed = flgNing = flgMent =
                flgIng = flgS = flgLy = flgEd = flgEs = flgEr = flgE = false;
    while (1) {
        QSqlQuery query(QSqlDatabase::database(dict.code(), true));

        query.setForwardOnly(true);      //for performance
        QString wCh = word2find;
        wCh.replace('\'', "''");
        if (!query.exec("select wmean from word WHERE wname='" + wCh + '\''))
            qDebug() << "DbMan::getMean: lastError: " << query.lastError().text();
        while (query.next()) {
            found = true;
            Translation trans(word2find, dict.name(), query.value(0).toString());
            result<<trans;
        }
        if (found)
            break;
        QString word2CheckE = word2find;
        word2find = mainWord;

        if ((flgIng || flgEd) && !flgE) {
            flgE = true;
            word2find = word2CheckE;
            word2find.append('e');
            continue;
        } else if (word2find.left(2) == "un" && !flgUn) {
            flgUn = true;
            word2find.remove(0, 2);
//                 qDebug(word2find.toLatin1().data());
            continue;
        } else if (word2find.right(1) == QString('s') && !flgS) {
            flgS = true;
            word2find.remove(word2find.length() - 1, 1);
            continue;
        } else if (word2find.right(2) == "'s" && !flgOps) {
            flgOps = true;
            word2find.remove(word2find.length() - 2, 2);
            continue;
        } else if (word2find.right(3) == "ied" && !flgIed) {
            flgIed = true;
            word2find.remove(word2find.length() - 3, 3);
            word2find.append("y");
            continue;
        } else if (word2find.right(3) == "ing" && !flgIng) {
            flgIng = true;
            word2find.remove(word2find.length() - 3, 3);
            continue;
        } else if (word2find.right(2) == "ly" && !flgLy) {
            flgLy = true;
            word2find.remove(word2find.length() - 2, 2);
            continue;
        } else if (word2find.right(2) == "ed" && !flgEd) {
            flgEd = true;
            word2find.remove(word2find.length() - 2, 2);
            continue;
        } else if (word2find.right(2) == "es" && !flgEs) {
            flgEs = true;
            word2find.remove(word2find.length() - 2, 2);
            continue;
        } else if (word2find.right(2) == "er" && !flgEr) {
            flgEr = true;
            word2find.remove(word2find.length() - 2, 2);
            continue;
        } else if (word2find.right(4) == "ning" && !flgNing) {
            flgNing = true;
            word2find.remove(word2find.length() - 3, 3);
            continue;
        } else if (word2find.right(4) == "ment" && !flgMent) {
            flgMent = true;
            word2find.remove(word2find.length() - 4, 4);
            continue;
        } else if (word2find.right(3) == "ies" && !flgIes) {
            flgIes = true;
            word2find.remove(word2find.length() - 3, 3);
            word2find.append('y');
            continue;
        } else if (word2find.right(3) == "n't" && !flgNot) {
            flgNot = true;
            word2find.remove(word2find.length() - 3, 3);
            continue;
        } else if (word2find.right(3) == "ily" && !flgIly) {
            flgIly = true;
            word2find.remove(word2find.length() - 3, 3);
            word2find.append('y');
            continue;
        } else if (word2find.right(4) == "ness" && !flgNess) {
            flgNess = true;
            word2find.remove(word2find.length() - 4, 4);
            continue;
        } else
            break;
    }
    return result;
}

#include "mdict.moc"
