/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/


#include <QtGui/QApplication>
#include <QtGui/QMessageBox>
#include <QtCore/QString>

#include <iostream>

#include "mainwindow.h"
#include "settings.h"
#include "version.h"
#include "dictcore.h"
#include "dbusadaptor.h"
#include <QDBusInterface>
#include <QDBusReply>

QString OutGetMean(const QString&);

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QCoreApplication::setOrganizationName("MGroup");
    QCoreApplication::setApplicationName("MDic");
    app.setQuitOnLastWindowClosed(false);
    QString mean;
    while (argc > 1 && argv[1][0] == '-') {
        switch (argv[1][1]) {
        case 'w':
        case 'W':
            if (argv[1][2])
                mean = OutGetMean(&argv[1][2]);
            else
                mean = OutGetMean(&argv[1][3]);
            //QMessageBox::information(0, ".:MDic Dictionary:.", mean);
            std::cout<<mean.toUtf8().data();
            return 0;
            break;
        case 'h':
        case 'H':
        default:
//                         char* ver=VERSION;
            printf("MDic Dictionary version %s (C) Copyright by MDic Developers\n \
Usage: mdic [options]\n \
\t-w[WORD] :\n\
Show mean of WORD and exit!\n\
\t-h :\n\
Show this message.\
without any Options it will Open main program window.\n", VERSION);
            return 0;
            break;
        }
        --argc;
        ++argv;
    }

#ifdef Q_WS_WIN
    QFile file(QDir::homePath() + "/.config/MGroup/lock");
    if( file.exists() ) {
        if( QMessageBox::warning(0, "MDic is already running",
                                 QString("It seems that another instance of MDic is already running."
                                 "\nMybe it was crashed on previous run. Press OK, to run a new instance?"),
                                 QMessageBox::Ok, QMessageBox::Cancel) == QMessageBox::Cancel)
            return 0;
    }
    file.open(QIODevice::WriteOnly);
#else
    DBusAdaptor *dbus = new DBusAdaptor(&app);
    if( !dbus->isFirstService() ){
        qDebug("Another instance of MDic is already running!");
        QDBusInterface remoteApp( "org.mdic.dbus", "/mdic", "org.mdic.dbus" );
        remoteApp.setProperty( "mainWindowVisible", 1 );
        exit(0);
    }
#endif

    MainWindow *m = new  MainWindow();
    m->init();

#ifndef Q_WS_WIN
    dbus->setMainWindow(m);
#endif

    int res = app.exec();

#ifdef Q_WS_WIN
    file.close();
    file.remove();
#endif

    return  res;
}

QString OutGetMean(const QString &word)
{
    Settings *config = Settings::self();
    QString mean;

    QString wordToFind = word.toLower().simplified();
    if ( !wordToFind.isEmpty() ) {
        QList<Translation> res = DictCore::self()->translate(wordToFind);
        if ( !res.isEmpty() )
            foreach (const Translation &resItem, res) {
                //mean.append( DictCore::translationToHtml(resItem) + '\n' );
				mean.append(resItem.dictName() + " : " +resItem.translation()+"\n\n");
            }
    }

    return mean;
}
