/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/
#ifndef MainWindow_H
#define MainWindow_H

#include <QMainWindow>
/*#include <QDebug>*/
#include <QtGui/QSystemTrayIcon>


#include "settings.h"
#include "keyboard.h"
#include "about.h"
#include "widgets/mdiccombobox.h"
#include "widgets/dicwidget.h"

#include <aspell.h>
#include "dicts/dict.h"

class ConfigDialog;
class SpellChecker;
class QToolButton;
class QProcess;
class QTextBrowser;
class QPushButton;
class QLabel;
class QIcon;

class QVBoxLayout;
class QAction;
class QToolBar;
class QMenu;

class QClipBoard;
class QMouseEvent;

class QScrollBar;
class QStatusBar;
class QScrollArea;


class QUrl;
class QTimer;
class QString;
class QStringList;

// class spellchecker;
class MainWindow: public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();

    enum SearchPlace {Selection, TxtGet, TxtGetOnTray, MainWin, Other};

    void init();
    void initSysTrayContextMenu();

    /**
     * function that find mean of the word of "txtGet"
     * @param  input is where user searches word
     * @return return true if found mean or false if not!
     */
    bool getMean(SearchPlace place, const QString &phrase = QString());

public slots:
    void setSelectionScannerEnabled(bool enable);

protected slots:
    void slotRemoteSearchTriggered();
    void sltQuit();

    void sltGetMeanByClick();
//     void sltGetMeanBySelection();

    void sltActivated(QSystemTrayIcon::ActivationReason reason);
    void sltHideMessage();

    void sltAboutUs();
    void sltShowHelp();
    void sltShowConfigs();

    void sltClipBoardTime();

    void sltSay();

    void sltLink(const QUrl &link);   //QTextBrowser!

    void sltBackward();
    void sltForward();

    void slotSettingsChanged();

//     void sltShowCorrectPhrase();

private:
    void showSearchResult( const QString &nonHtmlMean, const QString &wordToFind );
    void moveToCursorPos();

    void reloadRemoteDictsMenu();

    QString lastNotFoundWord;
    void keyPressEvent(QKeyEvent * event);

    void contextMenuEvent(QContextMenuEvent * event);

    void enterEvent(QEvent * event);
    void leaveEvent(QEvent * event);

    void show(bool isBySelection);

    void say(const QString&);

    bool checkSpelling(const QString &phrase);
    QScrollArea *spellingMenuScroll;

    void setModifier(int Mod);

    /** if cursor is over widget return true else return false **/
    bool isMouseOver();

    QPointer<QProcess> speechProcess;

    QString lastClipboard;
//     QString lastSearchPhrase;

    void createUI(); // Create UI of Main Window
    void createSysTrayContextMenu();

    void readConfig(); //Read Configuration of main window
    void writeConfig(); //Write Configuration of main window
    Settings *config; // instance of Settings Class that store configuration of app
    SpellChecker *spellcheck;

    QAction *actnSelectionScan;
//     QVBoxLayout *searchLayout;
//     QDockWidget *searchDock;
//     void setupSearchToolBar();
//     void createDockWidget();

//     QStatusBar *statusbar;

//     QLabel *lblAbout;

    MDicComboBox *txtGet;      //Get Word 2 Find Mean
	MDicComboBox *txtGetOnTray;
    QTextBrowser *txtShowMean; //show Word Mean
    DicWidget *showMeanWidget;

    QToolButton *btnPronounce;
    QToolButton *btnSetting;

    QToolButton *btnForward;
    QToolButton *btnBackward;
    QPointer<QToolButton> btnSearchRemote;
    QPointer<ConfigDialog> configDialog;
    QHBoxLayout *searchToolBar;

//     QStringList history;

//     int histPointer;

    int modifierKey; //0 meta(win key) % 1 Alt % 2 Control % 3 Shift

    QSystemTrayIcon *sysTrayIcon;
    QMenu *trayMenu;

    QTimer *MessageTimer; // timer to check time of closing window
    QTimer *clipboardTimer; // a timer that check clipboard every 1 sec. to find changes on clipboard
//     QTimer *NotFoundTimer; // a timer to change color of txtGet to default after phrase not found

//     bool flgBack;//to check if add this word to history or not! if true means backward or forward button clicked
    //to check if cursor on mainwindow don't hide it;

    bool isEntered;
    bool flgOnScreen;

    bool flgNotSearched;//if flgSearched is true means that clipboard changed but beacause modifier not clicked , it doesn't showed.
    //so the next time the modifier clicked we must show the mean.

};

#endif
