/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/
#ifndef SETTINGS_H
#define SETTINGS_H

#include <QStringList>
#include <QSettings>
#include <QPointer>

#define REC_PATH ":/" //QDir::currentPath()+"/resources/"

/**
    @author Majid Ramezanpour <thinkgnu@gmail.com>
    @author Mehrdad Momeny <mehrdad.momeny@gmail.com>

    Our persian Blog: http://mtux.wordpress.com
*/
#include "dictcore.h"

class Settings : public QObject
{
    Q_OBJECT
public:
    enum OutputTypes {Main, SysTray, LibNotify, KPopup};
    QString dbsDir();
    bool noEspeak; // check if espeak installed, and set this variable! (it doesn't save on disk!)
    ~Settings();
    static Settings *self();

    void readConfig();
    void writeConfig();

    void setSpeechCmd();

    bool createConnection();
    void closeConnection();

//     int rc;  //row count
    QList<DictCore::Dictionary> dicts;
    bool onTop;
    bool isMove;
    int showInterval;
    QFont fontD;
    bool clipboardWatcher;
    bool showOnStart;
    bool notifyNotAvailable;
    bool stay;
    double stayTime;
    bool modStatus;
    int mod;    //0 meta(win key) % 1 Alt % 2 Control % 3 Shift
    bool showJustFirst;
    bool speech;
    bool speakAny;
    int spchSysIdx;
    QString speechSysText;
    QStringList speechArgs;
    int spchSpeed;
    int spchAmplitude;
    int spchPitch;
    QString inLang_espeak;//index in spchLangs String list!
    QMap<QString, QString> espeakLangsMap;
    QString festivalSwitches;
    QChar spchVoice;

    int histLen;
    OutputTypes output;

    bool isSpellingEnabled;
    QString spellingLang;

    bool alwaysSearchRemoteResources;
    uint triggerMaxChar;

signals:
    void configChanged();

private slots:
    void slotCheckAvailableLanguages(int);
    void loadSpeechLanguages();

private:
    Settings();
    void loadDicts(QSettings &set);
    void saveDicts(QSettings &set);
    QString m_dbsDir;
    static QPointer<Settings> m_self;
};

#endif
