/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/
*/

#ifndef ASPELL_H
#define ASPELL_H

#include <QObject>
#include <QPointer>
#include <aspell.h>
#include <QStringList>

class QString;
class QStringList;
class Settings;
class MDicAspell : public QObject
{
    Q_OBJECT

public:
    static MDicAspell *self();

    QStringList spell(const QString &);

private:

    static QPointer<MDicAspell> m_self;

    MDicAspell();
    ~MDicAspell();

    Settings *config;

    QStringList wordsList;

    AspellConfig * spell_config;
    AspellCanHaveError * possible_err;
    AspellSpeller * spell_checker;

};

#endif // ASPELL_H
