/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/
*/

#include "spellchecker.h"
#include <QDebug>
#include <QApplication>

#include <QString>
#include <QStringList>


#include "mdicaspell.h"
#include "settings.h"

class SpellCheckerPrivate
{
public:
    SpellCheckerPrivate() {}
    ~SpellCheckerPrivate() {}

    Settings *config;

    QStringList suggestions;
    MDicAspell *m_aspell;

};

QPointer<SpellChecker> SpellChecker::m_self = 0L;

SpellChecker* SpellChecker::self()
{
    if (!m_self)
        m_self = new SpellChecker();
    return m_self;
}


SpellChecker::SpellChecker(): QObject(qApp), d(new SpellCheckerPrivate)
{
    d->config = Settings::self();
}


QStringList SpellChecker::spell(const QString& phrase)
{
    d->suggestions.clear();
    d->m_aspell = MDicAspell::self();
    d->suggestions = d->m_aspell->spell(phrase);

    return d->suggestions;

}



SpellChecker::~SpellChecker()
{
    delete d;
}

#include "spellchecker.moc"
