/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/
*/

#ifndef SPELLCHECKER_H
#define SPELLCHECKER_H

#include <QObject>
#include <QPointer>

class QString;
class QStringList;

class SpellCheckerPrivate;

class SpellChecker : public QObject
{
    Q_OBJECT
public:
    static SpellChecker* self();

    QStringList spell(const QString &);

    ~SpellChecker();

private:
    static QPointer<SpellChecker> m_self;

    SpellChecker();


    friend class SpellCheckerPrivate;
    SpellCheckerPrivate *const d;
};

#endif // SPELLCHECKER_H
