/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "dicwidget.h"
#include "mdictextbrowser.h"

#include <QVBoxLayout>
// #include <QHBoxLayout>
// #include <QtGui/QIcon>
// #include <QGroupBox>
// #include <QtCore/QDebug>
#include <QScrollArea>
#include <QSpacerItem>
#include <QScrollBar>

DicWidget::DicWidget(QWidget* parent) :
        QWidget(parent)
{
    setupUI();
    MDicTextBrowser::setStyleColors(this->palette().foreground().color(),
                                    this->palette().background().color());
}


void DicWidget::appendMean(const QString &title,const QString &mean)
{

//   d->title = new QGroupBox("title");
//   d->grpl=new QVBoxLayout(d->title);
    MDicTextBrowser *view = new MDicTextBrowser(this);
    view->setHtml(mean);
	view->setToolTip(title);
    view->setFocusProxy(this);
    view->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    mainLayout->insertWidget( mainLayout->count()-1, view);
    meanWidgets.append(view);
    connect(view, SIGNAL(anchorClicked(QUrl)), SIGNAL(anchorClicked(QUrl)) );
//
//   d->grpl->addWidget(d->view);
//
//   d->title->setLayout(d->grpl);

//
//
    //d->mainLayout->addWidget(d->title);

}

void DicWidget::setupUI()
{

    QVBoxLayout *gridLayout;
    QWidget *scrollAreaWidgetContents;
    QVBoxLayout *verticalLayout_2;
    QSpacerItem *verticalSpacer;

    gridLayout = new QVBoxLayout(this);

    scrollArea = new QScrollArea(this);
    scrollArea->setObjectName("scrollArea");
    scrollArea->setFrameShape(QFrame::NoFrame);
    scrollArea->setWidgetResizable(true);

    scrollAreaWidgetContents = new QWidget();
    scrollAreaWidgetContents->setObjectName("scrollAreaWidgetContents");

    verticalLayout_2 = new QVBoxLayout(scrollAreaWidgetContents);

    mainLayout = new QVBoxLayout();
    verticalSpacer = new QSpacerItem(20, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);

    mainLayout->addItem(verticalSpacer);
    mainLayout->setSpacing(3);

    verticalLayout_2->addLayout(mainLayout);

    scrollArea->setWidget(scrollAreaWidgetContents);

    gridLayout->addWidget(scrollArea);
}

DicWidget::~DicWidget()
{
}

void DicWidget::clear()
{
    foreach( MDicTextBrowser *obj, meanWidgets ){
        obj->deleteLater();
    }
    meanWidgets.clear();
}

void DicWidget::moveScrollUp()
{
    scrollArea->verticalScrollBar()->setSliderPosition(0);
}

#include "dicwidget.moc"

