/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/

*/

#include "mdiccombobox.h"
#include "mdicbutton.h"

#include <QtGui/QApplication>
#include <QtGui/QLineEdit>
#include <QtGui/QClipboard>
#include <QtGui/QIcon>

#include <QtCore/QDebug>
#include <settings.h>

class MDicComboBoxPrivate
{

public:
    MDicComboBoxPrivate() {
        clearButton = 0;
        clickInClear = false;
        clickInEnter = false;
    };

    ~MDicComboBoxPrivate() {

    };

//     QLineEdit *mdiclineedit;

    MDicButton* clearButton;
    MDicButton* searchButton;

    bool clickInClear;
    bool clickInEnter;

    QString newText;
};

MDicComboBox::MDicComboBox(QWidget* parent) :
        QComboBox(parent), d(new MDicComboBoxPrivate)
{
    setEditable(true);
    init();
    setClearButtonShown(false);
    setDuplicatesEnabled(false);
    settingsChanged();
    connect(Settings::self(), SIGNAL(configChanged()), SLOT(settingsChanged()));
}

void MDicComboBox::init()
{
    QPixmap clearPixmap(QString(REC_PATH) + QString("edit-clear-locationbar-rtl.png"));
    d->clearButton = new MDicButton(this);
    d->clearButton->setPixmap(clearPixmap);
    d->clearButton->setToolTip(tr("Clear"));


    QPixmap searchPixmap(QString(REC_PATH) + QString("search.png"));
    d->searchButton = new MDicButton(this);
    d->searchButton->setPixmap(searchPixmap);
    d->searchButton->setToolTip(tr("Search"));

    updateButtonsGeometry();

/*    d->mdiclineedit = this->lineEdit();*/
//     connect(d->mdiclineedit, SIGNAL(returnPressed()), this , SIGNAL(returnPressed()));

    connect(this, SIGNAL(editTextChanged(QString)), this, SLOT(sltTextChanged(QString)));
//     connect(this, SIGNAL(returnPressed()), lineEdit(), SLOT(selectAll()));
//     connect(this, SIGNAL(currentIndexChanged(int)), SIGNAL(returnPressed()) );
    connect(lineEdit(), SIGNAL(returnPressed()), SIGNAL(returnPressed()) );
}

void MDicComboBox::selectAll()
{
    lineEdit()->selectAll();
}

void MDicComboBox::sltTextChanged(QString text)
{
    setClearButtonShown( !text.isEmpty() );
}

void MDicComboBox::setClearButtonShown(bool show)
{
    d->clearButton->setVisible(show);
}

void MDicComboBox::setCurrentText(const QString& item)
{
    int sel = -1;
    const int itemCount = count();
    for (int i = 0; i < itemCount; ++i)
    {
        if (itemText(i) == item)
        {
            sel = i;
//             moveItem(sel, count()-1);
            break;
        }
    }
    if (sel == -1)
    {
        addItem(item);
        sel = count() - 1;
    }
    setCurrentIndex(sel);
}

void MDicComboBox::updateButtonsGeometry()
{
    const QSize geom = size();
    const int buttonWidth = 20;

    const QSize newButtonSize( buttonWidth, geom.height() );

    if (d->clearButton) {
        d->clearButton->resize(newButtonSize);
        d->clearButton->move(geom.width() -  buttonWidth - 44, 0);
    }


    if (d->searchButton) {
       d->searchButton->resize(newButtonSize);
       d->searchButton->move(geom.width() -  buttonWidth - 22, 0);
    }
}

void MDicComboBox::mousePressEvent(QMouseEvent* e)
{
    if ((e->button() == Qt::LeftButton || e->button() == Qt::MidButton)
            && d->clearButton) {
        d->clickInClear = d->clearButton->underMouse();
    }

    if ((e->button() == Qt::LeftButton || e->button() == Qt::MidButton)
            && d->searchButton) {
        d->clickInEnter = d->searchButton->underMouse();
    }

    QComboBox::mousePressEvent(e);

}

void MDicComboBox::resizeEvent(QResizeEvent* e)
{
    updateButtonsGeometry();

    QComboBox::resizeEvent(e);
}

void MDicComboBox::mouseReleaseEvent(QMouseEvent* e)
{
    if (d->clickInClear) {
        if (e->button() == Qt::MidButton) {
            d->newText = QApplication::clipboard()->text(QClipboard::Selection);
            setCurrentText(d->newText);
        } else {
            clearButtonClicked();
        }
    }

    if (d->clickInEnter) {
        if (e->button() == Qt::MidButton) {
            d->newText = QApplication::clipboard()->text(QClipboard::Selection);
            setCurrentText(d->newText);
        }

        if ( !this->currentText().isEmpty() ) {
            selectAll();
            emit returnPressed();
        }
    }

    QComboBox::mouseReleaseEvent(e);
}

void MDicComboBox::clearButtonClicked()
{
    setEditText(QString());
}

MDicComboBox::~MDicComboBox()
{
    delete d;
}

void MDicComboBox::addItem(const QString& item)
{
    qDebug("MDicComboBox::addItem");
    if( !item.isEmpty() ) {
        if(count() == maxCount())
            QComboBox::removeItem(0);
        QComboBox::addItem(item);
    }
}

void MDicComboBox::removeItem(const QString& item)
{
    const int itemCount = count();
    for (int i = 0; i < itemCount; ++i)
    {
        if (itemText(i) == item)
        {
            QComboBox::removeItem(i);
            return;
        }
    }
}

void MDicComboBox::settingsChanged()
{
    setMaxCount(Settings::self()->histLen);
}

void MDicComboBox::setFocus()
{
    lineEdit()->setFocus();
}

#include "mdiccombobox.moc"
#include "mdicbutton.moc"
