/*
   This file is part of MDic Dictionary

   Copyright (C) 2007-2010 Mehrdad Momeny <mehrdad.momeny@gmail.com
   Copyright (C) 2007-2010 Majid Ramezanpour <majid.ramezanpour@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License,
   (at your option) any later version

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details

   You should have received a copy of the GNU General Public License
   along with this program; if not, see http://www.gnu.org/licenses/
*/

#ifndef MDICTEXTBROWSER_H
#define MDICTEXTBROWSER_H

#define REC_PATH ":/"

#include <QtGui/QTextBrowser>


class MDicTextBrowser: public QTextBrowser
{
    Q_OBJECT

public:

    MDicTextBrowser(QWidget* parent = 0);
    ~MDicTextBrowser();
    static void setStyleColors(const QColor &foreground, const QColor &background);
    void setUiStyle();

private:
    void init();

protected slots:
    virtual void resizeEvent(QResizeEvent* e);
    void setHeight();
    static QString getColorString(const QColor& color);

private:
    static const QString baseStyle;
    static QString style;
};

#endif // MDICTEXTBROWSER_H
