/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.awt.AwtEvents_desktopKt;
import androidx.compose.ui.awt.InteropFocusSwitcher;
import androidx.compose.ui.awt.SwingPanel_desktopKt;
import androidx.compose.ui.draw.DrawModifierKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropPointerInput_skikoKt;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder_desktopKt;
import androidx.compose.ui.viewinterop.TypedInteropViewHolder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B=\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\f\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u00020\u001d2\n\u0010!\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020\u001d2\n\u0010!\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0014\u0010%\u001a\u00020\u001d2\n\u0010!\u001a\u00060\nj\u0002`\u000bH\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u0004\u0018\u00010\u00022\u0006\u00104\u001a\u000205H\u0002R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u0014\u0010.\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010)\u00a8\u00066"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropViewHolder;", "T", "Ljava/awt/Component;", "Landroidx/compose/ui/viewinterop/TypedInteropViewHolder;", "Lorg/jetbrains/skiko/ClipRectangle;", "factory", "Lkotlin/Function0;", "container", "Landroidx/compose/ui/viewinterop/InteropContainer;", "group", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "focusSwitcher", "Landroidx/compose/ui/awt/InteropFocusSwitcher;", "compositeKeyHashCode", "", "Landroidx/compose/runtime/CompositeKeyHashCode;", "<init>", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/viewinterop/InteropContainer;Ljava/awt/Container;Landroidx/compose/ui/awt/InteropFocusSwitcher;J)V", "clipBounds", "Landroidx/compose/ui/unit/IntRect;", "focusListener", "Ljava/awt/event/FocusListener;", "getFocusListener", "()Ljava/awt/event/FocusListener;", "getInteropView", "", "Landroidx/compose/ui/viewinterop/InteropView;", "layoutAccordingTo", "", "layoutCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "insertInteropView", "root", "index", "", "changeInteropViewIndex", "removeInteropView", "x", "", "getX", "()F", "y", "getY", "width", "getWidth", "height", "getHeight", "dispatchToView", "pointerEvent", "Landroidx/compose/ui/input/pointer/PointerEvent;", "getDeepestComponentForEvent", "event", "Ljava/awt/event/MouseEvent;", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSwingInteropViewHolder.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingInteropViewHolder.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropViewHolder\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,187:1\n35#2,5:188\n*S KotlinDebug\n*F\n+ 1 SwingInteropViewHolder.desktop.kt\nandroidx/compose/ui/viewinterop/SwingInteropViewHolder\n*L\n165#1:188,5\n*E\n"})
public final class SwingInteropViewHolder<T extends Component>
extends TypedInteropViewHolder<T>
implements ClipRectangle {
    @Nullable
    private IntRect clipBounds;
    @NotNull
    private final FocusListener focusListener;
    public static final int $stable = 8;

    public SwingInteropViewHolder(@NotNull Function0<? extends T> factory, @NotNull InteropContainer container2, @NotNull Container group, @NotNull InteropFocusSwitcher focusSwitcher, long compositeKeyHashCode) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)focusSwitcher, (String)"focusSwitcher");
        super(factory, container2, group, compositeKeyHashCode, 1.INSTANCE);
        this.focusListener = new FocusListener(group, focusSwitcher){
            final /* synthetic */ Container $group;
            final /* synthetic */ InteropFocusSwitcher $focusSwitcher;
            {
                this.$group = $group;
                this.$focusSwitcher = $focusSwitcher;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingPanel_desktopKt.isFocusGainedHandledBySwingPanel(e, this.$group)) {
                    FocusEvent.Cause cause = e.getCause();
                    switch (cause == null ? -1 : focusListener.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: {
                            this.$focusSwitcher.moveAfterInteropView();
                            break;
                        }
                        case 2: {
                            this.$focusSwitcher.moveBeforeInteropView();
                            break;
                        }
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
        group.add((Component)this.getTypedInteropView());
        this.setPlatformModifier(DrawModifierKt.drawBehind(InteropPointerInput_skikoKt.pointerInteropFilter(Modifier.Companion, this), (Function1<? super DrawScope, Unit>)((Function1)SwingInteropViewHolder::_init_$lambda$0)));
    }

    @NotNull
    public final FocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    @NotNull
    public Object getInteropView() {
        return this.getTypedInteropView();
    }

    @Override
    public void layoutAccordingTo(@NotNull LayoutCoordinates layoutCoordinates) {
        Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"layoutCoordinates");
        LayoutCoordinates rootCoordinates = LayoutCoordinatesKt.findRootCoordinates(layoutCoordinates);
        IntRect clippedBounds = SwingInteropViewHolder_desktopKt.access$round(rootCoordinates.localBoundingBoxOf(layoutCoordinates, true), this.getDensity());
        IntRect bounds = SwingInteropViewHolder_desktopKt.access$round(rootCoordinates.localBoundingBoxOf(layoutCoordinates, false), this.getDensity());
        this.clipBounds = clippedBounds;
        this.getContainer().scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropViewHolder.layoutAccordingTo$lambda$1(this, clippedBounds, bounds)));
    }

    @Override
    public void insertInteropView(@NotNull Container root, int index) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.add((Component)this.getGroup(), index);
        super.insertInteropView(root, index);
        this.getContainer().getRoot().addFocusListener(this.focusListener);
    }

    @Override
    public void changeInteropViewIndex(@NotNull Container root, int index) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.setComponentZOrder(this.getGroup(), index);
    }

    @Override
    public void removeInteropView(@NotNull Container root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.remove(this.getGroup());
        super.removeInteropView(root);
        this.getContainer().getRoot().removeFocusListener(this.focusListener);
    }

    public float getX() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getLeft() : this.getGroup().getX();
    }

    public float getY() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getTop() : this.getGroup().getY();
    }

    public float getWidth() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getWidth() : this.getGroup().getWidth();
    }

    public float getHeight() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getHeight() : this.getGroup().getHeight();
    }

    @Override
    public void dispatchToView(@NotNull PointerEvent pointerEvent) {
        Intrinsics.checkNotNullParameter((Object)pointerEvent, (String)"pointerEvent");
        MouseEvent mouseEvent = AwtEvents_desktopKt.getAwtEventOrNull(pointerEvent);
        if (mouseEvent == null) {
            return;
        }
        MouseEvent e = mouseEvent;
        switch (e.getID()) {
            case 504: 
            case 505: {
                return;
            }
        }
        if (SwingUtilities.isDescendingFrom(e.getComponent(), this.getGroup())) {
            return;
        }
        Component component = this.getDeepestComponentForEvent(e);
        if (component != null) {
            component.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, component));
            List<PointerInputChange> $this$fastForEach$iv = pointerEvent.getChanges();
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                PointerInputChange item$iv;
                PointerInputChange it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                it.consume();
            }
        }
    }

    private final Component getDeepestComponentForEvent(MouseEvent event) {
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), (Component)this.getTypedInteropView());
        return SwingUtilities.getDeepestComponentAt((Component)this.getTypedInteropView(), point.x, point.y);
    }

    private static final Unit _init_$lambda$0(DrawScope $this$drawBehind) {
        Intrinsics.checkNotNullParameter((Object)$this$drawBehind, (String)"$this$drawBehind");
        DrawScope.drawRect-n-J9OG0$default((DrawScope)$this$drawBehind, (long)Color.Companion.getTransparent-0d7_KjU(), (long)0L, (long)0L, (float)0.0f, null, null, (int)BlendMode.Companion.getClear-0nO6VwU(), (int)62, null);
        return Unit.INSTANCE;
    }

    private static final Unit layoutAccordingTo$lambda$1(SwingInteropViewHolder this$0, IntRect $clippedBounds, IntRect $bounds) {
        this$0.getGroup().setVisible(!$clippedBounds.isEmpty());
        this$0.getGroup().setBounds($clippedBounds.getLeft(), $clippedBounds.getTop(), $clippedBounds.getWidth(), $clippedBounds.getHeight());
        ((Component)this$0.getTypedInteropView()).setBounds($bounds.getLeft() - $clippedBounds.getLeft(), $bounds.getTop() - $clippedBounds.getTop(), $bounds.getWidth(), $bounds.getHeight());
        return Unit.INSTANCE;
    }
}

