/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core;

import androidx.datastore.core.Closeable;
import androidx.datastore.core.FileMoves_jvmKt;
import androidx.datastore.core.FileReadScope;
import androidx.datastore.core.FileStorageConnection;
import androidx.datastore.core.FileWriteScope;
import androidx.datastore.core.InterProcessCoordinator;
import androidx.datastore.core.ReadScope;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.StorageConnection;
import androidx.datastore.core.WriteScope;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0016JX\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0001\u0010\u00162B\u0010\u0017\u001a>\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0019\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u0018\u00a2\u0006\u0002\b H\u0096@\u00a2\u0006\u0002\u0010!J=\u0010\"\u001a\u00020\u000b2-\u0010\u0017\u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0#\u00a2\u0006\u0002\b H\u0096@\u00a2\u0006\u0002\u0010%J\f\u0010&\u001a\u00020\u000b*\u00020\u0004H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/datastore/core/FileStorageConnection;", "T", "Landroidx/datastore/core/StorageConnection;", "file", "Ljava/io/File;", "serializer", "Landroidx/datastore/core/Serializer;", "coordinator", "Landroidx/datastore/core/InterProcessCoordinator;", "onClose", "Lkotlin/Function0;", "", "(Ljava/io/File;Landroidx/datastore/core/Serializer;Landroidx/datastore/core/InterProcessCoordinator;Lkotlin/jvm/functions/Function0;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getCoordinator", "()Landroidx/datastore/core/InterProcessCoordinator;", "transactionMutex", "Lkotlinx/coroutines/sync/Mutex;", "checkNotClosed", "close", "readScope", "R", "block", "Lkotlin/Function3;", "Landroidx/datastore/core/ReadScope;", "", "Lkotlin/ParameterName;", "name", "locked", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeScope", "Lkotlin/Function2;", "Landroidx/datastore/core/WriteScope;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createParentDirectories", "datastore-core"})
@SourceDebugExtension(value={"SMAP\nFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStorage.kt\nandroidx/datastore/core/FileStorageConnection\n+ 2 Closeable.kt\nandroidx/datastore/core/CloseableKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n38#2,23:209\n38#2,23:240\n120#3,8:232\n129#3:263\n1#4:264\n*S KotlinDebug\n*F\n+ 1 FileStorage.kt\nandroidx/datastore/core/FileStorageConnection\n*L\n100#1:209,23\n117#1:240,23\n114#1:232,8\n114#1:263\n*E\n"})
public final class FileStorageConnection<T>
implements StorageConnection<T> {
    @NotNull
    private final File file;
    @NotNull
    private final Serializer<T> serializer;
    @NotNull
    private final InterProcessCoordinator coordinator;
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final Mutex transactionMutex;

    public FileStorageConnection(@NotNull File file, @NotNull Serializer<T> serializer, @NotNull InterProcessCoordinator coordinator2, @NotNull Function0<Unit> onClose) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)coordinator2, (String)"coordinator");
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        this.file = file;
        this.serializer = serializer;
        this.coordinator = coordinator2;
        this.onClose = onClose;
        this.closed = new AtomicBoolean(false);
        this.transactionMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @Override
    @NotNull
    public InterProcessCoordinator getCoordinator() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public <R> Object readScope(@NotNull Function3<? super ReadScope<T>, ? super Boolean, ? super Continuation<? super R>, ? extends Object> var1_1, @NotNull Continuation<? super R> var2_2) {
        if (!(var2_2 instanceof readScope.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ FileStorageConnection<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.readScope(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.checkNotClosed();
                lock = Mutex.DefaultImpls.tryLock$default((Mutex)this.transactionMutex, null, (int)1, null);
                $this$use$iv = new FileReadScope<T>(this.file, this.serializer);
                $i$f$use = false;
                thrown$iv = null;
                it = (FileReadScope)$this$use$iv;
                $i$a$-use-FileStorageConnection$readScope$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.Z$0 = lock;
                $continuation.label = 1;
                v0 = block.invoke((Object)it, (Object)Boxing.boxBoolean((boolean)(lock != false)), $continuation);
                ** if (v0 != var12_5) goto lbl30
lbl29:
                // 1 sources

                return var12_5;
lbl30:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-FileStorageConnection$readScope$2 = false;
                lock = $continuation.Z$0;
                thrown$iv = null;
                $this$use$iv = (Closeable)$continuation.L$1;
                this = (FileStorageConnection)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl44:
                    // 2 sources

                    var9_17 = v0;
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable t$iv) {
                        thrown$iv = t$iv;
                    }
                    if (thrown$iv != null) {
                        throw thrown$iv;
                    }
                    ** GOTO lbl80
                    {
                        catch (Throwable t$iv) {
                            try {
                                thrown$iv = t$iv;
                            }
                            catch (Throwable var9_20) {
                                try {
                                    $this$use$iv.close();
                                }
                                catch (Throwable t$iv) {
                                    thrown$iv = t$iv;
                                }
                                if (thrown$iv != null) {
                                    throw thrown$iv;
                                }
                                throw var9_20;
                            }
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable t$iv) {
                                if (thrown$iv != null) ** GOTO lbl75
                                thrown$iv = t$iv;
                                ** GOTO lbl76
lbl75:
                                // 1 sources

                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
                            }
lbl76:
                            // 3 sources

                            if (thrown$iv != null) {
                                throw thrown$iv;
                            }
                        }
                    }
                    throw new IllegalStateException("Unreachable code. If this occurs, please file a bug here:\n        https://b.corp.google.com/issues/new?component=907884&template=1466542".toString());
lbl80:
                    // 1 sources

                    var4_7 = var9_17;
                    return var4_7;
                }
                catch (Throwable var4_8) {
                    throw var4_8;
                }
                finally {
                    if (lock) {
                        Mutex.DefaultImpls.unlock$default((Mutex)this.transactionMutex, null, (int)1, null);
                    }
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Object writeScope(@NotNull Function2<? super WriteScope<T>, ? super Continuation<? super Unit>, ? extends Object> var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof writeScope.1)) ** GOTO lbl-1000
        var15_3 = var2_2;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ FileStorageConnection<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.writeScope(null, (Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.checkNotClosed();
                this.createParentDirectories(this.file);
                $this$withLock_u24default$iv = this.transactionMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = block;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl35
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                block = (Function2)$continuation.L$1;
                this = (FileStorageConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 3 sources

                $i$a$-withLock$default-FileStorageConnection$writeScope$2 = false;
                scratchFile = new File(this.file.getAbsolutePath() + ".tmp");
                try {
                    $this$use$iv = new FileWriteScope<T>(scratchFile, this.serializer);
                    $i$f$use = false;
                    thrown$iv = null;
                    try {
                        it /* !! */  = (FileWriteScope)$this$use$iv;
                        $i$a$-use-FileStorageConnection$writeScope$2$1 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = $this$withLock_u24default$iv;
                        $continuation.L$2 = scratchFile;
                        $continuation.L$3 = $this$use$iv;
                        $continuation.label = 2;
                        v1 = block.invoke((Object)it /* !! */ , (Object)$continuation);
                    }
                    catch (Throwable t$iv) {
                        try {
                            thrown$iv = t$iv;
                        }
                        catch (Throwable var11_22) {
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable t$iv) {
                                thrown$iv = t$iv;
                            }
                            if (thrown$iv == null) throw var11_22;
                            throw thrown$iv;
                        }
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv) {
                            if (thrown$iv != null) ** GOTO lbl75
                            thrown$iv = t$iv;
                            ** GOTO lbl76
lbl75:
                            // 1 sources

                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
                        }
lbl76:
                        // 3 sources

                        if (thrown$iv == null) throw new IllegalStateException("Unreachable code. If this occurs, please file a bug here:\n        https://b.corp.google.com/issues/new?component=907884&template=1466542".toString());
                        throw thrown$iv;
                    }
                }
                catch (IOException ex) {
                    if (scratchFile.exists() == false) throw ex;
                    scratchFile.delete();
                    throw ex;
                }
                v2 = v1;
                if (v1 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl104
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-FileStorageConnection$writeScope$2 = false;
                $i$f$use = false;
                $i$a$-use-FileStorageConnection$writeScope$2$1 = false;
                thrown$iv = null;
                $this$use$iv = (Closeable)$continuation.L$3;
                scratchFile = (File)$continuation.L$2;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (FileStorageConnection)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl104:
                    // 2 sources

                    it /* !! */  = Unit.INSTANCE;
                }
                try {
                    $this$use$iv.close();
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
                if (thrown$iv != null) {
                    throw thrown$iv;
                }
                if (scratchFile.exists() && !FileMoves_jvmKt.atomicMoveTo(scratchFile, this.file)) {
                    throw new IOException("Unable to rename " + scratchFile + " to " + this.file + ". This likely means that there are multiple instances of DataStore for this file. Ensure that you are only creating a single instance of datastore for this file.");
                }
                var13_26 = Unit.INSTANCE;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.onClose.invoke();
    }

    private final void checkNotClosed() {
        if (!(!this.closed.get())) {
            boolean bl = false;
            String string = "StorageConnection has already been disposed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void createParentDirectories(File $this$createParentDirectories) {
        File parent;
        File file = parent = $this$createParentDirectories.getCanonicalFile().getParentFile();
        if (file != null) {
            File it = file;
            boolean bl = false;
            it.mkdirs();
            if (!it.isDirectory()) {
                throw new IOException("Unable to create parent directories of " + $this$createParentDirectories);
            }
        }
    }
}

