/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.Sys;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ldorkbox/util/ScreenUtil;", "", "()V", "monitorAtMouseLocation", "Ljava/awt/GraphicsDevice;", "getMonitorAtMouseLocation", "()Ljava/awt/GraphicsDevice;", "monitorNumberAtMouseLocation", "", "getMonitorNumberAtMouseLocation", "()I", "version", "", "getVersion", "()Ljava/lang/String;", "getMonitorAtLocation", "pos", "Ljava/awt/Point;", "getMonitorNumberAtLocation", "getScreenBoundsAt", "Ljava/awt/Rectangle;", "showOnSameScreenAsMouse", "", "frame", "Ljava/awt/Container;", "showOnSameScreenAsMouse_Center", "Utilities"})
public final class ScreenUtil {
    @NotNull
    public static final ScreenUtil INSTANCE = new ScreenUtil();
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();

    private ScreenUtil() {
    }

    @NotNull
    public final String getVersion() {
        return version;
    }

    @Nullable
    public final Rectangle getScreenBoundsAt(@NotNull Point pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Object object = this.getMonitorAtLocation(pos);
        return object != null && (object = ((GraphicsDevice)object).getDefaultConfiguration()) != null ? ((GraphicsConfiguration)object).getBounds() : null;
    }

    @NotNull
    public final GraphicsDevice getMonitorAtMouseLocation() {
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)mouseLocation, (String)"mouseLocation");
        GraphicsDevice graphicsDevice = this.getMonitorAtLocation(mouseLocation);
        Intrinsics.checkNotNull((Object)graphicsDevice);
        return graphicsDevice;
    }

    @Nullable
    public final GraphicsDevice getMonitorAtLocation(@NotNull Point pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = ge.getScreenDevices();
        Intrinsics.checkNotNullExpressionValue((Object)screenDevices, (String)"screenDevices");
        for (GraphicsDevice device1 : screenDevices) {
            GraphicsConfiguration gc = device1.getDefaultConfiguration();
            Rectangle screenBounds = gc.getBounds();
            if (!screenBounds.contains(pos)) continue;
            return device1;
        }
        return null;
    }

    public final int getMonitorNumberAtMouseLocation() {
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)mouseLocation, (String)"mouseLocation");
        return this.getMonitorNumberAtLocation(mouseLocation);
    }

    public final int getMonitorNumberAtLocation(@NotNull Point pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = ge.getScreenDevices();
        int n = screenDevices.length;
        for (int i = 0; i < n; ++i) {
            GraphicsDevice device1 = screenDevices[i];
            GraphicsConfiguration gc = device1.getDefaultConfiguration();
            Rectangle screenBounds = gc.getBounds();
            if (!screenBounds.contains(pos)) continue;
            return i;
        }
        return 0;
    }

    public final void showOnSameScreenAsMouse_Center(@NotNull Container frame) {
        GraphicsDevice monitorAtMouse;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)mouseLocation, (String)"mouseLocation");
        GraphicsDevice graphicsDevice = monitorAtMouse = this.getMonitorAtLocation(mouseLocation);
        Intrinsics.checkNotNull((Object)graphicsDevice);
        Rectangle bounds = graphicsDevice.getDefaultConfiguration().getBounds();
        frame.setLocation(bounds.x + bounds.width / 2 - frame.getWidth() / 2, bounds.y + bounds.height / 2 - frame.getHeight() / 2);
    }

    public final void showOnSameScreenAsMouse(@NotNull Container frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)mouseLocation, (String)"mouseLocation");
        GraphicsDevice graphicsDevice = this.getMonitorAtLocation(mouseLocation);
        Intrinsics.checkNotNull((Object)graphicsDevice);
        GraphicsDevice monitorAtMouse = graphicsDevice;
        Rectangle bounds = monitorAtMouse.getDefaultConfiguration().getBounds();
        frame.setLocation(bounds.x, bounds.y);
    }
}

