/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.utils.proxy;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.desktop.utils.proxy.ProxyCachingConfig;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProxyListFallbackSelector;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import com.github.markusbernhardt.proxy.selector.pac.UrlPacScriptSource;
import ir.amirab.downloader.connection.proxy.AutoConfigurableProxyProvider;
import java.net.ProxySelector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/abdownloadmanager/desktop/utils/proxy/AutoConfigurableProxyProviderForDesktop;", "Lir/amirab/downloader/connection/proxy/AutoConfigurableProxyProvider;", "proxyCachingConfig", "Lcom/abdownloadmanager/desktop/utils/proxy/ProxyCachingConfig;", "<init>", "(Lcom/abdownloadmanager/desktop/utils/proxy/ProxyCachingConfig;)V", "packProxySelector", "Ljava/net/ProxySelector;", "lastUsedUri", "", "getAutoConfigurableProxy", "uri", "createAndInitializePacProxySelector", "installBufferingAndFallbackBehaviour", "selector", "app"})
@StabilityInferred(parameters=0)
public final class AutoConfigurableProxyProviderForDesktop
implements AutoConfigurableProxyProvider {
    @NotNull
    private final ProxyCachingConfig proxyCachingConfig;
    @Nullable
    private volatile ProxySelector packProxySelector;
    @Nullable
    private volatile String lastUsedUri;
    public static final int $stable = 8;

    public AutoConfigurableProxyProviderForDesktop(@NotNull ProxyCachingConfig proxyCachingConfig) {
        Intrinsics.checkNotNullParameter((Object)proxyCachingConfig, (String)"proxyCachingConfig");
        this.proxyCachingConfig = proxyCachingConfig;
    }

    @Nullable
    public ProxySelector getAutoConfigurableProxy(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (Intrinsics.areEqual((Object)this.lastUsedUri, (Object)uri)) {
            ProxySelector o = this.packProxySelector;
            ProxySelector proxySelector = o;
            if (proxySelector == null) {
                proxySelector = this.createAndInitializePacProxySelector(uri);
            }
            return proxySelector;
        }
        return this.createAndInitializePacProxySelector(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProxySelector createAndInitializePacProxySelector(String uri) {
        AutoConfigurableProxyProviderForDesktop autoConfigurableProxyProviderForDesktop = this;
        synchronized (autoConfigurableProxyProviderForDesktop) {
            boolean bl = false;
            ProxySelector s = this.installBufferingAndFallbackBehaviour((ProxySelector)new PacProxySelector((PacScriptSource)new UrlPacScriptSource(uri)));
            this.lastUsedUri = uri;
            this.packProxySelector = s;
            ProxySelector proxySelector = s;
            return proxySelector;
        }
    }

    private final ProxySelector installBufferingAndFallbackBehaviour(ProxySelector selector) {
        ProxySelector selector2 = selector;
        if (selector2 instanceof PacProxySelector) {
            if (this.proxyCachingConfig.getPacCacheSize() > 0) {
                selector2 = (ProxySelector)new BufferedProxySelector(this.proxyCachingConfig.getPacCacheSize(), this.proxyCachingConfig.getPacCacheTTL(), selector2, this.proxyCachingConfig.getPacCacheScope());
            }
            selector2 = (ProxySelector)new ProxyListFallbackSelector(selector2);
        }
        return selector2;
    }
}

