/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.downloader.connection.response;

import ir.amirab.downloader.connection.response.ResponseInfoKt;
import ir.amirab.downloader.connection.response.headers.ContentRangeValue;
import ir.amirab.downloader.connection.response.headers.FileNameExtractorKt;
import ir.amirab.downloader.connection.response.headers.RangeHeaderExtractorKt;
import ir.amirab.downloader.utils.FileNameUtil;
import ir.amirab.util.UrlUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b%\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010:\u001a\u00020\u0003H\u00c6\u0003J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\t\u0010<\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0003J\u0015\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0003JS\u0010?\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0001J\u0013\u0010@\u001a\u00020\u00152\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001J\t\u0010C\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0014\u0010\u0016R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0018\u001a\u0004\b \u0010!R\u001d\u0010#\u001a\u0004\u0018\u00010\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0018\u001a\u0004\b$\u0010\u001cR\u001b\u0010&\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0018\u001a\u0004\b'\u0010\u0016R\u001b\u0010)\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0018\u001a\u0004\b*\u0010\u0016R\u001b\u0010,\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\u0018\u001a\u0004\b,\u0010\u0016R\u001b\u0010.\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0018\u001a\u0004\b/\u0010\u0016R\u001d\u00101\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u0018\u001a\u0004\b2\u0010\u000fR\u001d\u00104\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u0018\u001a\u0004\b5\u0010\u000fR\u001d\u00107\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u0018\u001a\u0004\b8\u0010\u000f\u00a8\u0006D"}, d2={"Lir/amirab/downloader/connection/response/ResponseInfo;", "", "statusCode", "", "message", "", "requestUrl", "requestHeaders", "", "responseHeaders", "<init>", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "getStatusCode", "()I", "getMessage", "()Ljava/lang/String;", "getRequestUrl", "getRequestHeaders", "()Ljava/util/Map;", "getResponseHeaders", "isSuccessFul", "", "()Z", "isSuccessFul$delegate", "Lkotlin/Lazy;", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "contentLength$delegate", "contentRange", "Lir/amirab/downloader/connection/response/headers/ContentRangeValue;", "getContentRange", "()Lir/amirab/downloader/connection/response/headers/ContentRangeValue;", "contentRange$delegate", "totalLength", "getTotalLength", "totalLength$delegate", "requiresAuth", "getRequiresAuth", "requiresAuth$delegate", "requireBasicAuth", "getRequireBasicAuth", "requireBasicAuth$delegate", "isPartial", "isPartial$delegate", "resumeSupport", "getResumeSupport", "resumeSupport$delegate", "fileName", "getFileName", "fileName$delegate", "lastModified", "getLastModified", "lastModified$delegate", "etag", "getEtag", "etag$delegate", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nResponseInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseInfo.kt\nir/amirab/downloader/connection/response/ResponseInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IfThen.kt\nir/amirab/util/IfThenKt\n*L\n1#1,91:1\n1#2:92\n4#3,4:93\n*S KotlinDebug\n*F\n+ 1 ResponseInfo.kt\nir/amirab/downloader/connection/response/ResponseInfo\n*L\n63#1:93,4\n*E\n"})
public final class ResponseInfo {
    private final int statusCode;
    @NotNull
    private final String message;
    @NotNull
    private final String requestUrl;
    @NotNull
    private final Map<String, String> requestHeaders;
    @NotNull
    private final Map<String, String> responseHeaders;
    @NotNull
    private final Lazy isSuccessFul$delegate;
    @NotNull
    private final Lazy contentLength$delegate;
    @NotNull
    private final Lazy contentRange$delegate;
    @NotNull
    private final Lazy totalLength$delegate;
    @NotNull
    private final Lazy requiresAuth$delegate;
    @NotNull
    private final Lazy requireBasicAuth$delegate;
    @NotNull
    private final Lazy isPartial$delegate;
    @NotNull
    private final Lazy resumeSupport$delegate;
    @NotNull
    private final Lazy fileName$delegate;
    @NotNull
    private final Lazy lastModified$delegate;
    @NotNull
    private final Lazy etag$delegate;

    public ResponseInfo(int statusCode, @NotNull String message, @NotNull String requestUrl, @NotNull Map<String, String> requestHeaders, @NotNull Map<String, String> responseHeaders) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)requestUrl, (String)"requestUrl");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        this.statusCode = statusCode;
        this.message = message;
        this.requestUrl = requestUrl;
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
        this.isSuccessFul$delegate = LazyKt.lazy(() -> ResponseInfo.isSuccessFul_delegate$lambda$0(this));
        this.contentLength$delegate = LazyKt.lazy(() -> ResponseInfo.contentLength_delegate$lambda$0(this));
        this.contentRange$delegate = LazyKt.lazy(() -> ResponseInfo.contentRange_delegate$lambda$0(this));
        this.totalLength$delegate = LazyKt.lazy(() -> ResponseInfo.totalLength_delegate$lambda$0(this));
        this.requiresAuth$delegate = LazyKt.lazy(() -> ResponseInfo.requiresAuth_delegate$lambda$0(this));
        this.requireBasicAuth$delegate = LazyKt.lazy(() -> ResponseInfo.requireBasicAuth_delegate$lambda$0(this));
        this.isPartial$delegate = LazyKt.lazy(() -> ResponseInfo.isPartial_delegate$lambda$0(this));
        this.resumeSupport$delegate = LazyKt.lazy(() -> ResponseInfo.resumeSupport_delegate$lambda$0(this));
        this.fileName$delegate = LazyKt.lazy(() -> ResponseInfo.fileName_delegate$lambda$0(this));
        this.lastModified$delegate = LazyKt.lazy(() -> ResponseInfo.lastModified_delegate$lambda$0(this));
        this.etag$delegate = LazyKt.lazy(() -> ResponseInfo.etag_delegate$lambda$0(this));
    }

    public /* synthetic */ ResponseInfo(int n, String string, String string2, Map map, Map map2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            map = new LinkedHashMap();
        }
        if ((n2 & 0x10) != 0) {
            map2 = new LinkedHashMap();
        }
        this(n, string, string2, map, map2);
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final String getRequestUrl() {
        return this.requestUrl;
    }

    @NotNull
    public final Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @NotNull
    public final Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public final boolean isSuccessFul() {
        Lazy lazy = this.isSuccessFul$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final Long getContentLength() {
        Lazy lazy = this.contentLength$delegate;
        return (Long)lazy.getValue();
    }

    @Nullable
    public final ContentRangeValue getContentRange() {
        Lazy lazy = this.contentRange$delegate;
        return (ContentRangeValue)lazy.getValue();
    }

    @Nullable
    public final Long getTotalLength() {
        Lazy lazy = this.totalLength$delegate;
        return (Long)lazy.getValue();
    }

    public final boolean getRequiresAuth() {
        Lazy lazy = this.requiresAuth$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getRequireBasicAuth() {
        Lazy lazy = this.requireBasicAuth$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isPartial() {
        Lazy lazy = this.isPartial$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean getResumeSupport() {
        Lazy lazy = this.resumeSupport$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final String getFileName() {
        Lazy lazy = this.fileName$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getLastModified() {
        Lazy lazy = this.lastModified$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getEtag() {
        Lazy lazy = this.etag$delegate;
        return (String)lazy.getValue();
    }

    public final int component1() {
        return this.statusCode;
    }

    @NotNull
    public final String component2() {
        return this.message;
    }

    @NotNull
    public final String component3() {
        return this.requestUrl;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.requestHeaders;
    }

    @NotNull
    public final Map<String, String> component5() {
        return this.responseHeaders;
    }

    @NotNull
    public final ResponseInfo copy(int statusCode, @NotNull String message, @NotNull String requestUrl, @NotNull Map<String, String> requestHeaders, @NotNull Map<String, String> responseHeaders) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)requestUrl, (String)"requestUrl");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        return new ResponseInfo(statusCode, message, requestUrl, requestHeaders, responseHeaders);
    }

    public static /* synthetic */ ResponseInfo copy$default(ResponseInfo responseInfo, int n, String string, String string2, Map map, Map map2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = responseInfo.statusCode;
        }
        if ((n2 & 2) != 0) {
            string = responseInfo.message;
        }
        if ((n2 & 4) != 0) {
            string2 = responseInfo.requestUrl;
        }
        if ((n2 & 8) != 0) {
            map = responseInfo.requestHeaders;
        }
        if ((n2 & 0x10) != 0) {
            map2 = responseInfo.responseHeaders;
        }
        return responseInfo.copy(n, string, string2, map, map2);
    }

    @NotNull
    public String toString() {
        return "ResponseInfo(statusCode=" + this.statusCode + ", message=" + this.message + ", requestUrl=" + this.requestUrl + ", requestHeaders=" + this.requestHeaders + ", responseHeaders=" + this.responseHeaders + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.statusCode);
        result2 = result2 * 31 + this.message.hashCode();
        result2 = result2 * 31 + this.requestUrl.hashCode();
        result2 = result2 * 31 + ((Object)this.requestHeaders).hashCode();
        result2 = result2 * 31 + ((Object)this.responseHeaders).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResponseInfo)) {
            return false;
        }
        ResponseInfo responseInfo = (ResponseInfo)other;
        if (this.statusCode != responseInfo.statusCode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)responseInfo.message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestUrl, (Object)responseInfo.requestUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.requestHeaders, responseInfo.requestHeaders)) {
            return false;
        }
        return Intrinsics.areEqual(this.responseHeaders, responseInfo.responseHeaders);
    }

    private static final boolean isSuccessFul_delegate$lambda$0(ResponseInfo this$0) {
        int n = this$0.statusCode;
        return 200 <= n ? n < 300 : false;
    }

    private static final Long contentLength_delegate$lambda$0(ResponseInfo this$0) {
        Object object;
        Object object2 = this$0.responseHeaders.get("content-length");
        if (object2 != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null) {
            Object object3 = object2;
            long it = ((Number)object3).longValue();
            boolean bl = false;
            object = it >= 0L ? object3 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final ContentRangeValue contentRange_delegate$lambda$0(ResponseInfo this$0) {
        return RangeHeaderExtractorKt.getContentRange(this$0);
    }

    private static final Long totalLength_delegate$lambda$0(ResponseInfo this$0) {
        Object object;
        Long l = this$0.getContentLength();
        if (l == null) {
            return null;
        }
        long responseLength = l;
        return this$0.isPartial() ? ((object = this$0.getContentRange()) != null && (object = ((ContentRangeValue)object).getFullSize()) != null ? (Long)object : responseLength) : responseLength;
    }

    private static final boolean requiresAuth_delegate$lambda$0(ResponseInfo this$0) {
        return this$0.statusCode == 401;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean requireBasicAuth_delegate$lambda$0(ResponseInfo this$0) {
        if (!this$0.getRequiresAuth()) return false;
        String string = this$0.responseHeaders.get("www-authenticate");
        if (string == null) return false;
        boolean bl = StringsKt.contains((CharSequence)string, (CharSequence)"basic", (boolean)true);
        if (!bl) return false;
        return true;
    }

    private static final boolean isPartial_delegate$lambda$0(ResponseInfo this$0) {
        return this$0.statusCode == 206;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean resumeSupport_delegate$lambda$0(ResponseInfo this$0) {
        if (!this$0.isPartial()) return false;
        if (this$0.getContentLength() == null) return false;
        ContentRangeValue contentRangeValue = this$0.getContentRange();
        if (contentRangeValue == null) return false;
        Long l = contentRangeValue.getFullSize();
        if (l == null) return false;
        return true;
    }

    private static final String fileName_delegate$lambda$0(ResponseInfo this$0) {
        String string;
        String nameFromHeader;
        String string2;
        String string3;
        ResponseInfo $this$fileName_delegate_u24lambda_u240_u240 = this$0;
        boolean bl = false;
        String string4 = $this$fileName_delegate_u24lambda_u240_u240.responseHeaders.get("content-disposition");
        if (string4 != null) {
            String it = string4;
            boolean bl2 = false;
            string3 = FileNameExtractorKt.extractFileNameFromContentDisposition(it);
        } else {
            string3 = null;
        }
        if ((string2 = (nameFromHeader = string3)) == null) {
            string2 = UrlUtils.INSTANCE.extractNameFromLink($this$fileName_delegate_u24lambda_u240_u240.requestUrl);
        }
        String string5 = string2;
        if (string2 == null) {
            string5 = "";
        }
        String string6 = string5;
        boolean condition$iv = ResponseInfoKt.isWebPage(this$0);
        boolean $i$f$ifThen = false;
        if (condition$iv) {
            void $this$fileName_delegate_u24lambda_u240_u241 = $this$ifThen$iv;
            boolean bl3 = false;
            string = FileNameUtil.INSTANCE.replaceExtension((String)$this$fileName_delegate_u24lambda_u240_u241, "html", true);
        } else {
            string = $this$ifThen$iv;
        }
        String it = string6 = string;
        boolean bl4 = false;
        return ((CharSequence)it).length() > 0 ? string6 : null;
    }

    private static final String lastModified_delegate$lambda$0(ResponseInfo this$0) {
        return this$0.responseHeaders.get("last-modified");
    }

    private static final String etag_delegate$lambda$0(ResponseInfo this$0) {
        return this$0.responseHeaders.get("etag");
    }
}

