/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.util.CacheUtil;
import dorkbox.util.IO;
import dorkbox.util.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class ImageResizeUtil {
    private static final Pattern JAR_URL_REGEX = Pattern.compile(".*.jar!.*");
    private final CacheUtil cache;

    public ImageResizeUtil(CacheUtil cache) {
        this.cache = cache;
    }

    public File getTransparentImage() {
        return this.getTransparentImage(4);
    }

    public File getTransparentImage(int imageSize) {
        try {
            File newFile = this.cache.create(imageSize + "_empty.png");
            return ImageUtil.createImage((int)imageSize, (File)newFile, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate transparent image! Something is severely wrong!");
        }
    }

    public synchronized File getErrorImage(int size) {
        if (size <= 0) {
            size = 32;
        }
        try {
            InputStream imageStream = ImageResizeUtil.class.getResource("error_32.png").openStream();
            imageStream = ImageResizeUtil.makeByteArrayInputStream(imageStream);
            imageStream.mark(0);
            String cacheName = size + "_" + CacheUtil.Companion.createNameAsHash(imageStream);
            ((ByteArrayInputStream)imageStream).reset();
            File check = this.cache.check(cacheName);
            if (check != null) {
                return check;
            }
            File resizedFile = this.resizeFileNoCheck(size, imageStream);
            return this.cache.save(cacheName, resizedFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Serious problems! Unable to extract error image, this should NEVER happen!", e);
        }
    }

    private File resizeAndCache(int size, File file) {
        return this.resizeAndCache(size, file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File resizeAndCache(int size, String fileName) {
        if (fileName == null) {
            return null;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("Resizing image to " + size + " : " + fileName);
        }
        InputStream inputStream = null;
        try {
            Serializable jarResource;
            if (JAR_URL_REGEX.matcher(fileName).matches()) {
                jarResource = new URL(fileName);
                inputStream = jarResource.openStream();
            } else {
                inputStream = new FileInputStream(fileName);
            }
            jarResource = this.resizeAndCache(size, inputStream);
            return jarResource;
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            File file = this.getErrorImage(size);
            return file;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized File resizeAndCache(int size, InputStream imageStream) {
        String cacheName;
        if (imageStream == null) {
            return null;
        }
        boolean needsResize = true;
        try {
            imageStream = ImageResizeUtil.makeByteArrayInputStream(imageStream);
            imageStream.mark(0);
            cacheName = size + "_" + CacheUtil.Companion.createNameAsHash(imageStream);
            ((ByteArrayInputStream)imageStream).reset();
            File check = this.cache.check(cacheName);
            if (check != null && check.canRead()) {
                File file = check;
                return file;
            }
            imageStream.mark(0);
            Dimension imageSize = ImageUtil.getImageSize((InputStream)imageStream);
            if (size == (int)imageSize.getHeight() && size == (int)imageSize.getWidth()) {
                needsResize = false;
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error getting image size. Using error icon instead", (Throwable)e);
            File imageSize = this.getErrorImage(size);
            return imageSize;
        }
        finally {
            ((ByteArrayInputStream)imageStream).reset();
        }
        if (needsResize) {
            try {
                File resizedFile = this.resizeFileNoCheck(size, imageStream);
                try {
                    return this.cache.save(cacheName, resizedFile);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)e);
                    return this.getErrorImage(size);
                }
            }
            catch (Exception e) {
                SystemTray.logger.error("Error resizing image. Using error icon instead", (Throwable)e);
                return this.getErrorImage(size);
            }
        }
        try {
            return this.cache.save(cacheName, imageStream);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)e);
            return this.getErrorImage(size);
        }
    }

    private static InputStream makeByteArrayInputStream(InputStream imageStream) throws IOException {
        if (!(imageStream instanceof ByteArrayInputStream)) {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream((InputStream)imageStream);
            imageStream.close();
            imageStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return imageStream;
    }

    private File resizeFileNoCheck(int size, InputStream inputStream) throws IOException {
        File newFile = this.cache.create("temp_resize.png");
        newFile.delete();
        BufferedImage image = ImageIO.read(inputStream);
        ImageUtil.waitForImageLoad((Image)image);
        BufferedImage bufferedImage = ImageUtil.getBufferedImage((Image)image);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        bufferedImage = width > height ? ImageUtil.resizeImage((BufferedImage)bufferedImage, (int)size, (int)-1) : ImageUtil.resizeImage((BufferedImage)bufferedImage, (int)-1, (int)size);
        bufferedImage = ImageUtil.getSquareBufferedImage((Image)bufferedImage);
        ImageIO.write((RenderedImage)bufferedImage, "png", newFile);
        return newFile;
    }

    public File shouldResizeOrCache(boolean isTrayImage, File imageFile) {
        if (imageFile == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            int size = ImageResizeUtil.getSize(isTrayImage);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image to " + size + " : " + imageFile);
            }
            return this.resizeAndCache(size, imageFile);
        }
        return imageFile;
    }

    public File shouldResizeOrCache(boolean isTrayImage, String imagePath) {
        if (imagePath == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            int size = ImageResizeUtil.getSize(isTrayImage);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image to " + size + " : " + imagePath);
            }
            return this.resizeAndCache(size, imagePath);
        }
        return new File(imagePath);
    }

    public File shouldResizeOrCache(boolean isTrayImage, URL imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        int size = ImageResizeUtil.getSize(isTrayImage);
        try {
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image to " + size + " : " + imageUrl);
                }
                InputStream inputStream = imageUrl.openStream();
                File file = this.resizeAndCache(size, inputStream);
                inputStream.close();
                return file;
            }
            return this.cache.save(imageUrl);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            return this.getErrorImage(size);
        }
    }

    public File shouldResizeOrCache(boolean isTrayImage, InputStream imageStream) {
        if (imageStream == null) {
            return null;
        }
        int size = ImageResizeUtil.getSize(isTrayImage);
        if (SystemTray.AUTO_SIZE) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image-stream to " + size);
            }
            return this.resizeAndCache(size, imageStream);
        }
        try {
            return this.cache.save(imageStream);
        }
        catch (IOException e) {
            SystemTray.logger.error("Error checking cache for information. Using error icon instead", (Throwable)e);
            return this.getErrorImage(size);
        }
    }

    public File shouldResizeOrCache(boolean isTrayImage, Image image) {
        if (image == null) {
            return null;
        }
        int size = ImageResizeUtil.getSize(isTrayImage);
        try {
            File file;
            ImageUtil.waitForImageLoad((Image)image);
            BufferedImage bufferedImage = ImageUtil.getBufferedImage((Image)image);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", os);
            ByteArrayInputStream imageInputStream = new ByteArrayInputStream(os.toByteArray());
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image to " + size);
                }
                file = this.resizeAndCache(size, imageInputStream);
            } else {
                file = this.cache.save((InputStream)imageInputStream);
            }
            ((InputStream)imageInputStream).close();
            return file;
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            return this.getErrorImage(size);
        }
    }

    public File shouldResizeOrCache(boolean isTrayImage, ImageInputStream imageStream) {
        if (imageStream == null) {
            return null;
        }
        int size = ImageResizeUtil.getSize(isTrayImage);
        try {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream((ImageInputStream)imageStream);
            ByteArrayInputStream fileStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image-stream to " + size);
                }
                return this.resizeAndCache(size, fileStream);
            }
            return this.cache.save((InputStream)fileStream);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)e);
            return this.getErrorImage(size);
        }
    }

    private static int getSize(boolean isTrayImage) {
        int size = isTrayImage ? SizeAndScaling.TRAY_SIZE : SizeAndScaling.TRAY_MENU_SIZE;
        return size;
    }
}

