/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.jna.ClassUtils;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SystemTrayFixes;
import java.util.concurrent.atomic.AtomicBoolean;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class SystemTrayFixesMacOS {
    private static AtomicBoolean loaded = new AtomicBoolean(false);

    public static void fix() {
        if (loaded.getAndSet(true)) {
            return;
        }
        if (SystemTrayFixes.isSwingTrayLoaded("sun.lwawt.macosx.CTrayIcon")) {
            throw new RuntimeException("Unable to initialize the AWT System Tray, it has already been created!");
        }
        ClassPool pool = ClassPool.getDefault();
        try {
            CtClass trayIconClass = pool.get("java.awt.TrayIcon");
            CtField peer = trayIconClass.getField("peer");
            peer.setModifiers(peer.getModifiers() & 1);
            ClassUtils.defineClass(null, (byte[])trayIconClass.toBytecode());
            CtClass trayClass = pool.get("sun.lwawt.macosx.CTrayIcon");
            CtMethod method2 = CtNewMethod.make((String)"public java.awt.geom.Point2D getIconLocation(long ptr) {return nativeGetIconLocation(ptr);}", (CtClass)trayClass);
            trayClass.addMethod(method2);
            CtClass dynamicClass = pool.makeClass("sun.lwawt.macosx.CTrayIconLocationAccessory");
            dynamicClass.addInterface(pool.get("sun.lwawt.macosx.CFRetainedResource$CFNativeAction"));
            CtField ctField = new CtField(pool.get("java.util.concurrent.atomic.AtomicReference"), "ref", dynamicClass);
            dynamicClass.addField(ctField, "new java.util.concurrent.atomic.AtomicReference();");
            ctField = new CtField(pool.get("sun.lwawt.macosx.CTrayIcon"), "icon", dynamicClass);
            dynamicClass.addField(ctField);
            CtMethod method3 = CtNewMethod.make((String)"public void run(long ptr){ref.set(icon.getIconLocation(ptr));}", (CtClass)dynamicClass);
            dynamicClass.addMethod(method3);
            ClassUtils.defineClass(null, (byte[])dynamicClass.toBytecode());
            CtMethod method = CtNewMethod.make((String)"public java.awt.geom.Point2D getLocation() { sun.lwawt.macosx.CTrayIconLocationAccessory refAccess = new sun.lwawt.macosx.CTrayIconLocationAccessory();refAccess.icon = this;execute(refAccess);return refAccess.ref.get();}", (CtClass)trayClass);
            trayClass.addMethod(method);
            ClassUtils.defineClass(null, (byte[])trayClass.toBytecode());
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully added getLocation() to macOS AWT tray menus");
            }
            CtClass dynamicClass2 = pool.makeClass("java.awt.MenuComponentAccessory");
            method = CtNewMethod.make((String)"public static Object getPeer(java.awt.MenuComponent nativeComp) { return sun.awt.AWTAccessor.getMenuComponentAccessor().getPeer(nativeComp);}", (CtClass)dynamicClass2);
            dynamicClass2.addMethod(method);
            method = CtNewMethod.make((String)"public static void setImage(Object peerObj, java.awt.Image img) { ((sun.lwawt.macosx.CMenuItem)peerObj).setImage(img);}", (CtClass)dynamicClass2);
            dynamicClass2.addMethod(method);
            method = CtNewMethod.make((String)"public static void setToolTipText(Object peerObj, String text) { ((sun.lwawt.macosx.CMenuItem)peerObj).setToolTipText(text);}", (CtClass)dynamicClass2);
            dynamicClass2.addMethod(method);
            method = CtNewMethod.make((String)"public static void showPopup(java.awt.Component component, java.awt.Menu nativeComponent) { java.awt.peer.PopupMenuPeer peer = (java.awt.peer.PopupMenuPeer) getPeer(nativeComponent);peer.show(new java.awt.Event(component, 0L, java.awt.Event.MOUSE_DOWN, 0, 0, 0, 0));}", (CtClass)dynamicClass2);
            dynamicClass2.addMethod(method);
            method = CtNewMethod.make((String)"public static java.awt.geom.Point2D getLocation(java.awt.TrayIcon trayIcon) { return ((sun.lwawt.macosx.CTrayIcon) trayIcon.peer).getLocation();}", (CtClass)dynamicClass2);
            dynamicClass2.addMethod(method);
            dynamicClass2.setModifiers(dynamicClass2.getModifiers() & 0xFFFFFFF7);
            byte[] dynamicClassBytes = dynamicClass2.toBytecode();
            ClassUtils.defineClass(null, (byte[])dynamicClassBytes);
            CtClass classFixer = pool.get("dorkbox.systemTray.util.AwtAccessor");
            CtMethod ctMethod = classFixer.getDeclaredMethod("getPeer");
            ctMethod.setBody("{return java.awt.MenuComponentAccessory.getPeer($1);}");
            ctMethod.getMethodInfo().rebuildStackMapForME(pool);
            ctMethod = classFixer.getDeclaredMethod("setImage");
            ctMethod.setBody("{java.awt.MenuComponentAccessory.setImage($1, $2);}");
            ctMethod.getMethodInfo().rebuildStackMapForME(pool);
            ctMethod = classFixer.getDeclaredMethod("setToolTipText");
            ctMethod.setBody("{java.awt.MenuComponentAccessory.setToolTipText($1, $2);}");
            ctMethod.getMethodInfo().rebuildStackMapForME(pool);
            ctMethod = classFixer.getDeclaredMethod("showPopup");
            ctMethod.setBody("{return java.awt.MenuComponentAccessory.showPopup($1, $2);}");
            ctMethod.getMethodInfo().rebuildStackMapForME(pool);
            ctMethod = classFixer.getDeclaredMethod("getLocation");
            ctMethod.setBody("{return java.awt.MenuComponentAccessory.getLocation($1);}");
            ctMethod.getMethodInfo().rebuildStackMapForME(pool);
            byte[] classFixerBytes = classFixer.toBytecode();
            ClassUtils.defineClass((ClassLoader)ClassLoader.getSystemClassLoader(), (byte[])classFixerBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully added images/tooltips to macOS AWT tray menus");
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error adding SystemTray images/tooltips for macOS AWT tray menus.", (Throwable)e);
        }
    }
}

