"use strict";
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateNodeTransportOptions = void 0;
const protocol_1 = require("@connectrpc/connect/protocol");
const compression_js_1 = require("./compression.js");
const node_universal_client_js_1 = require("./node-universal-client.js");
const http2_session_manager_js_1 = require("./http2-session-manager.js");
/**
 * Asserts that the options are within sane limits, and returns default values
 * where no value is provided.
 *
 * @private Internal code, does not follow semantic versioning.
 */
function validateNodeTransportOptions(options) {
    var _a, _b, _c, _d;
    let httpClient;
    if (options.httpVersion == "2") {
        let sessionManager;
        if (options.sessionManager) {
            sessionManager = options.sessionManager;
        }
        else {
            sessionManager = new http2_session_manager_js_1.Http2SessionManager(options.baseUrl, {
                pingIntervalMs: options.pingIntervalMs,
                pingIdleConnection: options.pingIdleConnection,
                pingTimeoutMs: options.pingTimeoutMs,
                idleConnectionTimeoutMs: options.idleConnectionTimeoutMs,
            }, options.nodeOptions);
        }
        httpClient = (0, node_universal_client_js_1.createNodeHttpClient)({
            httpVersion: "2",
            sessionProvider: () => sessionManager,
        });
    }
    else {
        httpClient = (0, node_universal_client_js_1.createNodeHttpClient)({
            httpVersion: "1.1",
            nodeOptions: options.nodeOptions,
        });
    }
    return Object.assign(Object.assign(Object.assign({}, options), { httpClient, useBinaryFormat: (_a = options.useBinaryFormat) !== null && _a !== void 0 ? _a : true, interceptors: (_b = options.interceptors) !== null && _b !== void 0 ? _b : [], sendCompression: (_c = options.sendCompression) !== null && _c !== void 0 ? _c : null, acceptCompression: (_d = options.acceptCompression) !== null && _d !== void 0 ? _d : [
            compression_js_1.compressionGzip,
            compression_js_1.compressionBrotli,
        ] }), (0, protocol_1.validateReadWriteMaxBytes)(options.readMaxBytes, options.writeMaxBytes, options.compressMinBytes));
}
exports.validateNodeTransportOptions = validateNodeTransportOptions;
