"use strict";
// Copyright 2021-2024 The Connect Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable @typescript-eslint/no-unsafe-argument,@typescript-eslint/no-floating-promises */
const http2_session_manager_js_1 = require("../http2-session-manager.js");
const http2 = require("http2");
const worker_threads_1 = require("worker_threads");
const sm = new http2_session_manager_js_1.Http2SessionManager(worker_threads_1.workerData, {
    pingIntervalMs: 5, // intentionally short for faster tests
});
sm.request("POST", "/", {}, {}).then((req) => {
    req.close(http2.constants.NGHTTP2_NO_ERROR, () => setTimeout(() => {
        sm.request("POST", "/", {}, {}).then((req) => {
            req.close(http2.constants.NGHTTP2_NO_ERROR, () => {
                worker_threads_1.parentPort.postMessage("done");
            });
        });
    }, 10));
});
