/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

"use strict";var e=require("@lexical/utils"),t=require("lexical"),n=require("@lexical/clipboard");const o=/^(\d+(?:\.\d+)?)px$/,r={BOTH:3,COLUMN:2,NO_STATUS:0,ROW:1};class l extends t.ElementNode{static getType(){return"tablecell"}static clone(e){return new l(e.__headerState,e.__colSpan,e.__width,e.__key)}afterCloneFrom(e){super.afterCloneFrom(e),this.__rowSpan=e.__rowSpan,this.__backgroundColor=e.__backgroundColor,this.__verticalAlign=e.__verticalAlign}static importDOM(){return{td:e=>({conversion:i,priority:0}),th:e=>({conversion:i,priority:0})}}static importJSON(e){return a().updateFromJSON(e)}updateFromJSON(e){return super.updateFromJSON(e).setHeaderStyles(e.headerState).setColSpan(e.colSpan||1).setRowSpan(e.rowSpan||1).setWidth(e.width||void 0).setBackgroundColor(e.backgroundColor||null).setVerticalAlign(e.verticalAlign||void 0)}constructor(e=r.NO_STATUS,t=1,n,o){super(o),this.__colSpan=t,this.__rowSpan=1,this.__headerState=e,this.__width=n,this.__backgroundColor=null,this.__verticalAlign=void 0}createDOM(t){const n=document.createElement(this.getTag());return this.__width&&(n.style.width=`${this.__width}px`),this.__colSpan>1&&(n.colSpan=this.__colSpan),this.__rowSpan>1&&(n.rowSpan=this.__rowSpan),null!==this.__backgroundColor&&(n.style.backgroundColor=this.__backgroundColor),s(this.__verticalAlign)&&(n.style.verticalAlign=this.__verticalAlign),e.addClassNamesToElement(n,t.theme.tableCell,this.hasHeader()&&t.theme.tableCellHeader),n}exportDOM(e){const n=super.exportDOM(e);if(t.isHTMLElement(n.element)){const e=n.element;e.setAttribute("data-temporary-table-cell-lexical-key",this.getKey()),e.style.border="1px solid black",this.__colSpan>1&&(e.colSpan=this.__colSpan),this.__rowSpan>1&&(e.rowSpan=this.__rowSpan),e.style.width=`${this.getWidth()||75}px`,e.style.verticalAlign=this.getVerticalAlign()||"top",e.style.textAlign="start",null===this.__backgroundColor&&this.hasHeader()&&(e.style.backgroundColor="#f2f3f5")}return n}exportJSON(){return{...super.exportJSON(),...s(this.__verticalAlign)&&{verticalAlign:this.__verticalAlign},backgroundColor:this.getBackgroundColor(),colSpan:this.__colSpan,headerState:this.__headerState,rowSpan:this.__rowSpan,width:this.getWidth()}}getColSpan(){return this.getLatest().__colSpan}setColSpan(e){const t=this.getWritable();return t.__colSpan=e,t}getRowSpan(){return this.getLatest().__rowSpan}setRowSpan(e){const t=this.getWritable();return t.__rowSpan=e,t}getTag(){return this.hasHeader()?"th":"td"}setHeaderStyles(e,t=r.BOTH){const n=this.getWritable();return n.__headerState=e&t|n.__headerState&~t,n}getHeaderStyles(){return this.getLatest().__headerState}setWidth(e){const t=this.getWritable();return t.__width=e,t}getWidth(){return this.getLatest().__width}getBackgroundColor(){return this.getLatest().__backgroundColor}setBackgroundColor(e){const t=this.getWritable();return t.__backgroundColor=e,t}getVerticalAlign(){return this.getLatest().__verticalAlign}setVerticalAlign(e){const t=this.getWritable();return t.__verticalAlign=e||void 0,t}toggleHeaderStyle(e){const t=this.getWritable();return(t.__headerState&e)===e?t.__headerState-=e:t.__headerState+=e,t}hasHeaderState(e){return(this.getHeaderStyles()&e)===e}hasHeader(){return this.getLatest().__headerState!==r.NO_STATUS}updateDOM(e){return e.__headerState!==this.__headerState||e.__width!==this.__width||e.__colSpan!==this.__colSpan||e.__rowSpan!==this.__rowSpan||e.__backgroundColor!==this.__backgroundColor||e.__verticalAlign!==this.__verticalAlign}isShadowRoot(){return!0}collapseAtStart(){return!0}canBeEmpty(){return!1}canIndent(){return!1}}function s(e){return"middle"===e||"bottom"===e}function i(e){const n=e,l=e.nodeName.toLowerCase();let i;o.test(n.style.width)&&(i=parseFloat(n.style.width));const c=a("th"===l?r.ROW:r.NO_STATUS,n.colSpan,i);c.__rowSpan=n.rowSpan;const u=n.style.backgroundColor;""!==u&&(c.__backgroundColor=u);const d=n.style.verticalAlign;s(d)&&(c.__verticalAlign=d);const h=n.style,g=(h&&h.textDecoration||"").split(" "),f="700"===h.fontWeight||"bold"===h.fontWeight,m=g.includes("line-through"),C="italic"===h.fontStyle,p=g.includes("underline");return{after:e=>{const n=[];let o=null;const r=()=>{if(o){const e=o.getFirstChild();t.$isLineBreakNode(e)&&1===o.getChildrenSize()&&e.remove()}};for(const l of e)t.$isInlineElementOrDecoratorNode(l)||t.$isTextNode(l)||t.$isLineBreakNode(l)?(t.$isTextNode(l)&&(f&&l.toggleFormat("bold"),m&&l.toggleFormat("strikethrough"),C&&l.toggleFormat("italic"),p&&l.toggleFormat("underline")),o?o.append(l):(o=t.$createParagraphNode().append(l),n.push(o))):(n.push(l),r(),o=null);return r(),0===n.length&&n.push(t.$createParagraphNode()),n},node:c}}function a(e=r.NO_STATUS,n=1,o){return t.$applyNodeReplacement(new l(e,n,o))}function c(e){return e instanceof l}const u=t.createCommand("INSERT_TABLE_COMMAND");function d(e,...t){const n=new URL("https://lexical.dev/docs/error"),o=new URLSearchParams;o.append("code",e);for(const e of t)o.append("v",e);throw n.search=o.toString(),Error(`Minified Lexical error #${e}; visit ${n.toString()} for the full message or use the non-minified dev environment for full errors and additional helpful warnings.`)}class h extends t.ElementNode{static getType(){return"tablerow"}static clone(e){return new h(e.__height,e.__key)}static importDOM(){return{tr:e=>({conversion:g,priority:0})}}static importJSON(e){return f().updateFromJSON(e)}updateFromJSON(e){return super.updateFromJSON(e).setHeight(e.height)}constructor(e,t){super(t),this.__height=e}exportJSON(){const e=this.getHeight();return{...super.exportJSON(),...void 0===e?void 0:{height:e}}}createDOM(t){const n=document.createElement("tr");return this.__height&&(n.style.height=`${this.__height}px`),e.addClassNamesToElement(n,t.theme.tableRow),n}extractWithChild(e,t,n){return"html"===n}isShadowRoot(){return!0}setHeight(e){const t=this.getWritable();return t.__height=e,t}getHeight(){return this.getLatest().__height}updateDOM(e){return e.__height!==this.__height}canBeEmpty(){return!1}canIndent(){return!1}}function g(t){const n=t;let r;return o.test(n.style.height)&&(r=parseFloat(n.style.height)),{after:t=>e.$descendantsMatching(t,c),node:f(r)}}function f(e){return t.$applyNodeReplacement(new h(e))}function m(e){return e instanceof h}const C="undefined"!=typeof window&&void 0!==window.document&&void 0!==window.document.createElement,p=C&&"documentMode"in document?document.documentMode:null,_=C&&/^(?!.*Seamonkey)(?=.*Firefox).*/i.test(navigator.userAgent);function S(e,n,o=!0){const l=ke();for(let s=0;s<e;s++){const e=f();for(let l=0;l<n;l++){let n=r.NO_STATUS;"object"==typeof o?(0===s&&o.rows&&(n|=r.ROW),0===l&&o.columns&&(n|=r.COLUMN)):o&&(0===s&&(n|=r.ROW),0===l&&(n|=r.COLUMN));const i=a(n),c=t.$createParagraphNode();c.append(t.$createTextNode()),i.append(c),e.append(i)}l.append(e)}return l}function N(t){const n=e.$findMatchingParent(t,(e=>m(e)));if(m(n))return n;throw new Error("Expected table cell to be inside of table row.")}function w(t){const n=e.$findMatchingParent(t,(e=>He(e)));if(He(n))return n;throw new Error("Expected table cell to be inside of table.")}function b(e,t){const n=w(e),{x:o,y:r}=n.getCordsFromCellNode(e,t);return{above:n.getCellNodeFromCords(o,r-1,t),below:n.getCellNodeFromCords(o,r+1,t),left:n.getCellNodeFromCords(o-1,r,t),right:n.getCellNodeFromCords(o+1,r,t)}}C&&"InputEvent"in window&&!p&&new window.InputEvent("input");const T=(e,t)=>e===r.BOTH||e===t?t:r.NO_STATUS;function $(e=!0){const n=t.$getSelection();t.$isRangeSelection(n)||X(n)||d(188);const o=n.anchor.getNode(),r=n.focus.getNode(),[l]=W(o),[s,,i]=W(r),[,a,c]=k(i,s,l),{startRow:u}=c,{startRow:h}=a;return e?R(u+l.__rowSpan>h+s.__rowSpan?l:s,!0):R(h<u?s:l,!1)}const y=$;function R(e,n=!0){const[,,o]=W(e),[l,s]=k(o,e,e),i=l[0].length,{startRow:c}=s;let u=null;if(n){const n=c+e.__rowSpan-1,s=l[n],h=f();for(let e=0;e<i;e++){const{cell:o,startRow:l}=s[e];if(l+o.__rowSpan-1<=n){const n=s[e].cell.__headerState,o=T(n,r.COLUMN);h.append(a(o).append(t.$createParagraphNode()))}else o.setRowSpan(o.__rowSpan+1)}const g=o.getChildAtIndex(n);m(g)||d(256),g.insertAfter(h),u=h}else{const e=c,n=l[e],s=f();for(let o=0;o<i;o++){const{cell:l,startRow:i}=n[o];if(i===e){const e=n[o].cell.__headerState,l=T(e,r.COLUMN);s.append(a(l).append(t.$createParagraphNode()))}else l.setRowSpan(l.__rowSpan+1)}const h=o.getChildAtIndex(e);m(h)||d(257),h.insertBefore(s),u=s}return u}function M(e=!0){const n=t.$getSelection();t.$isRangeSelection(n)||X(n)||d(188);const o=n.anchor.getNode(),r=n.focus.getNode(),[l]=W(o),[s,,i]=W(r),[,a,c]=k(i,s,l),{startColumn:u}=c,{startColumn:h}=a;return e?E(u+l.__colSpan>h+s.__colSpan?l:s,!0):E(h<u?s:l,!1)}const x=M;function E(e,n=!0,o=!0){const[,,l]=W(e),[s,i]=k(l,e,e),c=s.length,{startColumn:u}=i,h=n?u+e.__colSpan-1:u-1,g=l.getFirstChild();m(g)||d(120);let f=null;function C(e=r.NO_STATUS){const n=a(e).append(t.$createParagraphNode());return null===f&&(f=n),n}let p=g;e:for(let e=0;e<c;e++){if(0!==e){const e=p.getNextSibling();m(e)||d(121),p=e}const t=s[e],n=t[h<0?0:h].cell.__headerState,o=T(n,r.ROW);if(h<0){D(p,C(o));continue}const{cell:l,startColumn:i,startRow:a}=t[h];if(i+l.__colSpan-1<=h){let n=l,r=a,s=h;for(;r!==e&&n.__rowSpan>1;){if(s-=l.__colSpan,!(s>=0)){p.append(C(o));continue e}{const{cell:e,startRow:o}=t[s];n=e,r=o}}n.insertAfter(C(o))}else l.setColSpan(l.__colSpan+1)}null!==f&&o&&P(f);const _=l.getColWidths();if(_){const e=[..._],t=h<0?0:h,n=e[t];e.splice(t,0,n),l.setColWidths(e)}return f}function O(){const e=t.$getSelection();t.$isRangeSelection(e)||X(e)||d(188);const[n,o]=e.isBackward()?[e.focus.getNode(),e.anchor.getNode()]:[e.anchor.getNode(),e.focus.getNode()],[r,,l]=W(n),[s]=W(o),[i,a,c]=k(l,r,s),{startRow:u}=a,{startRow:h}=c,g=h+s.__rowSpan-1;if(i.length===g-u+1)return void l.remove();const f=i[0].length,C=i[g+1],p=l.getChildAtIndex(g+1);for(let e=g;e>=u;e--){for(let t=f-1;t>=0;t--){const{cell:n,startRow:o,startColumn:r}=i[e][t];if(r===t){if(o<u||o+n.__rowSpan-1>g){const e=Math.max(o,u),t=Math.min(n.__rowSpan+o-1,g),r=e<=t?t-e+1:0;n.setRowSpan(n.__rowSpan-r)}if(o>=u&&o+n.__rowSpan-1>g&&e===g){null===p&&d(122);let o=null;for(let n=0;n<t;n++){const t=C[n],r=t.cell;t.startRow===e+1&&(o=r),r.__colSpan>1&&(n+=r.__colSpan-1)}null===o?D(p,n):o.insertAfter(n)}}}const t=l.getChildAtIndex(e);m(t)||d(206,String(e)),t.remove()}if(void 0!==C){const{cell:e}=C[0];P(e)}else{const e=i[u-1],{cell:t}=e[0];P(t)}}const A=O;function v(){const e=t.$getSelection();t.$isRangeSelection(e)||X(e)||d(188);const n=e.anchor.getNode(),o=e.focus.getNode(),[r,,l]=W(n),[s]=W(o),[i,a,c]=k(l,r,s),{startColumn:u}=a,{startRow:h,startColumn:g}=c,f=Math.min(u,g),m=Math.max(u+r.__colSpan-1,g+s.__colSpan-1),C=m-f+1;if(i[0].length===m-f+1)return l.selectPrevious(),void l.remove();const p=i.length;for(let e=0;e<p;e++)for(let t=f;t<=m;t++){const{cell:n,startColumn:o}=i[e][t];if(o<f){if(t===f){const e=f-o;n.setColSpan(n.__colSpan-Math.min(C,n.__colSpan-e))}}else if(o+n.__colSpan-1>m){if(t===m){const e=m-o+1;n.setColSpan(n.__colSpan-e)}}else n.remove()}const _=i[h],S=u>g?_[u+r.__colSpan]:_[g+s.__colSpan];if(void 0!==S){const{cell:e}=S;P(e)}else{const e=g<u?_[g-1]:_[u-1],{cell:t}=e;P(t)}const N=l.getColWidths();if(N){const e=[...N];e.splice(f,C),l.setColWidths(e)}}const F=v;function P(e){const t=e.getFirstDescendant();null==t?e.selectStart():t.getParentOrThrow().selectStart()}function D(e,t){const n=e.getFirstChild();null!==n?n.insertBefore(t):e.append(t)}function K(e){if(0===e.length)return null;const n=w(e[0]),[o]=H(n,null,null);let r=1/0,l=-1/0,s=1/0,i=-1/0;const a=new Set;for(const t of o)for(const n of t){if(!n||!n.cell)continue;const t=n.cell.getKey();if(!a.has(t)&&e.some((e=>e.is(n.cell)))){a.add(t);const e=n.startRow,o=n.startColumn,c=n.cell.__rowSpan||1,u=n.cell.__colSpan||1;r=Math.min(r,e),l=Math.max(l,e+c-1),s=Math.min(s,o),i=Math.max(i,o+u-1)}}if(r===1/0||s===1/0)return null;const c=l-r+1,u=i-s+1,d=o[r][s];if(!d.cell)return null;const h=d.cell;h.setColSpan(u),h.setRowSpan(c);const g=new Set([h.getKey()]);for(let e=r;e<=l;e++)for(let t=s;t<=i;t++){const n=o[e][t];if(!n.cell)continue;const r=n.cell,l=r.getKey();if(!g.has(l)){g.add(l);I(r)||h.append(...r.getChildren()),r.remove()}}return 0===h.getChildrenSize()&&h.append(t.$createParagraphNode()),h}function I(e){if(1!==e.getChildrenSize())return!1;const n=e.getFirstChildOrThrow();return!(!t.$isParagraphNode(n)||!n.isEmpty())}function L(e){const[n,o,l]=W(e),s=n.__colSpan,i=n.__rowSpan;if(1===s&&1===i)return;const[c,u]=k(l,n,n),{startColumn:h,startRow:g}=u,f=n.__headerState&r.COLUMN,C=Array.from({length:s},((e,t)=>{let n=f;for(let e=0;0!==n&&e<c.length;e++)n&=c[e][t+h].cell.__headerState;return n})),p=n.__headerState&r.ROW,_=Array.from({length:i},((e,t)=>{let n=p;for(let e=0;0!==n&&e<c[0].length;e++)n&=c[t+g][e].cell.__headerState;return n}));if(s>1){for(let e=1;e<s;e++)n.insertAfter(a(C[e]|_[0]).append(t.$createParagraphNode()));n.setColSpan(1)}if(i>1){let e;for(let n=1;n<i;n++){const r=g+n,l=c[r];e=(e||o).getNextSibling(),m(e)||d(125);let i=null;for(let e=0;e<h;e++){const t=l[e],n=t.cell;t.startRow===r&&(i=n),n.__colSpan>1&&(e+=n.__colSpan-1)}if(null===i)for(let o=s-1;o>=0;o--)D(e,a(C[o]|_[n]).append(t.$createParagraphNode()));else for(let e=s-1;e>=0;e--)i.insertAfter(a(C[e]|_[n]).append(t.$createParagraphNode()))}n.setRowSpan(1)}}function k(e,t,n){const[o,r,l]=H(e,t,n);return null===r&&d(207),null===l&&d(208),[o,r,l]}function H(e,t,n){const o=[];let r=null,l=null;function s(e){let t=o[e];return void 0===t&&(o[e]=t=[]),t}const i=e.getChildren();for(let e=0;e<i.length;e++){const o=i[e];m(o)||d(209);const a=s(e);for(let u=o.getFirstChild(),h=0;null!=u;u=u.getNextSibling()){for(c(u)||d(147);void 0!==a[h];)h++;const o={cell:u,startColumn:h,startRow:e},{__rowSpan:g,__colSpan:f}=u;for(let t=0;t<g&&!(e+t>=i.length);t++){const n=s(e+t);for(let e=0;e<f;e++)n[h+e]=o}null!==t&&null===r&&t.is(u)&&(r=o),null!==n&&null===l&&n.is(u)&&(l=o)}}return[o,r,l]}function W(t){let n;if(t instanceof l)n=t;else if("__type"in t){const o=e.$findMatchingParent(t,c);c(o)||d(148),n=o}else{const o=e.$findMatchingParent(t.getNode(),c);c(o)||d(148),n=o}const o=n.getParent();m(o)||d(149);const r=o.getParent();return He(r)||d(210),[n,o,r]}function z(e,t,n){let o,r=Math.min(t.startColumn,n.startColumn),l=Math.min(t.startRow,n.startRow),s=Math.max(t.startColumn+t.cell.__colSpan-1,n.startColumn+n.cell.__colSpan-1),i=Math.max(t.startRow+t.cell.__rowSpan-1,n.startRow+n.cell.__rowSpan-1);do{o=!1;for(let t=0;t<e.length;t++)for(let n=0;n<e[0].length;n++){const a=e[t][n];if(!a)continue;const c=a.startColumn+a.cell.__colSpan-1,u=a.startRow+a.cell.__rowSpan-1,d=a.startColumn<=s&&c>=r,h=a.startRow<=i&&u>=l;if(d&&h){const e=Math.min(r,a.startColumn),t=Math.max(s,c),n=Math.min(l,a.startRow),d=Math.max(i,u);e===r&&t===s&&n===l&&d===i||(r=e,s=t,l=n,i=d,o=!0)}}}while(o);return{maxColumn:s,maxRow:i,minColumn:r,minRow:l}}function B(e){const[t,,n]=W(e),o=n.getChildren(),r=o.length,l=o[0].getChildren().length,s=new Array(r);for(let e=0;e<r;e++)s[e]=new Array(l);for(let e=0;e<r;e++){const n=o[e].getChildren();let r=0;for(let o=0;o<n.length;o++){for(;s[e][r];)r++;const l=n[o],i=l.__rowSpan||1,a=l.__colSpan||1;for(let t=0;t<i;t++)for(let n=0;n<a;n++)s[e+t][r+n]=l;if(t===l)return{colSpan:a,columnIndex:r,rowIndex:e,rowSpan:i};r+=a}}return null}function Y(t){const[[n,o,r,l],[s,i,a,u]]=["anchor","focus"].map((n=>{const o=t[n].getNode(),r=e.$findMatchingParent(o,c);c(r)||d(238,n,o.getKey(),o.getType());const l=r.getParent();m(l)||d(239,n);const s=l.getParent();return He(s)||d(240,n),[o,r,l,s]}));return l.is(u)||d(241),{anchorCell:o,anchorNode:n,anchorRow:r,anchorTable:l,focusCell:i,focusNode:s,focusRow:a,focusTable:u}}class U{constructor(e,t,n){this.anchor=t,this.focus=n,t._selection=this,n._selection=this,this._cachedNodes=null,this.dirty=!1,this.tableKey=e}getStartEndPoints(){return[this.anchor,this.focus]}isValid(){return"root"!==this.tableKey&&"root"!==this.anchor.key&&"element"===this.anchor.type&&"root"!==this.focus.key&&"element"===this.focus.type}isBackward(){return this.focus.isBefore(this.anchor)}getCachedNodes(){return this._cachedNodes}setCachedNodes(e){this._cachedNodes=e}is(e){return X(e)&&this.tableKey===e.tableKey&&this.anchor.is(e.anchor)&&this.focus.is(e.focus)}set(e,t,n){this.dirty=this.dirty||e!==this.tableKey||t!==this.anchor.key||n!==this.focus.key,this.tableKey=e,this.anchor.key=t,this.focus.key=n,this._cachedNodes=null}clone(){return new U(this.tableKey,t.$createPoint(this.anchor.key,this.anchor.offset,this.anchor.type),t.$createPoint(this.focus.key,this.focus.offset,this.focus.type))}isCollapsed(){return!1}extract(){return this.getNodes()}insertRawText(e){}insertText(){}hasFormat(e){let n=0;this.getNodes().filter(c).forEach((e=>{const o=e.getFirstChild();t.$isParagraphNode(o)&&(n|=o.getTextFormat())}));const o=t.TEXT_TYPE_TO_FORMAT[e];return!!(n&o)}insertNodes(e){const n=this.focus.getNode();t.$isElementNode(n)||d(151);t.$normalizeSelection__EXPERIMENTAL(n.select(0,n.getChildrenSize())).insertNodes(e)}getShape(){const{anchorCell:e,focusCell:t}=Y(this),n=B(e);null===n&&d(153);const o=B(t);null===o&&d(155);const r=Math.min(n.columnIndex,o.columnIndex),l=Math.max(n.columnIndex+n.colSpan-1,o.columnIndex+o.colSpan-1),s=Math.min(n.rowIndex,o.rowIndex),i=Math.max(n.rowIndex+n.rowSpan-1,o.rowIndex+o.rowSpan-1);return{fromX:Math.min(r,l),fromY:Math.min(s,i),toX:Math.max(r,l),toY:Math.max(s,i)}}getNodes(){if(!this.isValid())return[];const e=this._cachedNodes;if(null!==e)return e;const{anchorTable:n,anchorCell:o,focusCell:r}=Y(this),l=r.getParents()[1];if(l!==n){if(n.isParentOf(r)){const e=l.getParent();null==e&&d(159),this.set(this.tableKey,r.getKey(),e.getKey())}else{const e=n.getParent();null==e&&d(158),this.set(this.tableKey,e.getKey(),r.getKey())}return this.getNodes()}const[s,i,a]=k(n,o,r),{minColumn:c,maxColumn:u,minRow:h,maxRow:g}=z(s,i,a),f=new Map([[n.getKey(),n]]);let C=null;for(let e=h;e<=g;e++)for(let t=c;t<=u;t++){const{cell:n}=s[e][t],o=n.getParent();m(o)||d(160),o!==C&&(f.set(o.getKey(),o),C=o),f.has(n.getKey())||G(n,(e=>{f.set(e.getKey(),e)}))}const p=Array.from(f.values());return t.isCurrentlyReadOnlyMode()||(this._cachedNodes=p),p}getTextContent(){const e=this.getNodes().filter((e=>c(e)));let t="";for(let n=0;n<e.length;n++){const o=e[n],r=o.__parent,l=(e[n+1]||{}).__parent;t+=o.getTextContent()+(l!==r?"\n":"\t")}return t}}function X(e){return e instanceof U}function J(){const e=t.$createPoint("root",0,"element"),n=t.$createPoint("root",0,"element");return new U("root",e,n)}function q(e,n,o){e.getKey(),n.getKey(),o.getKey();const r=t.$getSelection(),l=X(r)?r.clone():J();return l.set(e.getKey(),n.getKey(),o.getKey()),l}function G(e,n){const o=[[e]];for(let e=o.at(-1);void 0!==e&&o.length>0;e=o.at(-1)){const r=e.pop();void 0===r?o.pop():!1!==n(r)&&t.$isElementNode(r)&&o.push(r.getChildren())}}function j(e,n=t.$getEditor()){const o=t.$getNodeByKey(e);He(o)||d(231,e);const r=te(o,n.getElementByKey(e));return null===r&&d(232,e),{tableElement:r,tableNode:o}}class V{constructor(e,t){this.isHighlightingCells=!1,this.anchorX=-1,this.anchorY=-1,this.focusX=-1,this.focusY=-1,this.listenersToRemove=new Set,this.tableNodeKey=t,this.editor=e,this.table={columns:0,domRows:[],rows:0},this.tableSelection=null,this.anchorCellNodeKey=null,this.focusCellNodeKey=null,this.anchorCell=null,this.focusCell=null,this.hasHijackedSelectionStyles=!1,this.isSelecting=!1,this.pointerType=null,this.shouldCheckSelection=!1,this.abortController=new AbortController,this.listenerOptions={signal:this.abortController.signal},this.nextFocus=null,this.trackTable()}getTable(){return this.table}removeListeners(){this.abortController.abort("removeListeners"),Array.from(this.listenersToRemove).forEach((e=>e())),this.listenersToRemove.clear()}$lookup(){return j(this.tableNodeKey,this.editor)}trackTable(){const e=new MutationObserver((e=>{this.editor.getEditorState().read((()=>{let t=!1;for(let n=0;n<e.length;n++){const o=e[n].target.nodeName;if("TABLE"===o||"TBODY"===o||"THEAD"===o||"TR"===o){t=!0;break}}if(!t)return;const{tableNode:n,tableElement:o}=this.$lookup();this.table=de(n,o)}),{editor:this.editor})}));this.editor.getEditorState().read((()=>{const{tableNode:t,tableElement:n}=this.$lookup();this.table=de(t,n),e.observe(n,{attributes:!0,childList:!0,subtree:!0})}),{editor:this.editor})}$clearHighlight(){const e=this.editor;this.isHighlightingCells=!1,this.anchorX=-1,this.anchorY=-1,this.focusX=-1,this.focusY=-1,this.tableSelection=null,this.anchorCellNodeKey=null,this.focusCellNodeKey=null,this.anchorCell=null,this.focusCell=null,this.hasHijackedSelectionStyles=!1,this.$enableHighlightStyle();const{tableNode:n,tableElement:o}=this.$lookup();he(e,de(n,o),null),null!==t.$getSelection()&&(t.$setSelection(null),e.dispatchCommand(t.SELECTION_CHANGE_COMMAND,void 0))}$enableHighlightStyle(){const t=this.editor,{tableElement:n}=this.$lookup();e.removeClassNamesFromElement(n,t._config.theme.tableSelection),n.classList.remove("disable-selection"),this.hasHijackedSelectionStyles=!1}$disableHighlightStyle(){const{tableElement:t}=this.$lookup();e.addClassNamesToElement(t,this.editor._config.theme.tableSelection),this.hasHijackedSelectionStyles=!0}$updateTableTableSelection(e){if(null!==e){e.tableKey!==this.tableNodeKey&&d(233,e.tableKey,this.tableNodeKey);const t=this.editor;this.tableSelection=e,this.isHighlightingCells=!0,this.$disableHighlightStyle(),this.updateDOMSelection(),he(t,this.table,this.tableSelection)}else this.$clearHighlight()}setShouldCheckSelection(){this.shouldCheckSelection=!0}getAndClearShouldCheckSelection(){return!!this.shouldCheckSelection&&(this.shouldCheckSelection=!1,!0)}setNextFocus(e){this.nextFocus=e}getAndClearNextFocus(){const{nextFocus:e}=this;return null!==e&&(this.nextFocus=null),e}updateDOMSelection(){if(null!==this.anchorCell&&null!==this.focusCell){const e=t.getDOMSelection(this.editor._window);e&&e.rangeCount>0&&e.removeAllRanges()}}$setFocusCellForSelection(e,n=!1){const o=this.editor,{tableNode:r}=this.$lookup(),l=e.x,s=e.y;if(this.focusCell=e,this.isHighlightingCells||this.anchorX===l&&this.anchorY===s&&!n){if(l===this.focusX&&s===this.focusY)return!1}else this.isHighlightingCells=!0,this.$disableHighlightStyle();if(this.focusX=l,this.focusY=s,this.isHighlightingCells){const n=ve(r,e.elem);if(null!=this.tableSelection&&null!=this.anchorCellNodeKey&&null!==n)return this.focusCellNodeKey=n.getKey(),this.tableSelection=q(r,this.$getAnchorTableCellOrThrow(),n),t.$setSelection(this.tableSelection),o.dispatchCommand(t.SELECTION_CHANGE_COMMAND,void 0),he(o,this.table,this.tableSelection),!0}return!1}$getAnchorTableCell(){return this.anchorCellNodeKey?t.$getNodeByKey(this.anchorCellNodeKey):null}$getAnchorTableCellOrThrow(){const e=this.$getAnchorTableCell();return null===e&&d(234),e}$getFocusTableCell(){return this.focusCellNodeKey?t.$getNodeByKey(this.focusCellNodeKey):null}$getFocusTableCellOrThrow(){const e=this.$getFocusTableCell();return null===e&&d(235),e}$setAnchorCellForSelection(e){this.isHighlightingCells=!1,this.anchorCell=e,this.anchorX=e.x,this.anchorY=e.y;const{tableNode:t}=this.$lookup(),n=ve(t,e.elem);if(null!==n){const e=n.getKey();this.tableSelection=null!=this.tableSelection?this.tableSelection.clone():J(),this.anchorCellNodeKey=e}}$formatCells(e){const n=t.$getSelection();X(n)||d(236);const o=t.$createRangeSelection(),r=o.anchor,l=o.focus,s=n.getNodes().filter(c);s.length>0||d(237);const i=s[0].getFirstChild(),a=t.$isParagraphNode(i)?i.getFormatFlags(e,null):null;s.forEach((t=>{r.set(t.getKey(),0,"element"),l.set(t.getKey(),t.getChildrenSize(),"element"),o.formatText(e,a)})),t.$setSelection(n),this.editor.dispatchCommand(t.SELECTION_CHANGE_COMMAND,void 0)}$clearText(){const{editor:e}=this,n=t.$getNodeByKey(this.tableNodeKey);if(!He(n))throw new Error("Expected TableNode.");const o=t.$getSelection();X(o)||d(253);const r=o.getNodes().filter(c),l=n.getFirstChild(),s=n.getLastChild();if(r.length>0&&null!==l&&null!==s&&m(l)&&m(s)&&r[0]===l.getFirstChild()&&r[r.length-1]===s.getLastChild()){n.selectPrevious();const o=n.getParent();return n.remove(),void(t.$isRootNode(o)&&o.isEmpty()&&e.dispatchCommand(t.INSERT_PARAGRAPH_COMMAND,void 0))}r.forEach((e=>{if(t.$isElementNode(e)){const n=t.$createParagraphNode(),o=t.$createTextNode();n.append(o),e.append(n),e.getChildren().forEach((e=>{e!==n&&e.remove()}))}})),he(e,this.table,null),t.$setSelection(null),e.dispatchCommand(t.SELECTION_CHANGE_COMMAND,void 0)}}const Q="__lexicalTableSelection",Z=e=>!(1&~e.buttons);function ee(e){return t.isHTMLElement(e)&&"TABLE"===e.nodeName}function te(e,t){if(!t)return t;const n=ee(t)?t:e.getDOMSlot(t).element;return"TABLE"!==n.nodeName&&d(245,t.nodeName),n}function ne(e){return e._window}function oe(e,t){for(let n=t,o=null;null!==n;n=n.getParent()){if(e.is(n))return o;c(n)&&(o=n)}return null}const re=[[t.KEY_ARROW_DOWN_COMMAND,"down"],[t.KEY_ARROW_UP_COMMAND,"up"],[t.KEY_ARROW_LEFT_COMMAND,"backward"],[t.KEY_ARROW_RIGHT_COMMAND,"forward"]],le=[t.DELETE_WORD_COMMAND,t.DELETE_LINE_COMMAND,t.DELETE_CHARACTER_COMMAND],se=[t.KEY_BACKSPACE_COMMAND,t.KEY_DELETE_COMMAND];function ie(o,r,l,s){const i=l.getRootElement(),a=ne(l);null!==i&&null!==a||d(246);const u=new V(l,o.getKey()),h=te(o,r);!function(e,t){null!==ae(e)&&d(205);e[Q]=t}(h,u),u.listenersToRemove.add((()=>function(e,t){ae(e)===t&&delete e[Q]}(h,u)));const g=e=>{if(u.pointerType=e.pointerType,0!==e.button||!t.isDOMNode(e.target)||!a)return;const n=ce(e.target);null!==n&&l.update((()=>{const r=t.$getPreviousSelection();if(_&&e.shiftKey&&Ne(r,o)&&(t.$isRangeSelection(r)||X(r))){const t=r.anchor.getNode(),l=oe(o,r.anchor.getNode());if(l)u.$setAnchorCellForSelection(Ae(u,l)),u.$setFocusCellForSelection(n),xe(e);else{(o.isBefore(t)?o.selectStart():o.selectEnd()).anchor.set(r.anchor.key,r.anchor.offset,r.anchor.type)}}else"touch"!==e.pointerType&&u.$setAnchorCellForSelection(n)})),(()=>{if(u.isSelecting)return;const e=()=>{u.isSelecting=!1,a.removeEventListener("pointerup",e),a.removeEventListener("pointermove",n)},n=o=>{if(!Z(o)&&u.isSelecting)return u.isSelecting=!1,a.removeEventListener("pointerup",e),void a.removeEventListener("pointermove",n);if(!t.isDOMNode(o.target))return;let r=null;const s=!(_||h.contains(o.target));if(s)r=ue(h,o.target);else for(const e of document.elementsFromPoint(o.clientX,o.clientY))if(r=ue(h,e),r)break;!r||null!==u.focusCell&&r.elem===u.focusCell.elem||(u.setNextFocus({focusCell:r,override:s}),l.dispatchCommand(t.SELECTION_CHANGE_COMMAND,void 0))};u.isSelecting=!0,a.addEventListener("pointerup",e,u.listenerOptions),a.addEventListener("pointermove",n,u.listenerOptions)})()};h.addEventListener("pointerdown",g,u.listenerOptions),u.listenersToRemove.add((()=>{h.removeEventListener("pointerdown",g)}));const f=e=>{if(e.detail>=3&&t.isDOMNode(e.target)){null!==ce(e.target)&&e.preventDefault()}};h.addEventListener("mousedown",f,u.listenerOptions),u.listenersToRemove.add((()=>{h.removeEventListener("mousedown",f)}));const C=e=>{const n=e.target;0===e.button&&t.isDOMNode(n)&&l.update((()=>{const e=t.$getSelection();X(e)&&e.tableKey===u.tableNodeKey&&i.contains(n)&&u.$clearHighlight()}))};a.addEventListener("pointerdown",C,u.listenerOptions),u.listenersToRemove.add((()=>{a.removeEventListener("pointerdown",C)}));for(const[e,n]of re)u.listenersToRemove.add(l.registerCommand(e,(e=>Me(l,e,n,o,u)),t.COMMAND_PRIORITY_HIGH));u.listenersToRemove.add(l.registerCommand(t.KEY_ESCAPE_COMMAND,(e=>{const n=t.$getSelection();if(X(n)){const t=oe(o,n.focus.getNode());if(null!==t)return xe(e),t.selectEnd(),!0}return!1}),t.COMMAND_PRIORITY_HIGH));const p=n=>()=>{const r=t.$getSelection();if(!Ne(r,o))return!1;if(X(r))return u.$clearText(),!0;if(t.$isRangeSelection(r)){if(!c(oe(o,r.anchor.getNode())))return!1;const l=r.anchor.getNode(),s=r.focus.getNode(),i=o.isParentOf(l),a=o.isParentOf(s);if(i&&!a||a&&!i)return u.$clearText(),!0;const d=e.$findMatchingParent(r.anchor.getNode(),(e=>t.$isElementNode(e))),h=d&&e.$findMatchingParent(d,(e=>t.$isElementNode(e)&&c(e.getParent())));if(!t.$isElementNode(h)||!t.$isElementNode(d))return!1;if(n===t.DELETE_LINE_COMMAND&&null===h.getPreviousSibling())return!0}return!1};for(const e of le)u.listenersToRemove.add(l.registerCommand(e,p(e),t.COMMAND_PRIORITY_CRITICAL));const S=e=>{const n=t.$getSelection();if(!X(n)&&!t.$isRangeSelection(n))return!1;const r=o.isParentOf(n.anchor.getNode());if(r!==o.isParentOf(n.focus.getNode())){const e=r?"anchor":"focus",t=r?"focus":"anchor",{key:l,offset:s,type:i}=n[t];return o[n[e].isBefore(n[t])?"selectPrevious":"selectNext"]()[t].set(l,s,i),!1}return!!Ne(n,o)&&(!!X(n)&&(e&&(e.preventDefault(),e.stopPropagation()),u.$clearText(),!0))};for(const e of se)u.listenersToRemove.add(l.registerCommand(e,S,t.COMMAND_PRIORITY_CRITICAL));return u.listenersToRemove.add(l.registerCommand(t.CUT_COMMAND,(o=>{const r=t.$getSelection();if(r){if(!X(r)&&!t.$isRangeSelection(r))return!1;n.copyToClipboard(l,e.objectKlassEquals(o,ClipboardEvent)?o:null,n.$getClipboardDataFromSelection(r));const s=S(o);return t.$isRangeSelection(r)?(r.removeText(),!0):s}return!1}),t.COMMAND_PRIORITY_CRITICAL)),u.listenersToRemove.add(l.registerCommand(t.FORMAT_TEXT_COMMAND,(n=>{const r=t.$getSelection();if(!Ne(r,o))return!1;if(X(r))return u.$formatCells(n),!0;if(t.$isRangeSelection(r)){const t=e.$findMatchingParent(r.anchor.getNode(),(e=>c(e)));if(!c(t))return!1}return!1}),t.COMMAND_PRIORITY_CRITICAL)),u.listenersToRemove.add(l.registerCommand(t.FORMAT_ELEMENT_COMMAND,(e=>{const n=t.$getSelection();if(!X(n)||!Ne(n,o))return!1;const r=n.anchor.getNode(),l=n.focus.getNode();if(!c(r)||!c(l))return!1;if(function(e,t){if(X(e)){const n=e.anchor.getNode(),o=e.focus.getNode();if(t&&n&&o){const[e]=k(t,n,o);return n.getKey()===e[0][0].cell.getKey()&&o.getKey()===e[e.length-1].at(-1).cell.getKey()}}return!1}(n,o))return o.setFormat(e),!0;const[s,i,a]=k(o,r,l),u=Math.max(i.startRow+i.cell.__rowSpan-1,a.startRow+a.cell.__rowSpan-1),d=Math.max(i.startColumn+i.cell.__colSpan-1,a.startColumn+a.cell.__colSpan-1),h=Math.min(i.startRow,a.startRow),g=Math.min(i.startColumn,a.startColumn),f=new Set;for(let n=h;n<=u;n++)for(let o=g;o<=d;o++){const r=s[n][o].cell;if(f.has(r))continue;f.add(r),r.setFormat(e);const l=r.getChildren();for(let n=0;n<l.length;n++){const o=l[n];t.$isElementNode(o)&&!o.isInline()&&o.setFormat(e)}}return!0}),t.COMMAND_PRIORITY_CRITICAL)),u.listenersToRemove.add(l.registerCommand(t.CONTROLLED_TEXT_INSERTION_COMMAND,(n=>{const r=t.$getSelection();if(!Ne(r,o))return!1;if(X(r))return u.$clearHighlight(),!1;if(t.$isRangeSelection(r)){const s=e.$findMatchingParent(r.anchor.getNode(),(e=>c(e)));if(!c(s))return!1;if("string"==typeof n){const e=Oe(l,r,o);if(e)return Ee(e,o,[t.$createTextNode(n)]),!0}}return!1}),t.COMMAND_PRIORITY_CRITICAL)),s&&u.listenersToRemove.add(l.registerCommand(t.KEY_TAB_COMMAND,(n=>{const r=t.$getSelection();if(!t.$isRangeSelection(r)||!r.isCollapsed()||!Ne(r,o))return!1;const l=$e(r.anchor.getNode());return!(null===l||!o.is(ye(l)))&&(xe(n),function(n,o){const r="next"===o?"getNextSibling":"getPreviousSibling",l="next"===o?"getFirstChild":"getLastChild",s=n[r]();if(t.$isElementNode(s))return s.selectEnd();const i=e.$findMatchingParent(n,m);null===i&&d(247);for(let e=i[r]();m(e);e=e[r]()){const n=e[l]();if(t.$isElementNode(n))return n.selectEnd()}const a=e.$findMatchingParent(i,He);null===a&&d(248);"next"===o?a.selectNext():a.selectPrevious()}(l,n.shiftKey?"previous":"next"),!0)}),t.COMMAND_PRIORITY_CRITICAL)),u.listenersToRemove.add(l.registerCommand(t.FOCUS_COMMAND,(e=>o.isSelected()),t.COMMAND_PRIORITY_HIGH)),u.listenersToRemove.add(l.registerCommand(t.SELECTION_INSERT_CLIPBOARD_NODES_COMMAND,((n,o)=>{if(l!==o)return!1;const{nodes:r,selection:s}=n,i=s.getStartEndPoints(),a=X(s),u=t.$isRangeSelection(s)&&null!==e.$findMatchingParent(s.anchor.getNode(),(e=>c(e)))&&null!==e.$findMatchingParent(s.focus.getNode(),(e=>c(e)))||a;if(1!==r.length||!He(r[0])||!u||null===i)return!1;const[d,h]=i,[g,f,C]=W(d),p=e.$findMatchingParent(h.getNode(),(e=>c(e)));if(!(c(g)&&c(p)&&m(f)&&He(C)))return!1;const _=r[0],[S,N,w]=k(C,g,p),[b]=H(_,null,null),T=S.length,$=T>0?S[0].length:0;let y=N.startRow,M=N.startColumn,x=b.length,O=x>0?b[0].length:0;if(a){const e=z(S,N,w),t=e.maxRow-e.minRow+1,n=e.maxColumn-e.minColumn+1;y=e.minRow,M=e.minColumn,x=Math.min(x,t),O=Math.min(O,n)}let A=!1;const v=Math.min(T,y+x)-1,F=Math.min($,M+O)-1,P=new Set;for(let e=y;e<=v;e++)for(let t=M;t<=F;t++){const n=S[e][t];P.has(n.cell.getKey())||(1===n.cell.__rowSpan&&1===n.cell.__colSpan||(L(n.cell),P.add(n.cell.getKey()),A=!0))}let[D]=H(C.getWritable(),null,null);const I=x-T+y;for(let e=0;e<I;e++){R(D[T-1][0].cell)}const B=O-$+M;for(let e=0;e<B;e++){E(D[0][$-1].cell,!0,!1)}[D]=H(C.getWritable(),null,null);for(let e=y;e<y+x;e++)for(let n=M;n<M+O;n++){const o=e-y,r=n-M,l=b[o][r];if(l.startRow!==o||l.startColumn!==r)continue;const s=l.cell;if(1!==s.__rowSpan||1!==s.__colSpan){const t=[],o=Math.min(e+s.__rowSpan,y+x)-1,r=Math.min(n+s.__colSpan,M+O)-1;for(let l=e;l<=o;l++)for(let e=n;e<=r;e++){const n=D[l][e];t.push(n.cell)}K(t),A=!0}const{cell:i}=D[e][n],a=i.getChildren();s.getChildren().forEach((e=>{if(t.$isTextNode(e)){t.$createParagraphNode().append(e),i.append(e)}else i.append(e)})),a.forEach((e=>e.remove()))}if(a&&A){const[e]=H(C.getWritable(),null,null);e[N.startRow][N.startColumn].cell.selectEnd()}return!0}),t.COMMAND_PRIORITY_CRITICAL)),u.listenersToRemove.add(l.registerCommand(t.SELECTION_CHANGE_COMMAND,(()=>{const n=t.$getSelection(),r=t.$getPreviousSelection(),s=u.getAndClearNextFocus();if(null!==s){const{focusCell:e}=s;if(X(n)&&n.tableKey===u.tableNodeKey)return(e.x!==u.focusX||e.y!==u.focusY)&&(u.$setFocusCellForSelection(e),!0);if(e!==u.anchorCell&&Ne(n,o))return u.$setFocusCellForSelection(e),!0}if(u.getAndClearShouldCheckSelection()&&t.$isRangeSelection(r)&&t.$isRangeSelection(n)&&n.isCollapsed()){const t=n.anchor.getNode(),r=o.getFirstChild(),l=$e(t);if(null!==l&&m(r)){const t=r.getFirstChild();if(c(t)&&o.is(e.$findMatchingParent(l,(e=>e.is(o)||e.is(t)))))return t.selectStart(),!0}}if(t.$isRangeSelection(n)){const{anchor:e,focus:s}=n,i=e.getNode(),a=s.getNode(),c=$e(i),d=$e(a),h=!(!c||!o.is(ye(c))),g=!(!d||!o.is(ye(d))),f=h!==g,m=h&&g,C=n.isBackward();if(f){const e=n.clone();if(g){const[t]=k(o,d,d),n=t[0][0].cell,r=t[t.length-1].at(-1).cell;e.focus.set(C?n.getKey():r.getKey(),C?n.getChildrenSize():r.getChildrenSize(),"element")}else if(h){const[t]=k(o,c,c),n=t[0][0].cell,r=t[t.length-1].at(-1).cell;e.anchor.set(C?r.getKey():n.getKey(),C?r.getChildrenSize():0,"element")}t.$setSelection(e),fe(l,u)}else if(m&&(c.is(d)||(u.$setAnchorCellForSelection(Ae(u,c)),u.$setFocusCellForSelection(Ae(u,d),!0)),"touch"===u.pointerType&&u.isSelecting&&n.isCollapsed()&&t.$isRangeSelection(r)&&r.isCollapsed())){const e=$e(r.anchor.getNode());e&&!e.is(d)&&(u.$setAnchorCellForSelection(Ae(u,e)),u.$setFocusCellForSelection(Ae(u,d),!0),u.pointerType=null)}}else if(n&&X(n)&&n.is(r)&&n.tableKey===o.getKey()){const e=t.getDOMSelection(a);if(e&&e.anchorNode&&e.focusNode){const r=t.$getNearestNodeFromDOMNode(e.focusNode),s=r&&!o.isParentOf(r),i=t.$getNearestNodeFromDOMNode(e.anchorNode),a=i&&o.isParentOf(i);if(s&&a&&e.rangeCount>0){const r=t.$createRangeSelectionFromDom(e,l);r&&(r.anchor.set(o.getKey(),n.isBackward()?o.getChildrenSize():0,"element"),e.removeAllRanges(),t.$setSelection(r))}}}return n&&!n.is(r)&&(X(n)||X(r))&&u.tableSelection&&!u.tableSelection.is(r)?(X(n)&&n.tableKey===u.tableNodeKey?u.$updateTableTableSelection(n):!X(n)&&X(r)&&r.tableKey===u.tableNodeKey&&u.$updateTableTableSelection(null),!1):(u.hasHijackedSelectionStyles&&!o.isSelected()?function(e,t){t.$enableHighlightStyle(),ge(t.table,(t=>{const n=t.elem;t.highlighted=!1,Te(e,t),n.getAttribute("style")||n.removeAttribute("style")}))}(l,u):!u.hasHijackedSelectionStyles&&o.isSelected()&&fe(l,u),!1)}),t.COMMAND_PRIORITY_CRITICAL)),u.listenersToRemove.add(l.registerCommand(t.INSERT_PARAGRAPH_COMMAND,(()=>{const e=t.$getSelection();if(!t.$isRangeSelection(e)||!e.isCollapsed()||!Ne(e,o))return!1;const n=Oe(l,e,o);return!!n&&(Ee(n,o),!0)}),t.COMMAND_PRIORITY_CRITICAL)),u}function ae(e){return e[Q]||null}function ce(e){let t=e;for(;null!=t;){const e=t.nodeName;if("TD"===e||"TH"===e){const e=t._cell;return void 0===e?null:e}t=t.parentNode}return null}function ue(e,t){if(!e.contains(t))return null;let n=null;for(let o=t;null!=o;o=o.parentNode){if(o===e)return n;const t=o.nodeName;"TD"!==t&&"TH"!==t||(n=o._cell||null)}return null}function de(e,t){const n=[],o={columns:0,domRows:n,rows:0};let r=te(e,t).querySelector("tr"),l=0,s=0;for(n.length=0;null!=r;){const e=r.nodeName;if("TD"===e||"TH"===e){const e={elem:r,hasBackgroundColor:""!==r.style.backgroundColor,highlighted:!1,x:l,y:s};r._cell=e;let t=n[s];void 0===t&&(t=n[s]=[]),t[l]=e}else{const e=r.firstChild;if(null!=e){r=e;continue}}const t=r.nextSibling;if(null!=t){l++,r=t;continue}const o=r.parentNode;if(null!=o){const e=o.nextSibling;if(null==e)break;s++,l=0,r=e}}return o.columns=l+1,o.rows=s+1,o}function he(e,t,n){const o=new Set(n?n.getNodes():[]);ge(t,((t,n)=>{const r=t.elem;o.has(n)?(t.highlighted=!0,be(e,t)):(t.highlighted=!1,Te(e,t),r.getAttribute("style")||r.removeAttribute("style"))}))}function ge(e,n){const{domRows:o}=e;for(let e=0;e<o.length;e++){const r=o[e];if(r)for(let o=0;o<r.length;o++){const l=r[o];if(!l)continue;const s=t.$getNearestNodeFromDOMNode(l.elem);null!==s&&n(l,s,{x:o,y:e})}}}function fe(e,t){t.$disableHighlightStyle(),ge(t.table,(t=>{t.highlighted=!0,be(e,t)}))}const me=(e,t,n,o,r)=>{const l="forward"===r;switch(r){case"backward":case"forward":return n!==(l?e.table.columns-1:0)?we(t.getCellNodeFromCordsOrThrow(n+(l?1:-1),o,e.table),l):o!==(l?e.table.rows-1:0)?we(t.getCellNodeFromCordsOrThrow(l?0:e.table.columns-1,o+(l?1:-1),e.table),l):l?t.selectNext():t.selectPrevious(),!0;case"up":return 0!==o?we(t.getCellNodeFromCordsOrThrow(n,o-1,e.table),!1):t.selectPrevious(),!0;case"down":return o!==e.table.rows-1?we(t.getCellNodeFromCordsOrThrow(n,o+1,e.table),!0):t.selectNext(),!0;default:return!1}};function Ce(e,t){let n,o;if(t.startColumn===e.minColumn)n="minColumn";else{if(t.startColumn+t.cell.__colSpan-1!==e.maxColumn)return null;n="maxColumn"}if(t.startRow===e.minRow)o="minRow";else{if(t.startRow+t.cell.__rowSpan-1!==e.maxRow)return null;o="maxRow"}return[n,o]}function pe([e,t]){return["minColumn"===e?"maxColumn":"minColumn","minRow"===t?"maxRow":"minRow"]}function _e(e,t,[n,o]){const r=t[o],l=e[r];void 0===l&&d(250,o,String(r));const s=t[n],i=l[s];return void 0===i&&d(250,n,String(s)),i}function Se(e,t,n,o,r){const l=z(t,n,o),s=function(e,t){const{minColumn:n,maxColumn:o,minRow:r,maxRow:l}=t;let s=1,i=1,a=1,c=1;const u=e[r],d=e[l];for(let e=n;e<=o;e++)s=Math.max(s,u[e].cell.__rowSpan),c=Math.max(c,d[e].cell.__rowSpan);for(let t=r;t<=l;t++)i=Math.max(i,e[t][n].cell.__colSpan),a=Math.max(a,e[t][o].cell.__colSpan);return{bottomSpan:c,leftSpan:i,rightSpan:a,topSpan:s}}(t,l),{topSpan:i,leftSpan:a,bottomSpan:c,rightSpan:u}=s,h=function(e,t){const n=Ce(e,t);return null===n&&d(249,t.cell.getKey()),n}(l,n),[g,f]=pe(h);let m=l[g],C=l[f];"forward"===r?m+="maxColumn"===g?1:a:"backward"===r?m-="minColumn"===g?1:u:"down"===r?C+="maxRow"===f?1:i:"up"===r&&(C-="minRow"===f?1:c);const p=t[C];if(void 0===p)return!1;const _=p[m];if(void 0===_)return!1;const[S,N]=function(e,t,n){const o=z(e,t,n),r=Ce(o,t);if(r)return[_e(e,o,r),_e(e,o,pe(r))];const l=Ce(o,n);if(l)return[_e(e,o,pe(l)),_e(e,o,l)];const s=["minColumn","minRow"];return[_e(e,o,s),_e(e,o,pe(s))]}(t,n,_),w=Ae(e,S.cell),b=Ae(e,N.cell);return e.$setAnchorCellForSelection(w),e.$setFocusCellForSelection(b,!0),!0}function Ne(e,n){if(t.$isRangeSelection(e)||X(e)){const t=n.isParentOf(e.anchor.getNode()),o=n.isParentOf(e.focus.getNode());return t&&o}return!1}function we(e,t){t?e.selectStart():e.selectEnd()}function be(n,o){const r=o.elem,l=n._config.theme;c(t.$getNearestNodeFromDOMNode(r))||d(131),e.addClassNamesToElement(r,l.tableCellSelected)}function Te(n,o){const r=o.elem;c(t.$getNearestNodeFromDOMNode(r))||d(131);const l=n._config.theme;e.removeClassNamesFromElement(r,l.tableCellSelected)}function $e(t){const n=e.$findMatchingParent(t,c);return c(n)?n:null}function ye(t){const n=e.$findMatchingParent(t,He);return He(n)?n:null}function Re(n,o,r,l,s,i,a){const u=t.$caretFromPoint(r.focus,s?"previous":"next");if(t.$isExtendableTextPointCaret(u))return!1;let d=u;for(const e of t.$extendCaretToRange(u).iterNodeCarets("shadowRoot")){if(!t.$isSiblingCaret(e)||!t.$isElementNode(e.origin))return!1;d=e}const h=d.getParentAtCaret();if(!c(h))return!1;const g=h,f=function(e){for(const n of t.$extendCaretToRange(e).iterNodeCarets("root")){const{origin:o}=n;if(c(o)){if(t.$isChildCaret(n))return t.$getChildCaret(o,e.direction)}else if(!m(o))break}return null}(t.$getSiblingCaret(g,d.direction)),C=e.$findMatchingParent(g,He);if(!C||!C.is(i))return!1;const p=n.getElementByKey(g.getKey()),_=ce(p);if(!p||!_)return!1;const S=Ie(n,C);if(a.table=S,f)if("extend"===l){const e=ce(n.getElementByKey(f.origin.getKey()));if(!e)return!1;a.$setAnchorCellForSelection(_),a.$setFocusCellForSelection(e,!0)}else{const e=t.$normalizeCaret(f);t.$setPointFromCaret(r.anchor,e),t.$setPointFromCaret(r.focus,e)}else if("extend"===l)a.$setAnchorCellForSelection(_),a.$setFocusCellForSelection(_,!0);else{const e=function(e){const n=t.$getAdjacentChildCaret(e);return t.$isChildCaret(n)?t.$normalizeCaret(n):e}(t.$getSiblingCaret(C,u.direction));t.$setPointFromCaret(r.anchor,e),t.$setPointFromCaret(r.focus,e)}return xe(o),!0}function Me(n,o,r,l,s){if(("up"===r||"down"===r)&&function(e){const t=e.getRootElement();if(!t)return!1;return t.hasAttribute("aria-controls")&&"typeahead-menu"===t.getAttribute("aria-controls")}(n))return!1;const i=t.$getSelection();if(!Ne(i,l)){if(t.$isRangeSelection(i)){if("backward"===r){if(i.focus.offset>0)return!1;const e=function(e){for(let n=e,o=e;null!==o;n=o,o=o.getParent())if(t.$isElementNode(o)){if(o!==n&&o.getFirstChild()!==n)return null;if(!o.isInline())return o}return null}(i.focus.getNode());if(!e)return!1;const n=e.getPreviousSibling();return!!He(n)&&(xe(o),o.shiftKey?i.focus.set(n.getParentOrThrow().getKey(),n.getIndexWithinParent(),"element"):n.selectEnd(),!0)}if(o.shiftKey&&("up"===r||"down"===r)){const n=i.focus.getNode();if(!i.isCollapsed()&&("up"===r&&!i.isBackward()||"down"===r&&i.isBackward())){let s=e.$findMatchingParent(n,(e=>He(e)));if(c(s)&&(s=e.$findMatchingParent(s,He)),s!==l)return!1;if(!s)return!1;const a="down"===r?s.getNextSibling():s.getPreviousSibling();if(!a)return!1;let u=0;"up"===r&&t.$isElementNode(a)&&(u=a.getChildrenSize());let d=a;if("up"===r&&t.$isElementNode(a)){const e=a.getLastChild();d=e||a,u=t.$isTextNode(d)?d.getTextContentSize():0}const h=i.clone();return h.focus.set(d.getKey(),u,t.$isTextNode(d)?"text":"element"),t.$setSelection(h),xe(o),!0}if(t.$isRootOrShadowRoot(n)){const e="up"===r?i.getNodes()[i.getNodes().length-1]:i.getNodes()[0];if(e){if(null!==oe(l,e)){const e=l.getFirstDescendant(),t=l.getLastDescendant();if(!e||!t)return!1;const[n]=W(e),[o]=W(t),r=l.getCordsFromCellNode(n,s.table),i=l.getCordsFromCellNode(o,s.table),a=l.getDOMCellFromCordsOrThrow(r.x,r.y,s.table),c=l.getDOMCellFromCordsOrThrow(i.x,i.y,s.table);return s.$setAnchorCellForSelection(a),s.$setFocusCellForSelection(c,!0),!0}}return!1}{let l=e.$findMatchingParent(n,(e=>t.$isElementNode(e)&&!e.isInline()));if(c(l)&&(l=e.$findMatchingParent(l,He)),!l)return!1;const a="down"===r?l.getNextSibling():l.getPreviousSibling();if(He(a)&&s.tableNodeKey===a.getKey()){const e=a.getFirstDescendant(),n=a.getLastDescendant();if(!e||!n)return!1;const[l]=W(e),[s]=W(n),c=i.clone();return c.focus.set(("up"===r?l:s).getKey(),"up"===r?0:s.getChildrenSize(),"element"),xe(o),t.$setSelection(c),!0}}}}return"down"===r&&De(n)&&s.setShouldCheckSelection(),!1}if(t.$isRangeSelection(i)){if("backward"===r||"forward"===r){return Re(n,o,i,o.shiftKey?"extend":"move","backward"===r,l,s)}if(i.isCollapsed()){const{anchor:a,focus:u}=i,d=e.$findMatchingParent(a.getNode(),c),h=e.$findMatchingParent(u.getNode(),c);if(!c(d)||!d.is(h))return!1;const g=ye(d);if(g!==l&&null!=g){const e=te(g,n.getElementByKey(g.getKey()));if(null!=e)return s.table=de(g,e),Me(n,o,r,g,s)}const f=n.getElementByKey(d.__key),m=n.getElementByKey(a.key);if(null==m||null==f)return!1;let C;if("element"===a.type)C=m.getBoundingClientRect();else{const e=t.getDOMSelection(ne(n));if(null===e||0===e.rangeCount)return!1;C=e.getRangeAt(0).getBoundingClientRect()}const p="up"===r?d.getFirstChild():d.getLastChild();if(null==p)return!1;const _=n.getElementByKey(p.__key);if(null==_)return!1;const S=_.getBoundingClientRect();if("up"===r?S.top>C.top-C.height:C.bottom+C.height>S.bottom){xe(o);const e=l.getCordsFromCellNode(d,s.table);if(!o.shiftKey)return me(s,l,e.x,e.y,r);{const t=l.getDOMCellFromCordsOrThrow(e.x,e.y,s.table);s.$setAnchorCellForSelection(t),s.$setFocusCellForSelection(t,!0)}return!0}}}else if(X(i)){const{anchor:t,focus:a}=i,u=e.$findMatchingParent(t.getNode(),c),h=e.$findMatchingParent(a.getNode(),c),[g]=i.getNodes();He(g)||d(251);const f=te(g,n.getElementByKey(g.getKey()));if(!c(u)||!c(h)||!He(g)||null==f)return!1;s.$updateTableTableSelection(i);const m=de(g,f),C=l.getCordsFromCellNode(u,m),p=l.getDOMCellFromCordsOrThrow(C.x,C.y,m);if(s.$setAnchorCellForSelection(p),xe(o),o.shiftKey){const[e,t,n]=k(l,u,h);return Se(s,e,t,n,r)}return h.selectEnd(),!0}return!1}function xe(e){e.preventDefault(),e.stopImmediatePropagation(),e.stopPropagation()}function Ee(e,n,o){const r=t.$createParagraphNode();"first"===e?n.insertBefore(r):n.insertAfter(r),r.append(...o||[]),r.selectEnd()}function Oe(n,o,r){const l=r.getParent();if(!l)return;const s=t.getDOMSelection(ne(n));if(!s)return;const i=s.anchorNode,a=n.getElementByKey(l.getKey()),u=te(r,n.getElementByKey(r.getKey()));if(!i||!a||!u||!a.contains(i)||u.contains(i))return;const d=e.$findMatchingParent(o.anchor.getNode(),(e=>c(e)));if(!d)return;const h=e.$findMatchingParent(d,(e=>He(e)));if(!He(h)||!h.is(r))return;const[g,f]=k(r,d,d),m=g[0][0],C=g[g.length-1][g[0].length-1],{startRow:p,startColumn:_}=f,S=p===m.startRow&&_===m.startColumn,N=p===C.startRow&&_===C.startColumn;return S?"first":N?"last":void 0}function Ae(e,t){const{tableNode:n}=e.$lookup(),o=n.getCordsFromCellNode(t,e.table);return n.getDOMCellFromCordsOrThrow(o.x,o.y,e.table)}function ve(e,n,o){return oe(e,t.$getNearestNodeFromDOMNode(n,o))}function Fe(t,n,o){if(!n.theme.tableAlignment)return;const r=[],l=[];for(const e of["center","right"]){const t=n.theme.tableAlignment[e];t&&(e===o?l:r).push(t)}e.removeClassNamesFromElement(t,...r),e.addClassNamesToElement(t,...l)}const Pe=new WeakSet;function De(e=t.$getEditor()){return Pe.has(e)}class Ke extends t.ElementNode{static getType(){return"table"}getColWidths(){return this.getLatest().__colWidths}setColWidths(e){const t=this.getWritable();return t.__colWidths=e,t}static clone(e){return new Ke(e.__key)}afterCloneFrom(e){super.afterCloneFrom(e),this.__colWidths=e.__colWidths,this.__rowStriping=e.__rowStriping,this.__frozenColumnCount=e.__frozenColumnCount,this.__frozenRowCount=e.__frozenRowCount}static importDOM(){return{table:e=>({conversion:Le,priority:1})}}static importJSON(e){return ke().updateFromJSON(e)}updateFromJSON(e){return super.updateFromJSON(e).setRowStriping(e.rowStriping||!1).setFrozenColumns(e.frozenColumnCount||0).setFrozenRows(e.frozenRowCount||0).setColWidths(e.colWidths)}constructor(e){super(e),this.__rowStriping=!1,this.__frozenColumnCount=0,this.__frozenRowCount=0}exportJSON(){return{...super.exportJSON(),colWidths:this.getColWidths(),frozenColumnCount:this.__frozenColumnCount?this.__frozenColumnCount:void 0,frozenRowCount:this.__frozenRowCount?this.__frozenRowCount:void 0,rowStriping:this.__rowStriping?this.__rowStriping:void 0}}extractWithChild(e,t,n){return"html"===n}getDOMSlot(e){const t=ee(e)?e:e.querySelector("table");return ee(t)||d(229),super.getDOMSlot(e).withElement(t).withAfter(t.querySelector("colgroup"))}createDOM(n,o){const r=document.createElement("table");this.__style&&(r.style.cssText=this.__style);const l=document.createElement("colgroup");if(r.appendChild(l),t.setDOMUnmanaged(l),e.addClassNamesToElement(r,n.theme.table),this.updateTableElement(null,r,n),De(o)){const t=document.createElement("div"),o=n.theme.tableScrollableWrapper;return o?e.addClassNamesToElement(t,o):t.style.cssText="overflow-x: auto;",t.appendChild(r),this.updateTableWrapper(null,t,r,n),t}return r}updateTableWrapper(t,n,o,r){this.__frozenColumnCount!==(t?t.__frozenColumnCount:0)&&function(t,n,o,r){r>0?(e.addClassNamesToElement(t,o.theme.tableFrozenColumn),n.setAttribute("data-lexical-frozen-column","true")):(e.removeClassNamesFromElement(t,o.theme.tableFrozenColumn),n.removeAttribute("data-lexical-frozen-column"))}(n,o,r,this.__frozenColumnCount),this.__frozenRowCount!==(t?t.__frozenRowCount:0)&&function(t,n,o,r){r>0?(e.addClassNamesToElement(t,o.theme.tableFrozenRow),n.setAttribute("data-lexical-frozen-row","true")):(e.removeClassNamesFromElement(t,o.theme.tableFrozenRow),n.removeAttribute("data-lexical-frozen-row"))}(n,o,r,this.__frozenRowCount)}updateTableElement(t,n,o){this.__style!==(t?t.__style:"")&&(n.style.cssText=this.__style),this.__rowStriping!==(!!t&&t.__rowStriping)&&function(t,n,o){o?(e.addClassNamesToElement(t,n.theme.tableRowStriping),t.setAttribute("data-lexical-row-striping","true")):(e.removeClassNamesFromElement(t,n.theme.tableRowStriping),t.removeAttribute("data-lexical-row-striping"))}(n,o,this.__rowStriping),function(e,t,n,o){const r=e.querySelector("colgroup");if(!r)return;const l=[];for(let e=0;e<n;e++){const t=document.createElement("col"),n=o&&o[e];n&&(t.style.width=`${n}px`),l.push(t)}r.replaceChildren(...l)}(n,0,this.getColumnCount(),this.getColWidths()),Fe(n,o,this.getFormatType())}updateDOM(t,n,o){const r=this.getDOMSlot(n).element;return n===r===De()||(l=n,e.isHTMLElement(l)&&"DIV"===l.nodeName&&this.updateTableWrapper(t,n,r,o),this.updateTableElement(t,r,o),!1);var l}exportDOM(t){const n=super.exportDOM(t),{element:o}=n;return{after:o=>{if(n.after&&(o=n.after(o)),!ee(o)&&e.isHTMLElement(o)&&(o=o.querySelector("table")),!ee(o))return null;Fe(o,t._config,this.getFormatType());const[r]=H(this,null,null),l=new Map;for(const e of r)for(const t of e){const e=t.cell.getKey();l.has(e)||l.set(e,{colSpan:t.cell.getColSpan(),startColumn:t.startColumn})}const s=new Set;for(const e of o.querySelectorAll(":scope > tr > [data-temporary-table-cell-lexical-key]")){const t=e.getAttribute("data-temporary-table-cell-lexical-key");if(t){const n=l.get(t);if(e.removeAttribute("data-temporary-table-cell-lexical-key"),n){l.delete(t);for(let e=0;e<n.colSpan;e++)s.add(e+n.startColumn)}}}const i=o.querySelector(":scope > colgroup");if(i){const e=Array.from(o.querySelectorAll(":scope > colgroup > col")).filter(((e,t)=>s.has(t)));i.replaceChildren(...e)}const a=o.querySelectorAll(":scope > tr");if(a.length>0){const e=document.createElement("tbody");for(const t of a)e.appendChild(t);o.append(e)}return o},element:!ee(o)&&e.isHTMLElement(o)?o.querySelector("table"):o}}canBeEmpty(){return!1}isShadowRoot(){return!0}getCordsFromCellNode(e,t){const{rows:n,domRows:o}=t;for(let t=0;t<n;t++){const n=o[t];if(null!=n)for(let o=0;o<n.length;o++){const r=n[o];if(null==r)continue;const{elem:l}=r,s=ve(this,l);if(null!==s&&e.is(s))return{x:o,y:t}}}throw new Error("Cell not found in table.")}getDOMCellFromCords(e,t,n){const{domRows:o}=n,r=o[t];if(null==r)return null;const l=r[e<r.length?e:r.length-1];return null==l?null:l}getDOMCellFromCordsOrThrow(e,t,n){const o=this.getDOMCellFromCords(e,t,n);if(!o)throw new Error("Cell not found at cords.");return o}getCellNodeFromCords(e,n,o){const r=this.getDOMCellFromCords(e,n,o);if(null==r)return null;const l=t.$getNearestNodeFromDOMNode(r.elem);return c(l)?l:null}getCellNodeFromCordsOrThrow(e,t,n){const o=this.getCellNodeFromCords(e,t,n);if(!o)throw new Error("Node at cords not TableCellNode.");return o}getRowStriping(){return Boolean(this.getLatest().__rowStriping)}setRowStriping(e){const t=this.getWritable();return t.__rowStriping=e,t}setFrozenColumns(e){const t=this.getWritable();return t.__frozenColumnCount=e,t}getFrozenColumns(){return this.getLatest().__frozenColumnCount}setFrozenRows(e){const t=this.getWritable();return t.__frozenRowCount=e,t}getFrozenRows(){return this.getLatest().__frozenRowCount}canSelectBefore(){return!0}canIndent(){return!1}getColumnCount(){const e=this.getFirstChild();if(!e)return 0;let t=0;return e.getChildren().forEach((e=>{c(e)&&(t+=e.getColSpan())})),t}}function Ie(e,t){const n=e.getElementByKey(t.getKey());return null===n&&d(230),de(t,n)}function Le(t){const n=ke();t.hasAttribute("data-lexical-row-striping")&&n.setRowStriping(!0),t.hasAttribute("data-lexical-frozen-column")&&n.setFrozenColumns(1),t.hasAttribute("data-lexical-frozen-row")&&n.setFrozenRows(1);const r=t.querySelector(":scope > colgroup");if(r){let e=[];for(const t of r.querySelectorAll(":scope > col")){let n=t.style.width||"";if(!o.test(n)&&(n=t.getAttribute("width")||"",!/^\d+$/.test(n))){e=void 0;break}e.push(parseFloat(n))}e&&n.setColWidths(e)}return{after:t=>e.$descendantsMatching(t,m),node:n}}function ke(){return t.$applyNodeReplacement(new Ke)}function He(e){return e instanceof Ke}function We({rows:n,columns:o,includeHeaders:r}){const l=t.$getSelection()||t.$getPreviousSelection();if(!l||!t.$isRangeSelection(l))return!1;if(ye(l.anchor.getNode()))return!1;const s=S(Number(n),Number(o),r);e.$insertNodeToNearestRoot(s);const i=s.getFirstDescendant();return t.$isTextNode(i)&&i.select(),!0}function ze(e){m(e.getParent())?e.isEmpty()&&e.append(t.$createParagraphNode()):e.remove()}function Be(t){He(t.getParent())?e.$unwrapAndFilterDescendants(t,c):t.remove()}function Ye(n){e.$unwrapAndFilterDescendants(n,m);const[o]=H(n,null,null),r=o.reduce(((e,t)=>Math.max(e,t.length)),0),l=n.getChildren();for(let e=0;e<o.length;++e){const n=l[e];if(!n)continue;m(n)||d(254,n.constructor.name,n.getType());const s=o[e].reduce(((e,t)=>t?1+e:e),0);if(s!==r)for(let e=s;e<r;++e){const e=a();e.append(t.$createParagraphNode()),n.append(e)}}}function Ue(n){if(n.detail<3||!t.isDOMNode(n.target))return!1;const o=t.$getNearestNodeFromDOMNode(n.target);if(null===o)return!1;const r=e.$findMatchingParent(o,(e=>t.$isElementNode(e)&&!e.isInline()));if(null===r)return!1;return!!c(r.getParent())&&(r.select(0),!0)}exports.$computeTableMap=k,exports.$computeTableMapSkipCellCheck=H,exports.$createTableCellNode=a,exports.$createTableNode=ke,exports.$createTableNodeWithDimensions=S,exports.$createTableRowNode=f,exports.$createTableSelection=J,exports.$createTableSelectionFrom=q,exports.$deleteTableColumn=function(e,t){const n=e.getChildren();for(let e=0;e<n.length;e++){const o=n[e];if(m(o)){const e=o.getChildren();if(t>=e.length||t<0)throw new Error("Table column target index out of range");e[t].remove()}}return e},exports.$deleteTableColumnAtSelection=v,exports.$deleteTableColumn__EXPERIMENTAL=F,exports.$deleteTableRowAtSelection=O,exports.$deleteTableRow__EXPERIMENTAL=A,exports.$findCellNode=$e,exports.$findTableNode=ye,exports.$getElementForTableNode=Ie,exports.$getNodeTriplet=W,exports.$getTableAndElementByKey=j,exports.$getTableCellNodeFromLexicalNode=function(t){const n=e.$findMatchingParent(t,(e=>c(e)));return c(n)?n:null},exports.$getTableCellNodeRect=B,exports.$getTableColumnIndexFromTableCellNode=function(e){return N(e).getChildren().findIndex((t=>t.is(e)))},exports.$getTableNodeFromLexicalNodeOrThrow=w,exports.$getTableRowIndexFromTableCellNode=function(e){const t=N(e);return w(t).getChildren().findIndex((e=>e.is(t)))},exports.$getTableRowNodeFromTableCellNodeOrThrow=N,exports.$insertTableColumn=function(e,n,o=!0,l,s){const i=e.getChildren(),u=[];for(let e=0;e<i.length;e++){const o=i[e];if(m(o))for(let e=0;e<l;e++){const e=o.getChildren();if(n>=e.length||n<0)throw new Error("Table column target index out of range");const l=e[n];c(l)||d(12);const{left:i,right:h}=b(l,s);let g=r.NO_STATUS;(i&&i.hasHeaderState(r.ROW)||h&&h.hasHeaderState(r.ROW))&&(g|=r.ROW);const f=a(g);f.append(t.$createParagraphNode()),u.push({newTableCell:f,targetCell:l})}}return u.forEach((({newTableCell:e,targetCell:t})=>{o?t.insertAfter(e):t.insertBefore(e)})),e},exports.$insertTableColumnAtSelection=M,exports.$insertTableColumn__EXPERIMENTAL=x,exports.$insertTableRow=function(e,n,o=!0,l,s){const i=e.getChildren();if(n>=i.length||n<0)throw new Error("Table row target index out of range");const u=i[n];if(!m(u))throw new Error("Row before insertion index does not exist.");for(let e=0;e<l;e++){const e=u.getChildren(),n=e.length,l=f();for(let o=0;o<n;o++){const n=e[o];c(n)||d(12);const{above:i,below:u}=b(n,s);let h=r.NO_STATUS;const g=i&&i.getWidth()||u&&u.getWidth()||void 0;(i&&i.hasHeaderState(r.COLUMN)||u&&u.hasHeaderState(r.COLUMN))&&(h|=r.COLUMN);const f=a(h,1,g);f.append(t.$createParagraphNode()),l.append(f)}o?u.insertAfter(l):u.insertBefore(l)}return e},exports.$insertTableRowAtSelection=$,exports.$insertTableRow__EXPERIMENTAL=y,exports.$isScrollableTablesActive=De,exports.$isTableCellNode=c,exports.$isTableNode=He,exports.$isTableRowNode=m,exports.$isTableSelection=X,exports.$mergeCells=K,exports.$removeTableRowAtIndex=function(e,t){const n=e.getChildren();if(t>=n.length||t<0)throw new Error("Expected table cell to be inside of table row.");return n[t].remove(),e},exports.$unmergeCell=function(){const n=t.$getSelection();t.$isRangeSelection(n)||X(n)||d(188);const o=n.anchor.getNode(),r=e.$findMatchingParent(o,c);return c(r)||d(148),L(r)},exports.INSERT_TABLE_COMMAND=u,exports.TableCellHeaderStates=r,exports.TableCellNode=l,exports.TableNode=Ke,exports.TableObserver=V,exports.TableRowNode=h,exports.applyTableHandlers=ie,exports.getDOMCellFromTarget=ce,exports.getTableElement=te,exports.getTableObserverFromTableElement=ae,exports.registerTableCellUnmergeTransform=function(t){return t.registerNodeTransform(l,(t=>{if(t.getColSpan()>1||t.getRowSpan()>1){const[,,n]=W(t),[o]=k(n,t,t),r=o.length,l=o[0].length;let s=n.getFirstChild();m(s)||d(175);const i=[];for(let t=0;t<r;t++){0!==t&&(s=s.getNextSibling(),m(s)||d(175));let n=null;for(let r=0;r<l;r++){const l=o[t][r],u=l.cell;if(l.startRow===t&&l.startColumn===r)n=u,i.push(u);else if(u.getColSpan()>1||u.getRowSpan()>1){c(u)||d(176);const t=a(u.__headerState);null!==n?n.insertAfter(t):e.$insertFirst(s,t)}}}for(const e of i)e.setColSpan(1),e.setRowSpan(1)}}))},exports.registerTablePlugin=function(n){return n.hasNodes([Ke])||d(255),e.mergeRegister(n.registerCommand(u,We,t.COMMAND_PRIORITY_EDITOR),n.registerCommand(t.SELECTION_INSERT_CLIPBOARD_NODES_COMMAND,(({nodes:e,selection:o},r)=>{if(n!==r||!t.$isRangeSelection(o))return!1;return null!==ye(o.anchor.getNode())&&e.some(He)}),t.COMMAND_PRIORITY_EDITOR),n.registerCommand(t.CLICK_COMMAND,Ue,t.COMMAND_PRIORITY_EDITOR),n.registerNodeTransform(Ke,Ye),n.registerNodeTransform(h,Be),n.registerNodeTransform(l,ze))},exports.registerTableSelectionObserver=function(e,t=!0){const n=new Map,o=(o,r,l)=>{const s=te(o,l),i=ie(o,s,e,t);n.set(r,[i,s])},r=e.registerMutationListener(Ke,(t=>{e.getEditorState().read((()=>{for(const[e,r]of t){const t=n.get(e);if("created"===r||"updated"===r){const{tableNode:r,tableElement:l}=j(e);void 0===t?o(r,e,l):l!==t[1]&&(t[0].removeListeners(),n.delete(e),o(r,e,l))}else"destroyed"===r&&void 0!==t&&(t[0].removeListeners(),n.delete(e))}}),{editor:e})}),{skipInitialization:!1});return()=>{r();for(const[,[e]]of n)e.removeListeners()}},exports.setScrollableTablesActive=function(e,t){t?Pe.add(e):Pe.delete(e)};
