import { RegExpParser, } from "@chevrotain/regexp-to-ast";
let regExpAstCache = {};
const regExpParser = new RegExpParser();
export function getRegExpAst(regExp) {
    const regExpStr = regExp.toString();
    if (regExpAstCache.hasOwnProperty(regExpStr)) {
        return regExpAstCache[regExpStr];
    }
    else {
        const regExpAst = regExpParser.pattern(regExpStr);
        regExpAstCache[regExpStr] = regExpAst;
        return regExpAst;
    }
}
export function clearRegExpParserCache() {
    regExpAstCache = {};
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/chevrotain/lib/src/scan/reg_exp_parser.js.map