export class Range {
    constructor(start, end) {
        this.start = start;
        this.end = end;
        if (!isValidRange(start, end)) {
            throw new Error("INVALID RANGE");
        }
    }
    contains(num) {
        return this.start <= num && this.end >= num;
    }
    containsRange(other) {
        return this.start <= other.start && this.end >= other.end;
    }
    isContainedInRange(other) {
        return other.containsRange(this);
    }
    strictlyContainsRange(other) {
        return this.start < other.start && this.end > other.end;
    }
    isStrictlyContainedInRange(other) {
        return other.strictlyContainsRange(this);
    }
}
export function isValidRange(start, end) {
    return !(start < 0 || end < start);
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/chevrotain/lib/src/text/range.js.map