/******************************************************************************
 * Copyright 2023 TypeFox GmbH
 * This program and the accompanying materials are made available under the
 * terms of the MIT License, which is available in the project root.
 *
 * @module langium/grammar
 */
// This file contains Langium grammar language internals.
// It is not supposed to be exported with the general `langium` export.
// Instead, it is available from `langium/grammar`.
export * from './generated/grammar.js';
export * from './generated/module.js';
export * from './lsp/grammar-call-hierarchy.js';
export * from './lsp/grammar-code-actions.js';
export * from './lsp/grammar-completion-provider.js';
export * from './lsp/grammar-definition.js';
export * from './lsp/grammar-folding-ranges.js';
export * from './lsp/grammar-formatter.js';
export * from './lsp/grammar-semantic-tokens.js';
export * from './references/grammar-naming.js';
export * from './references/grammar-references.js';
export * from './references/grammar-scope.js';
export * from './validation/types-validator.js';
export * from './validation/validation-resources-collector.js';
export * from './validation/validator.js';
export * from './type-system/index.js';
export * from './langium-grammar-module.js';
export * from './internal-grammar-util.js';
export * from './ast-reflection-interpreter.js';//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/langium/lib/grammar/index.js.map