/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 */

import * as modDev from './Lexical.dev.mjs';
import * as modProd from './Lexical.prod.mjs';
const mod = process.env.NODE_ENV !== 'production' ? modDev : modProd;
export const $addUpdateTag = mod.$addUpdateTag;
export const $applyNodeReplacement = mod.$applyNodeReplacement;
export const $caretFromPoint = mod.$caretFromPoint;
export const $caretRangeFromSelection = mod.$caretRangeFromSelection;
export const $cloneWithProperties = mod.$cloneWithProperties;
export const $comparePointCaretNext = mod.$comparePointCaretNext;
export const $copyNode = mod.$copyNode;
export const $create = mod.$create;
export const $createLineBreakNode = mod.$createLineBreakNode;
export const $createNodeSelection = mod.$createNodeSelection;
export const $createParagraphNode = mod.$createParagraphNode;
export const $createPoint = mod.$createPoint;
export const $createRangeSelection = mod.$createRangeSelection;
export const $createRangeSelectionFromDom = mod.$createRangeSelectionFromDom;
export const $createTabNode = mod.$createTabNode;
export const $createTextNode = mod.$createTextNode;
export const $extendCaretToRange = mod.$extendCaretToRange;
export const $getAdjacentChildCaret = mod.$getAdjacentChildCaret;
export const $getAdjacentNode = mod.$getAdjacentNode;
export const $getAdjacentSiblingOrParentSiblingCaret = mod.$getAdjacentSiblingOrParentSiblingCaret;
export const $getCaretInDirection = mod.$getCaretInDirection;
export const $getCaretRange = mod.$getCaretRange;
export const $getCaretRangeInDirection = mod.$getCaretRangeInDirection;
export const $getCharacterOffsets = mod.$getCharacterOffsets;
export const $getChildCaret = mod.$getChildCaret;
export const $getChildCaretAtIndex = mod.$getChildCaretAtIndex;
export const $getChildCaretOrSelf = mod.$getChildCaretOrSelf;
export const $getCollapsedCaretRange = mod.$getCollapsedCaretRange;
export const $getCommonAncestor = mod.$getCommonAncestor;
export const $getCommonAncestorResultBranchOrder = mod.$getCommonAncestorResultBranchOrder;
export const $getEditor = mod.$getEditor;
export const $getNearestNodeFromDOMNode = mod.$getNearestNodeFromDOMNode;
export const $getNearestRootOrShadowRoot = mod.$getNearestRootOrShadowRoot;
export const $getNodeByKey = mod.$getNodeByKey;
export const $getNodeByKeyOrThrow = mod.$getNodeByKeyOrThrow;
export const $getPreviousSelection = mod.$getPreviousSelection;
export const $getRoot = mod.$getRoot;
export const $getSelection = mod.$getSelection;
export const $getSiblingCaret = mod.$getSiblingCaret;
export const $getState = mod.$getState;
export const $getStateChange = mod.$getStateChange;
export const $getTextContent = mod.$getTextContent;
export const $getTextNodeOffset = mod.$getTextNodeOffset;
export const $getTextPointCaret = mod.$getTextPointCaret;
export const $getTextPointCaretSlice = mod.$getTextPointCaretSlice;
export const $getWritableNodeState = mod.$getWritableNodeState;
export const $hasAncestor = mod.$hasAncestor;
export const $hasUpdateTag = mod.$hasUpdateTag;
export const $insertNodes = mod.$insertNodes;
export const $isBlockElementNode = mod.$isBlockElementNode;
export const $isChildCaret = mod.$isChildCaret;
export const $isDecoratorNode = mod.$isDecoratorNode;
export const $isElementNode = mod.$isElementNode;
export const $isExtendableTextPointCaret = mod.$isExtendableTextPointCaret;
export const $isInlineElementOrDecoratorNode = mod.$isInlineElementOrDecoratorNode;
export const $isLeafNode = mod.$isLeafNode;
export const $isLineBreakNode = mod.$isLineBreakNode;
export const $isNodeCaret = mod.$isNodeCaret;
export const $isNodeSelection = mod.$isNodeSelection;
export const $isParagraphNode = mod.$isParagraphNode;
export const $isRangeSelection = mod.$isRangeSelection;
export const $isRootNode = mod.$isRootNode;
export const $isRootOrShadowRoot = mod.$isRootOrShadowRoot;
export const $isSiblingCaret = mod.$isSiblingCaret;
export const $isTabNode = mod.$isTabNode;
export const $isTextNode = mod.$isTextNode;
export const $isTextPointCaret = mod.$isTextPointCaret;
export const $isTextPointCaretSlice = mod.$isTextPointCaretSlice;
export const $isTokenOrSegmented = mod.$isTokenOrSegmented;
export const $isTokenOrTab = mod.$isTokenOrTab;
export const $nodesOfType = mod.$nodesOfType;
export const $normalizeCaret = mod.$normalizeCaret;
export const $normalizeSelection__EXPERIMENTAL = mod.$normalizeSelection__EXPERIMENTAL;
export const $onUpdate = mod.$onUpdate;
export const $parseSerializedNode = mod.$parseSerializedNode;
export const $removeTextFromCaretRange = mod.$removeTextFromCaretRange;
export const $rewindSiblingCaret = mod.$rewindSiblingCaret;
export const $selectAll = mod.$selectAll;
export const $setCompositionKey = mod.$setCompositionKey;
export const $setPointFromCaret = mod.$setPointFromCaret;
export const $setSelection = mod.$setSelection;
export const $setSelectionFromCaretRange = mod.$setSelectionFromCaretRange;
export const $setState = mod.$setState;
export const $splitAtPointCaretNext = mod.$splitAtPointCaretNext;
export const $splitNode = mod.$splitNode;
export const $updateRangeSelectionFromCaretRange = mod.$updateRangeSelectionFromCaretRange;
export const ArtificialNode__DO_NOT_USE = mod.ArtificialNode__DO_NOT_USE;
export const BLUR_COMMAND = mod.BLUR_COMMAND;
export const CAN_REDO_COMMAND = mod.CAN_REDO_COMMAND;
export const CAN_UNDO_COMMAND = mod.CAN_UNDO_COMMAND;
export const CLEAR_EDITOR_COMMAND = mod.CLEAR_EDITOR_COMMAND;
export const CLEAR_HISTORY_COMMAND = mod.CLEAR_HISTORY_COMMAND;
export const CLICK_COMMAND = mod.CLICK_COMMAND;
export const COLLABORATION_TAG = mod.COLLABORATION_TAG;
export const COMMAND_PRIORITY_CRITICAL = mod.COMMAND_PRIORITY_CRITICAL;
export const COMMAND_PRIORITY_EDITOR = mod.COMMAND_PRIORITY_EDITOR;
export const COMMAND_PRIORITY_HIGH = mod.COMMAND_PRIORITY_HIGH;
export const COMMAND_PRIORITY_LOW = mod.COMMAND_PRIORITY_LOW;
export const COMMAND_PRIORITY_NORMAL = mod.COMMAND_PRIORITY_NORMAL;
export const CONTROLLED_TEXT_INSERTION_COMMAND = mod.CONTROLLED_TEXT_INSERTION_COMMAND;
export const COPY_COMMAND = mod.COPY_COMMAND;
export const CUT_COMMAND = mod.CUT_COMMAND;
export const DELETE_CHARACTER_COMMAND = mod.DELETE_CHARACTER_COMMAND;
export const DELETE_LINE_COMMAND = mod.DELETE_LINE_COMMAND;
export const DELETE_WORD_COMMAND = mod.DELETE_WORD_COMMAND;
export const DRAGEND_COMMAND = mod.DRAGEND_COMMAND;
export const DRAGOVER_COMMAND = mod.DRAGOVER_COMMAND;
export const DRAGSTART_COMMAND = mod.DRAGSTART_COMMAND;
export const DROP_COMMAND = mod.DROP_COMMAND;
export const DecoratorNode = mod.DecoratorNode;
export const ElementNode = mod.ElementNode;
export const FOCUS_COMMAND = mod.FOCUS_COMMAND;
export const FORMAT_ELEMENT_COMMAND = mod.FORMAT_ELEMENT_COMMAND;
export const FORMAT_TEXT_COMMAND = mod.FORMAT_TEXT_COMMAND;
export const HISTORIC_TAG = mod.HISTORIC_TAG;
export const HISTORY_MERGE_TAG = mod.HISTORY_MERGE_TAG;
export const HISTORY_PUSH_TAG = mod.HISTORY_PUSH_TAG;
export const INDENT_CONTENT_COMMAND = mod.INDENT_CONTENT_COMMAND;
export const INSERT_LINE_BREAK_COMMAND = mod.INSERT_LINE_BREAK_COMMAND;
export const INSERT_PARAGRAPH_COMMAND = mod.INSERT_PARAGRAPH_COMMAND;
export const INSERT_TAB_COMMAND = mod.INSERT_TAB_COMMAND;
export const INTERNAL_$isBlock = mod.INTERNAL_$isBlock;
export const IS_ALL_FORMATTING = mod.IS_ALL_FORMATTING;
export const IS_BOLD = mod.IS_BOLD;
export const IS_CODE = mod.IS_CODE;
export const IS_HIGHLIGHT = mod.IS_HIGHLIGHT;
export const IS_ITALIC = mod.IS_ITALIC;
export const IS_STRIKETHROUGH = mod.IS_STRIKETHROUGH;
export const IS_SUBSCRIPT = mod.IS_SUBSCRIPT;
export const IS_SUPERSCRIPT = mod.IS_SUPERSCRIPT;
export const IS_UNDERLINE = mod.IS_UNDERLINE;
export const KEY_ARROW_DOWN_COMMAND = mod.KEY_ARROW_DOWN_COMMAND;
export const KEY_ARROW_LEFT_COMMAND = mod.KEY_ARROW_LEFT_COMMAND;
export const KEY_ARROW_RIGHT_COMMAND = mod.KEY_ARROW_RIGHT_COMMAND;
export const KEY_ARROW_UP_COMMAND = mod.KEY_ARROW_UP_COMMAND;
export const KEY_BACKSPACE_COMMAND = mod.KEY_BACKSPACE_COMMAND;
export const KEY_DELETE_COMMAND = mod.KEY_DELETE_COMMAND;
export const KEY_DOWN_COMMAND = mod.KEY_DOWN_COMMAND;
export const KEY_ENTER_COMMAND = mod.KEY_ENTER_COMMAND;
export const KEY_ESCAPE_COMMAND = mod.KEY_ESCAPE_COMMAND;
export const KEY_MODIFIER_COMMAND = mod.KEY_MODIFIER_COMMAND;
export const KEY_SPACE_COMMAND = mod.KEY_SPACE_COMMAND;
export const KEY_TAB_COMMAND = mod.KEY_TAB_COMMAND;
export const LineBreakNode = mod.LineBreakNode;
export const MOVE_TO_END = mod.MOVE_TO_END;
export const MOVE_TO_START = mod.MOVE_TO_START;
export const NODE_STATE_KEY = mod.NODE_STATE_KEY;
export const OUTDENT_CONTENT_COMMAND = mod.OUTDENT_CONTENT_COMMAND;
export const PASTE_COMMAND = mod.PASTE_COMMAND;
export const PASTE_TAG = mod.PASTE_TAG;
export const ParagraphNode = mod.ParagraphNode;
export const REDO_COMMAND = mod.REDO_COMMAND;
export const REMOVE_TEXT_COMMAND = mod.REMOVE_TEXT_COMMAND;
export const RootNode = mod.RootNode;
export const SELECTION_CHANGE_COMMAND = mod.SELECTION_CHANGE_COMMAND;
export const SELECTION_INSERT_CLIPBOARD_NODES_COMMAND = mod.SELECTION_INSERT_CLIPBOARD_NODES_COMMAND;
export const SELECT_ALL_COMMAND = mod.SELECT_ALL_COMMAND;
export const SKIP_COLLAB_TAG = mod.SKIP_COLLAB_TAG;
export const SKIP_DOM_SELECTION_TAG = mod.SKIP_DOM_SELECTION_TAG;
export const SKIP_SCROLL_INTO_VIEW_TAG = mod.SKIP_SCROLL_INTO_VIEW_TAG;
export const TEXT_TYPE_TO_FORMAT = mod.TEXT_TYPE_TO_FORMAT;
export const TabNode = mod.TabNode;
export const TextNode = mod.TextNode;
export const UNDO_COMMAND = mod.UNDO_COMMAND;
export const buildImportMap = mod.buildImportMap;
export const createCommand = mod.createCommand;
export const createEditor = mod.createEditor;
export const createSharedNodeState = mod.createSharedNodeState;
export const createState = mod.createState;
export const flipDirection = mod.flipDirection;
export const getDOMOwnerDocument = mod.getDOMOwnerDocument;
export const getDOMSelection = mod.getDOMSelection;
export const getDOMSelectionFromTarget = mod.getDOMSelectionFromTarget;
export const getDOMTextNode = mod.getDOMTextNode;
export const getEditorPropertyFromDOMNode = mod.getEditorPropertyFromDOMNode;
export const getNearestEditorFromDOMNode = mod.getNearestEditorFromDOMNode;
export const getRegisteredNode = mod.getRegisteredNode;
export const getRegisteredNodeOrThrow = mod.getRegisteredNodeOrThrow;
export const isBlockDomNode = mod.isBlockDomNode;
export const isCurrentlyReadOnlyMode = mod.isCurrentlyReadOnlyMode;
export const isDOMDocumentNode = mod.isDOMDocumentNode;
export const isDOMNode = mod.isDOMNode;
export const isDOMTextNode = mod.isDOMTextNode;
export const isDOMUnmanaged = mod.isDOMUnmanaged;
export const isDocumentFragment = mod.isDocumentFragment;
export const isExactShortcutMatch = mod.isExactShortcutMatch;
export const isHTMLAnchorElement = mod.isHTMLAnchorElement;
export const isHTMLElement = mod.isHTMLElement;
export const isInlineDomNode = mod.isInlineDomNode;
export const isLexicalEditor = mod.isLexicalEditor;
export const isModifierMatch = mod.isModifierMatch;
export const isSelectionCapturedInDecoratorInput = mod.isSelectionCapturedInDecoratorInput;
export const isSelectionWithinEditor = mod.isSelectionWithinEditor;
export const makeStepwiseIterator = mod.makeStepwiseIterator;
export const removeFromParent = mod.removeFromParent;
export const resetRandomKey = mod.resetRandomKey;
export const setDOMUnmanaged = mod.setDOMUnmanaged;
export const setNodeIndentFromDOM = mod.setNodeIndentFromDOM;