(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.RStore = {}, global.React));
})(this, (function (exports, require$$0) { 'use strict';

  /**
  * @vue/shared v3.5.16
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/
  /*! #__NO_SIDE_EFFECTS__ */
  // @__NO_SIDE_EFFECTS__
  function makeMap(str) {
    const map = /* @__PURE__ */ Object.create(null);
    for (const key of str.split(",")) map[key] = 1;
    return (val) => val in map;
  }

  const EMPTY_OBJ = Object.freeze({}) ;
  const NOOP = () => {
  };
  const extend = Object.assign;
  const remove = (arr, el) => {
    const i = arr.indexOf(el);
    if (i > -1) {
      arr.splice(i, 1);
    }
  };
  const hasOwnProperty$1 = Object.prototype.hasOwnProperty;
  const hasOwn = (val, key) => hasOwnProperty$1.call(val, key);
  const isArray = Array.isArray;
  const isMap = (val) => toTypeString(val) === "[object Map]";
  const isSet = (val) => toTypeString(val) === "[object Set]";
  const isFunction = (val) => typeof val === "function";
  const isString = (val) => typeof val === "string";
  const isSymbol = (val) => typeof val === "symbol";
  const isObject = (val) => val !== null && typeof val === "object";
  const isPromise = (val) => {
    return (isObject(val) || isFunction(val)) && isFunction(val.then) && isFunction(val.catch);
  };
  const objectToString = Object.prototype.toString;
  const toTypeString = (value) => objectToString.call(value);
  const toRawType = (value) => {
    return toTypeString(value).slice(8, -1);
  };
  const isPlainObject = (val) => toTypeString(val) === "[object Object]";
  const isIntegerKey = (key) => isString(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
  const cacheStringFunction = (fn) => {
    const cache = /* @__PURE__ */ Object.create(null);
    return (str) => {
      const hit = cache[str];
      return hit || (cache[str] = fn(str));
    };
  };
  const capitalize = cacheStringFunction((str) => {
    return str.charAt(0).toUpperCase() + str.slice(1);
  });
  const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
  const def = (obj, key, value, writable = false) => {
    Object.defineProperty(obj, key, {
      configurable: true,
      enumerable: false,
      writable,
      value
    });
  };

  /**
  * @vue/reactivity v3.5.16
  * (c) 2018-present Yuxi (Evan) You and Vue contributors
  * @license MIT
  **/

  function warn(msg, ...args) {
    console.warn(`[Vue warn] ${msg}`, ...args);
  }

  let activeEffectScope;
  class EffectScope {
    constructor(detached = false) {
      this.detached = detached;
      /**
       * @internal
       */
      this._active = true;
      /**
       * @internal track `on` calls, allow `on` call multiple times
       */
      this._on = 0;
      /**
       * @internal
       */
      this.effects = [];
      /**
       * @internal
       */
      this.cleanups = [];
      this._isPaused = false;
      this.parent = activeEffectScope;
      if (!detached && activeEffectScope) {
        this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(
          this
        ) - 1;
      }
    }
    get active() {
      return this._active;
    }
    pause() {
      if (this._active) {
        this._isPaused = true;
        let i, l;
        if (this.scopes) {
          for (i = 0, l = this.scopes.length; i < l; i++) {
            this.scopes[i].pause();
          }
        }
        for (i = 0, l = this.effects.length; i < l; i++) {
          this.effects[i].pause();
        }
      }
    }
    /**
     * Resumes the effect scope, including all child scopes and effects.
     */
    resume() {
      if (this._active) {
        if (this._isPaused) {
          this._isPaused = false;
          let i, l;
          if (this.scopes) {
            for (i = 0, l = this.scopes.length; i < l; i++) {
              this.scopes[i].resume();
            }
          }
          for (i = 0, l = this.effects.length; i < l; i++) {
            this.effects[i].resume();
          }
        }
      }
    }
    run(fn) {
      if (this._active) {
        const currentEffectScope = activeEffectScope;
        try {
          activeEffectScope = this;
          return fn();
        } finally {
          activeEffectScope = currentEffectScope;
        }
      } else {
        warn(`cannot run an inactive effect scope.`);
      }
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    on() {
      if (++this._on === 1) {
        this.prevScope = activeEffectScope;
        activeEffectScope = this;
      }
    }
    /**
     * This should only be called on non-detached scopes
     * @internal
     */
    off() {
      if (this._on > 0 && --this._on === 0) {
        activeEffectScope = this.prevScope;
        this.prevScope = void 0;
      }
    }
    stop(fromParent) {
      if (this._active) {
        this._active = false;
        let i, l;
        for (i = 0, l = this.effects.length; i < l; i++) {
          this.effects[i].stop();
        }
        this.effects.length = 0;
        for (i = 0, l = this.cleanups.length; i < l; i++) {
          this.cleanups[i]();
        }
        this.cleanups.length = 0;
        if (this.scopes) {
          for (i = 0, l = this.scopes.length; i < l; i++) {
            this.scopes[i].stop(true);
          }
          this.scopes.length = 0;
        }
        if (!this.detached && this.parent && !fromParent) {
          const last = this.parent.scopes.pop();
          if (last && last !== this) {
            this.parent.scopes[this.index] = last;
            last.index = this.index;
          }
        }
        this.parent = void 0;
      }
    }
  }
  function effectScope(detached) {
    return new EffectScope(detached);
  }
  function getCurrentScope() {
    return activeEffectScope;
  }
  function onScopeDispose(fn, failSilently = false) {
    if (activeEffectScope) {
      activeEffectScope.cleanups.push(fn);
    } else if (!failSilently) {
      warn(
        `onScopeDispose() is called when there is no active effect scope to be associated with.`
      );
    }
  }

  let activeSub;
  const EffectFlags = {
    "ACTIVE": 1,
    "1": "ACTIVE",
    "RUNNING": 2,
    "2": "RUNNING",
    "TRACKING": 4,
    "4": "TRACKING",
    "NOTIFIED": 8,
    "8": "NOTIFIED",
    "DIRTY": 16,
    "16": "DIRTY",
    "ALLOW_RECURSE": 32,
    "32": "ALLOW_RECURSE",
    "PAUSED": 64,
    "64": "PAUSED",
    "EVALUATED": 128,
    "128": "EVALUATED"
  };
  const pausedQueueEffects = /* @__PURE__ */ new WeakSet();
  class ReactiveEffect {
    constructor(fn) {
      this.fn = fn;
      /**
       * @internal
       */
      this.deps = void 0;
      /**
       * @internal
       */
      this.depsTail = void 0;
      /**
       * @internal
       */
      this.flags = 1 | 4;
      /**
       * @internal
       */
      this.next = void 0;
      /**
       * @internal
       */
      this.cleanup = void 0;
      this.scheduler = void 0;
      if (activeEffectScope && activeEffectScope.active) {
        activeEffectScope.effects.push(this);
      }
    }
    pause() {
      this.flags |= 64;
    }
    resume() {
      if (this.flags & 64) {
        this.flags &= -65;
        if (pausedQueueEffects.has(this)) {
          pausedQueueEffects.delete(this);
          this.trigger();
        }
      }
    }
    /**
     * @internal
     */
    notify() {
      if (this.flags & 2 && !(this.flags & 32)) {
        return;
      }
      if (!(this.flags & 8)) {
        batch(this);
      }
    }
    run() {
      if (!(this.flags & 1)) {
        return this.fn();
      }
      this.flags |= 2;
      cleanupEffect(this);
      prepareDeps(this);
      const prevEffect = activeSub;
      const prevShouldTrack = shouldTrack;
      activeSub = this;
      shouldTrack = true;
      try {
        return this.fn();
      } finally {
        if (activeSub !== this) {
          warn(
            "Active effect was not restored correctly - this is likely a Vue internal bug."
          );
        }
        cleanupDeps(this);
        activeSub = prevEffect;
        shouldTrack = prevShouldTrack;
        this.flags &= -3;
      }
    }
    stop() {
      if (this.flags & 1) {
        for (let link = this.deps; link; link = link.nextDep) {
          removeSub(link);
        }
        this.deps = this.depsTail = void 0;
        cleanupEffect(this);
        this.onStop && this.onStop();
        this.flags &= -2;
      }
    }
    trigger() {
      if (this.flags & 64) {
        pausedQueueEffects.add(this);
      } else if (this.scheduler) {
        this.scheduler();
      } else {
        this.runIfDirty();
      }
    }
    /**
     * @internal
     */
    runIfDirty() {
      if (isDirty(this)) {
        this.run();
      }
    }
    get dirty() {
      return isDirty(this);
    }
  }
  let batchDepth = 0;
  let batchedSub;
  let batchedComputed;
  function batch(sub, isComputed = false) {
    sub.flags |= 8;
    if (isComputed) {
      sub.next = batchedComputed;
      batchedComputed = sub;
      return;
    }
    sub.next = batchedSub;
    batchedSub = sub;
  }
  function startBatch() {
    batchDepth++;
  }
  function endBatch() {
    if (--batchDepth > 0) {
      return;
    }
    if (batchedComputed) {
      let e = batchedComputed;
      batchedComputed = void 0;
      while (e) {
        const next = e.next;
        e.next = void 0;
        e.flags &= -9;
        e = next;
      }
    }
    let error;
    while (batchedSub) {
      let e = batchedSub;
      batchedSub = void 0;
      while (e) {
        const next = e.next;
        e.next = void 0;
        e.flags &= -9;
        if (e.flags & 1) {
          try {
            ;
            e.trigger();
          } catch (err) {
            if (!error) error = err;
          }
        }
        e = next;
      }
    }
    if (error) throw error;
  }
  function prepareDeps(sub) {
    for (let link = sub.deps; link; link = link.nextDep) {
      link.version = -1;
      link.prevActiveLink = link.dep.activeLink;
      link.dep.activeLink = link;
    }
  }
  function cleanupDeps(sub) {
    let head;
    let tail = sub.depsTail;
    let link = tail;
    while (link) {
      const prev = link.prevDep;
      if (link.version === -1) {
        if (link === tail) tail = prev;
        removeSub(link);
        removeDep(link);
      } else {
        head = link;
      }
      link.dep.activeLink = link.prevActiveLink;
      link.prevActiveLink = void 0;
      link = prev;
    }
    sub.deps = head;
    sub.depsTail = tail;
  }
  function isDirty(sub) {
    for (let link = sub.deps; link; link = link.nextDep) {
      if (link.dep.version !== link.version || link.dep.computed && (refreshComputed(link.dep.computed) || link.dep.version !== link.version)) {
        return true;
      }
    }
    if (sub._dirty) {
      return true;
    }
    return false;
  }
  function refreshComputed(computed) {
    if (computed.flags & 4 && !(computed.flags & 16)) {
      return;
    }
    computed.flags &= -17;
    if (computed.globalVersion === globalVersion) {
      return;
    }
    computed.globalVersion = globalVersion;
    if (!computed.isSSR && computed.flags & 128 && (!computed.deps && !computed._dirty || !isDirty(computed))) {
      return;
    }
    computed.flags |= 2;
    const dep = computed.dep;
    const prevSub = activeSub;
    const prevShouldTrack = shouldTrack;
    activeSub = computed;
    shouldTrack = true;
    try {
      prepareDeps(computed);
      const value = computed.fn(computed._value);
      if (dep.version === 0 || hasChanged(value, computed._value)) {
        computed.flags |= 128;
        computed._value = value;
        dep.version++;
      }
    } catch (err) {
      dep.version++;
      throw err;
    } finally {
      activeSub = prevSub;
      shouldTrack = prevShouldTrack;
      cleanupDeps(computed);
      computed.flags &= -3;
    }
  }
  function removeSub(link, soft = false) {
    const { dep, prevSub, nextSub } = link;
    if (prevSub) {
      prevSub.nextSub = nextSub;
      link.prevSub = void 0;
    }
    if (nextSub) {
      nextSub.prevSub = prevSub;
      link.nextSub = void 0;
    }
    if (dep.subsHead === link) {
      dep.subsHead = nextSub;
    }
    if (dep.subs === link) {
      dep.subs = prevSub;
      if (!prevSub && dep.computed) {
        dep.computed.flags &= -5;
        for (let l = dep.computed.deps; l; l = l.nextDep) {
          removeSub(l, true);
        }
      }
    }
    if (!soft && !--dep.sc && dep.map) {
      dep.map.delete(dep.key);
    }
  }
  function removeDep(link) {
    const { prevDep, nextDep } = link;
    if (prevDep) {
      prevDep.nextDep = nextDep;
      link.prevDep = void 0;
    }
    if (nextDep) {
      nextDep.prevDep = prevDep;
      link.nextDep = void 0;
    }
  }
  function effect(fn, options) {
    if (fn.effect instanceof ReactiveEffect) {
      fn = fn.effect.fn;
    }
    const e = new ReactiveEffect(fn);
    if (options) {
      extend(e, options);
    }
    try {
      e.run();
    } catch (err) {
      e.stop();
      throw err;
    }
    const runner = e.run.bind(e);
    runner.effect = e;
    return runner;
  }
  function stop(runner) {
    runner.effect.stop();
  }
  let shouldTrack = true;
  const trackStack = [];
  function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
  }
  function enableTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = true;
  }
  function resetTracking() {
    const last = trackStack.pop();
    shouldTrack = last === void 0 ? true : last;
  }
  function onEffectCleanup(fn, failSilently = false) {
    if (activeSub instanceof ReactiveEffect) {
      activeSub.cleanup = fn;
    } else if (!failSilently) {
      warn(
        `onEffectCleanup() was called when there was no active effect to associate with.`
      );
    }
  }
  function cleanupEffect(e) {
    const { cleanup } = e;
    e.cleanup = void 0;
    if (cleanup) {
      const prevSub = activeSub;
      activeSub = void 0;
      try {
        cleanup();
      } finally {
        activeSub = prevSub;
      }
    }
  }

  let globalVersion = 0;
  class Link {
    constructor(sub, dep) {
      this.sub = sub;
      this.dep = dep;
      this.version = dep.version;
      this.nextDep = this.prevDep = this.nextSub = this.prevSub = this.prevActiveLink = void 0;
    }
  }
  class Dep {
    constructor(computed) {
      this.computed = computed;
      this.version = 0;
      /**
       * Link between this dep and the current active effect
       */
      this.activeLink = void 0;
      /**
       * Doubly linked list representing the subscribing effects (tail)
       */
      this.subs = void 0;
      /**
       * For object property deps cleanup
       */
      this.map = void 0;
      this.key = void 0;
      /**
       * Subscriber counter
       */
      this.sc = 0;
      {
        this.subsHead = void 0;
      }
    }
    track(debugInfo) {
      if (!activeSub || !shouldTrack || activeSub === this.computed) {
        return;
      }
      let link = this.activeLink;
      if (link === void 0 || link.sub !== activeSub) {
        link = this.activeLink = new Link(activeSub, this);
        if (!activeSub.deps) {
          activeSub.deps = activeSub.depsTail = link;
        } else {
          link.prevDep = activeSub.depsTail;
          activeSub.depsTail.nextDep = link;
          activeSub.depsTail = link;
        }
        addSub(link);
      } else if (link.version === -1) {
        link.version = this.version;
        if (link.nextDep) {
          const next = link.nextDep;
          next.prevDep = link.prevDep;
          if (link.prevDep) {
            link.prevDep.nextDep = next;
          }
          link.prevDep = activeSub.depsTail;
          link.nextDep = void 0;
          activeSub.depsTail.nextDep = link;
          activeSub.depsTail = link;
          if (activeSub.deps === link) {
            activeSub.deps = next;
          }
        }
      }
      if (activeSub.onTrack) {
        activeSub.onTrack(
          extend(
            {
              effect: activeSub
            },
            debugInfo
          )
        );
      }
      return link;
    }
    trigger(debugInfo) {
      this.version++;
      globalVersion++;
      this.notify(debugInfo);
    }
    notify(debugInfo) {
      startBatch();
      try {
        if (!!("development" !== "production")) {
          for (let head = this.subsHead; head; head = head.nextSub) {
            if (head.sub.onTrigger && !(head.sub.flags & 8)) {
              head.sub.onTrigger(
                extend(
                  {
                    effect: head.sub
                  },
                  debugInfo
                )
              );
            }
          }
        }
        for (let link = this.subs; link; link = link.prevSub) {
          if (link.sub.notify()) {
            ;
            link.sub.dep.notify();
          }
        }
      } finally {
        endBatch();
      }
    }
  }
  function addSub(link) {
    link.dep.sc++;
    if (link.sub.flags & 4) {
      const computed = link.dep.computed;
      if (computed && !link.dep.subs) {
        computed.flags |= 4 | 16;
        for (let l = computed.deps; l; l = l.nextDep) {
          addSub(l);
        }
      }
      const currentTail = link.dep.subs;
      if (currentTail !== link) {
        link.prevSub = currentTail;
        if (currentTail) currentTail.nextSub = link;
      }
      if (link.dep.subsHead === void 0) {
        link.dep.subsHead = link;
      }
      link.dep.subs = link;
    }
  }
  const targetMap = /* @__PURE__ */ new WeakMap();
  const ITERATE_KEY = Symbol(
    "Object iterate" 
  );
  const MAP_KEY_ITERATE_KEY = Symbol(
    "Map keys iterate" 
  );
  const ARRAY_ITERATE_KEY = Symbol(
    "Array iterate" 
  );
  function track(target, type, key) {
    if (shouldTrack && activeSub) {
      let depsMap = targetMap.get(target);
      if (!depsMap) {
        targetMap.set(target, depsMap = /* @__PURE__ */ new Map());
      }
      let dep = depsMap.get(key);
      if (!dep) {
        depsMap.set(key, dep = new Dep());
        dep.map = depsMap;
        dep.key = key;
      }
      {
        dep.track({
          target,
          type,
          key
        });
      }
    }
  }
  function trigger(target, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target);
    if (!depsMap) {
      globalVersion++;
      return;
    }
    const run = (dep) => {
      if (dep) {
        {
          dep.trigger({
            target,
            type,
            key,
            newValue,
            oldValue,
            oldTarget
          });
        }
      }
    };
    startBatch();
    if (type === "clear") {
      depsMap.forEach(run);
    } else {
      const targetIsArray = isArray(target);
      const isArrayIndex = targetIsArray && isIntegerKey(key);
      if (targetIsArray && key === "length") {
        const newLength = Number(newValue);
        depsMap.forEach((dep, key2) => {
          if (key2 === "length" || key2 === ARRAY_ITERATE_KEY || !isSymbol(key2) && key2 >= newLength) {
            run(dep);
          }
        });
      } else {
        if (key !== void 0 || depsMap.has(void 0)) {
          run(depsMap.get(key));
        }
        if (isArrayIndex) {
          run(depsMap.get(ARRAY_ITERATE_KEY));
        }
        switch (type) {
          case "add":
            if (!targetIsArray) {
              run(depsMap.get(ITERATE_KEY));
              if (isMap(target)) {
                run(depsMap.get(MAP_KEY_ITERATE_KEY));
              }
            } else if (isArrayIndex) {
              run(depsMap.get("length"));
            }
            break;
          case "delete":
            if (!targetIsArray) {
              run(depsMap.get(ITERATE_KEY));
              if (isMap(target)) {
                run(depsMap.get(MAP_KEY_ITERATE_KEY));
              }
            }
            break;
          case "set":
            if (isMap(target)) {
              run(depsMap.get(ITERATE_KEY));
            }
            break;
        }
      }
    }
    endBatch();
  }
  function getDepFromReactive(object, key) {
    const depMap = targetMap.get(object);
    return depMap && depMap.get(key);
  }

  function reactiveReadArray(array) {
    const raw = toRaw(array);
    if (raw === array) return raw;
    track(raw, "iterate", ARRAY_ITERATE_KEY);
    return isShallow(array) ? raw : raw.map(toReactive);
  }
  function shallowReadArray(arr) {
    track(arr = toRaw(arr), "iterate", ARRAY_ITERATE_KEY);
    return arr;
  }
  const arrayInstrumentations = {
    __proto__: null,
    [Symbol.iterator]() {
      return iterator(this, Symbol.iterator, toReactive);
    },
    concat(...args) {
      return reactiveReadArray(this).concat(
        ...args.map((x) => isArray(x) ? reactiveReadArray(x) : x)
      );
    },
    entries() {
      return iterator(this, "entries", (value) => {
        value[1] = toReactive(value[1]);
        return value;
      });
    },
    every(fn, thisArg) {
      return apply(this, "every", fn, thisArg, void 0, arguments);
    },
    filter(fn, thisArg) {
      return apply(this, "filter", fn, thisArg, (v) => v.map(toReactive), arguments);
    },
    find(fn, thisArg) {
      return apply(this, "find", fn, thisArg, toReactive, arguments);
    },
    findIndex(fn, thisArg) {
      return apply(this, "findIndex", fn, thisArg, void 0, arguments);
    },
    findLast(fn, thisArg) {
      return apply(this, "findLast", fn, thisArg, toReactive, arguments);
    },
    findLastIndex(fn, thisArg) {
      return apply(this, "findLastIndex", fn, thisArg, void 0, arguments);
    },
    // flat, flatMap could benefit from ARRAY_ITERATE but are not straight-forward to implement
    forEach(fn, thisArg) {
      return apply(this, "forEach", fn, thisArg, void 0, arguments);
    },
    includes(...args) {
      return searchProxy(this, "includes", args);
    },
    indexOf(...args) {
      return searchProxy(this, "indexOf", args);
    },
    join(separator) {
      return reactiveReadArray(this).join(separator);
    },
    // keys() iterator only reads `length`, no optimisation required
    lastIndexOf(...args) {
      return searchProxy(this, "lastIndexOf", args);
    },
    map(fn, thisArg) {
      return apply(this, "map", fn, thisArg, void 0, arguments);
    },
    pop() {
      return noTracking(this, "pop");
    },
    push(...args) {
      return noTracking(this, "push", args);
    },
    reduce(fn, ...args) {
      return reduce(this, "reduce", fn, args);
    },
    reduceRight(fn, ...args) {
      return reduce(this, "reduceRight", fn, args);
    },
    shift() {
      return noTracking(this, "shift");
    },
    // slice could use ARRAY_ITERATE but also seems to beg for range tracking
    some(fn, thisArg) {
      return apply(this, "some", fn, thisArg, void 0, arguments);
    },
    splice(...args) {
      return noTracking(this, "splice", args);
    },
    toReversed() {
      return reactiveReadArray(this).toReversed();
    },
    toSorted(comparer) {
      return reactiveReadArray(this).toSorted(comparer);
    },
    toSpliced(...args) {
      return reactiveReadArray(this).toSpliced(...args);
    },
    unshift(...args) {
      return noTracking(this, "unshift", args);
    },
    values() {
      return iterator(this, "values", toReactive);
    }
  };
  function iterator(self, method, wrapValue) {
    const arr = shallowReadArray(self);
    const iter = arr[method]();
    if (arr !== self && !isShallow(self)) {
      iter._next = iter.next;
      iter.next = () => {
        const result = iter._next();
        if (result.value) {
          result.value = wrapValue(result.value);
        }
        return result;
      };
    }
    return iter;
  }
  const arrayProto = Array.prototype;
  function apply(self, method, fn, thisArg, wrappedRetFn, args) {
    const arr = shallowReadArray(self);
    const needsWrap = arr !== self && !isShallow(self);
    const methodFn = arr[method];
    if (methodFn !== arrayProto[method]) {
      const result2 = methodFn.apply(self, args);
      return needsWrap ? toReactive(result2) : result2;
    }
    let wrappedFn = fn;
    if (arr !== self) {
      if (needsWrap) {
        wrappedFn = function(item, index) {
          return fn.call(this, toReactive(item), index, self);
        };
      } else if (fn.length > 2) {
        wrappedFn = function(item, index) {
          return fn.call(this, item, index, self);
        };
      }
    }
    const result = methodFn.call(arr, wrappedFn, thisArg);
    return needsWrap && wrappedRetFn ? wrappedRetFn(result) : result;
  }
  function reduce(self, method, fn, args) {
    const arr = shallowReadArray(self);
    let wrappedFn = fn;
    if (arr !== self) {
      if (!isShallow(self)) {
        wrappedFn = function(acc, item, index) {
          return fn.call(this, acc, toReactive(item), index, self);
        };
      } else if (fn.length > 3) {
        wrappedFn = function(acc, item, index) {
          return fn.call(this, acc, item, index, self);
        };
      }
    }
    return arr[method](wrappedFn, ...args);
  }
  function searchProxy(self, method, args) {
    const arr = toRaw(self);
    track(arr, "iterate", ARRAY_ITERATE_KEY);
    const res = arr[method](...args);
    if ((res === -1 || res === false) && isProxy(args[0])) {
      args[0] = toRaw(args[0]);
      return arr[method](...args);
    }
    return res;
  }
  function noTracking(self, method, args = []) {
    pauseTracking();
    startBatch();
    const res = toRaw(self)[method].apply(self, args);
    endBatch();
    resetTracking();
    return res;
  }

  const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
  const builtInSymbols = new Set(
    /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((key) => key !== "arguments" && key !== "caller").map((key) => Symbol[key]).filter(isSymbol)
  );
  function hasOwnProperty(key) {
    if (!isSymbol(key)) key = String(key);
    const obj = toRaw(this);
    track(obj, "has", key);
    return obj.hasOwnProperty(key);
  }
  class BaseReactiveHandler {
    constructor(_isReadonly = false, _isShallow = false) {
      this._isReadonly = _isReadonly;
      this._isShallow = _isShallow;
    }
    get(target, key, receiver) {
      if (key === "__v_skip") return target["__v_skip"];
      const isReadonly2 = this._isReadonly, isShallow2 = this._isShallow;
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_isShallow") {
        return isShallow2;
      } else if (key === "__v_raw") {
        if (receiver === (isReadonly2 ? isShallow2 ? shallowReadonlyMap : readonlyMap : isShallow2 ? shallowReactiveMap : reactiveMap).get(target) || // receiver is not the reactive proxy, but has the same prototype
        // this means the receiver is a user proxy of the reactive proxy
        Object.getPrototypeOf(target) === Object.getPrototypeOf(receiver)) {
          return target;
        }
        return;
      }
      const targetIsArray = isArray(target);
      if (!isReadonly2) {
        let fn;
        if (targetIsArray && (fn = arrayInstrumentations[key])) {
          return fn;
        }
        if (key === "hasOwnProperty") {
          return hasOwnProperty;
        }
      }
      const res = Reflect.get(
        target,
        key,
        // if this is a proxy wrapping a ref, return methods using the raw ref
        // as receiver so that we don't have to call `toRaw` on the ref in all
        // its class methods
        isRef(target) ? target : receiver
      );
      if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
        return res;
      }
      if (!isReadonly2) {
        track(target, "get", key);
      }
      if (isShallow2) {
        return res;
      }
      if (isRef(res)) {
        return targetIsArray && isIntegerKey(key) ? res : res.value;
      }
      if (isObject(res)) {
        return isReadonly2 ? readonly(res) : reactive(res);
      }
      return res;
    }
  }
  class MutableReactiveHandler extends BaseReactiveHandler {
    constructor(isShallow2 = false) {
      super(false, isShallow2);
    }
    set(target, key, value, receiver) {
      let oldValue = target[key];
      if (!this._isShallow) {
        const isOldValueReadonly = isReadonly(oldValue);
        if (!isShallow(value) && !isReadonly(value)) {
          oldValue = toRaw(oldValue);
          value = toRaw(value);
        }
        if (!isArray(target) && isRef(oldValue) && !isRef(value)) {
          if (isOldValueReadonly) {
            return false;
          } else {
            oldValue.value = value;
            return true;
          }
        }
      }
      const hadKey = isArray(target) && isIntegerKey(key) ? Number(key) < target.length : hasOwn(target, key);
      const result = Reflect.set(
        target,
        key,
        value,
        isRef(target) ? target : receiver
      );
      if (target === toRaw(receiver)) {
        if (!hadKey) {
          trigger(target, "add", key, value);
        } else if (hasChanged(value, oldValue)) {
          trigger(target, "set", key, value, oldValue);
        }
      }
      return result;
    }
    deleteProperty(target, key) {
      const hadKey = hasOwn(target, key);
      const oldValue = target[key];
      const result = Reflect.deleteProperty(target, key);
      if (result && hadKey) {
        trigger(target, "delete", key, void 0, oldValue);
      }
      return result;
    }
    has(target, key) {
      const result = Reflect.has(target, key);
      if (!isSymbol(key) || !builtInSymbols.has(key)) {
        track(target, "has", key);
      }
      return result;
    }
    ownKeys(target) {
      track(
        target,
        "iterate",
        isArray(target) ? "length" : ITERATE_KEY
      );
      return Reflect.ownKeys(target);
    }
  }
  class ReadonlyReactiveHandler extends BaseReactiveHandler {
    constructor(isShallow2 = false) {
      super(true, isShallow2);
    }
    set(target, key) {
      {
        warn(
          `Set operation on key "${String(key)}" failed: target is readonly.`,
          target
        );
      }
      return true;
    }
    deleteProperty(target, key) {
      {
        warn(
          `Delete operation on key "${String(key)}" failed: target is readonly.`,
          target
        );
      }
      return true;
    }
  }
  const mutableHandlers = /* @__PURE__ */ new MutableReactiveHandler();
  const readonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler();
  const shallowReactiveHandlers = /* @__PURE__ */ new MutableReactiveHandler(true);
  const shallowReadonlyHandlers = /* @__PURE__ */ new ReadonlyReactiveHandler(true);

  const toShallow = (value) => value;
  const getProto = (v) => Reflect.getPrototypeOf(v);
  function createIterableMethod(method, isReadonly2, isShallow2) {
    return function(...args) {
      const target = this["__v_raw"];
      const rawTarget = toRaw(target);
      const targetIsMap = isMap(rawTarget);
      const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
      const isKeyOnly = method === "keys" && targetIsMap;
      const innerIterator = target[method](...args);
      const wrap = isShallow2 ? toShallow : isReadonly2 ? toReadonly : toReactive;
      !isReadonly2 && track(
        rawTarget,
        "iterate",
        isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY
      );
      return {
        // iterator protocol
        next() {
          const { value, done } = innerIterator.next();
          return done ? { value, done } : {
            value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
            done
          };
        },
        // iterable protocol
        [Symbol.iterator]() {
          return this;
        }
      };
    };
  }
  function createReadonlyMethod(type) {
    return function(...args) {
      {
        const key = args[0] ? `on key "${args[0]}" ` : ``;
        warn(
          `${capitalize(type)} operation ${key}failed: target is readonly.`,
          toRaw(this)
        );
      }
      return type === "delete" ? false : type === "clear" ? void 0 : this;
    };
  }
  function createInstrumentations(readonly, shallow) {
    const instrumentations = {
      get(key) {
        const target = this["__v_raw"];
        const rawTarget = toRaw(target);
        const rawKey = toRaw(key);
        if (!readonly) {
          if (hasChanged(key, rawKey)) {
            track(rawTarget, "get", key);
          }
          track(rawTarget, "get", rawKey);
        }
        const { has } = getProto(rawTarget);
        const wrap = shallow ? toShallow : readonly ? toReadonly : toReactive;
        if (has.call(rawTarget, key)) {
          return wrap(target.get(key));
        } else if (has.call(rawTarget, rawKey)) {
          return wrap(target.get(rawKey));
        } else if (target !== rawTarget) {
          target.get(key);
        }
      },
      get size() {
        const target = this["__v_raw"];
        !readonly && track(toRaw(target), "iterate", ITERATE_KEY);
        return Reflect.get(target, "size", target);
      },
      has(key) {
        const target = this["__v_raw"];
        const rawTarget = toRaw(target);
        const rawKey = toRaw(key);
        if (!readonly) {
          if (hasChanged(key, rawKey)) {
            track(rawTarget, "has", key);
          }
          track(rawTarget, "has", rawKey);
        }
        return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
      },
      forEach(callback, thisArg) {
        const observed = this;
        const target = observed["__v_raw"];
        const rawTarget = toRaw(target);
        const wrap = shallow ? toShallow : readonly ? toReadonly : toReactive;
        !readonly && track(rawTarget, "iterate", ITERATE_KEY);
        return target.forEach((value, key) => {
          return callback.call(thisArg, wrap(value), wrap(key), observed);
        });
      }
    };
    extend(
      instrumentations,
      readonly ? {
        add: createReadonlyMethod("add"),
        set: createReadonlyMethod("set"),
        delete: createReadonlyMethod("delete"),
        clear: createReadonlyMethod("clear")
      } : {
        add(value) {
          if (!shallow && !isShallow(value) && !isReadonly(value)) {
            value = toRaw(value);
          }
          const target = toRaw(this);
          const proto = getProto(target);
          const hadKey = proto.has.call(target, value);
          if (!hadKey) {
            target.add(value);
            trigger(target, "add", value, value);
          }
          return this;
        },
        set(key, value) {
          if (!shallow && !isShallow(value) && !isReadonly(value)) {
            value = toRaw(value);
          }
          const target = toRaw(this);
          const { has, get } = getProto(target);
          let hadKey = has.call(target, key);
          if (!hadKey) {
            key = toRaw(key);
            hadKey = has.call(target, key);
          } else {
            checkIdentityKeys(target, has, key);
          }
          const oldValue = get.call(target, key);
          target.set(key, value);
          if (!hadKey) {
            trigger(target, "add", key, value);
          } else if (hasChanged(value, oldValue)) {
            trigger(target, "set", key, value, oldValue);
          }
          return this;
        },
        delete(key) {
          const target = toRaw(this);
          const { has, get } = getProto(target);
          let hadKey = has.call(target, key);
          if (!hadKey) {
            key = toRaw(key);
            hadKey = has.call(target, key);
          } else {
            checkIdentityKeys(target, has, key);
          }
          const oldValue = get ? get.call(target, key) : void 0;
          const result = target.delete(key);
          if (hadKey) {
            trigger(target, "delete", key, void 0, oldValue);
          }
          return result;
        },
        clear() {
          const target = toRaw(this);
          const hadItems = target.size !== 0;
          const oldTarget = isMap(target) ? new Map(target) : new Set(target) ;
          const result = target.clear();
          if (hadItems) {
            trigger(
              target,
              "clear",
              void 0,
              void 0,
              oldTarget
            );
          }
          return result;
        }
      }
    );
    const iteratorMethods = [
      "keys",
      "values",
      "entries",
      Symbol.iterator
    ];
    iteratorMethods.forEach((method) => {
      instrumentations[method] = createIterableMethod(method, readonly, shallow);
    });
    return instrumentations;
  }
  function createInstrumentationGetter(isReadonly2, shallow) {
    const instrumentations = createInstrumentations(isReadonly2, shallow);
    return (target, key, receiver) => {
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_raw") {
        return target;
      }
      return Reflect.get(
        hasOwn(instrumentations, key) && key in target ? instrumentations : target,
        key,
        receiver
      );
    };
  }
  const mutableCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, false)
  };
  const shallowCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, true)
  };
  const readonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, false)
  };
  const shallowReadonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, true)
  };
  function checkIdentityKeys(target, has, key) {
    const rawKey = toRaw(key);
    if (rawKey !== key && has.call(target, rawKey)) {
      const type = toRawType(target);
      warn(
        `Reactive ${type} contains both the raw and reactive versions of the same object${type === `Map` ? ` as keys` : ``}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`
      );
    }
  }

  const reactiveMap = /* @__PURE__ */ new WeakMap();
  const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
  const readonlyMap = /* @__PURE__ */ new WeakMap();
  const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
  function targetTypeMap(rawType) {
    switch (rawType) {
      case "Object":
      case "Array":
        return 1 /* COMMON */;
      case "Map":
      case "Set":
      case "WeakMap":
      case "WeakSet":
        return 2 /* COLLECTION */;
      default:
        return 0 /* INVALID */;
    }
  }
  function getTargetType(value) {
    return value["__v_skip"] || !Object.isExtensible(value) ? 0 /* INVALID */ : targetTypeMap(toRawType(value));
  }
  function reactive(target) {
    if (isReadonly(target)) {
      return target;
    }
    return createReactiveObject(
      target,
      false,
      mutableHandlers,
      mutableCollectionHandlers,
      reactiveMap
    );
  }
  function shallowReactive(target) {
    return createReactiveObject(
      target,
      false,
      shallowReactiveHandlers,
      shallowCollectionHandlers,
      shallowReactiveMap
    );
  }
  function readonly(target) {
    return createReactiveObject(
      target,
      true,
      readonlyHandlers,
      readonlyCollectionHandlers,
      readonlyMap
    );
  }
  function shallowReadonly(target) {
    return createReactiveObject(
      target,
      true,
      shallowReadonlyHandlers,
      shallowReadonlyCollectionHandlers,
      shallowReadonlyMap
    );
  }
  function createReactiveObject(target, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
    if (!isObject(target)) {
      {
        warn(
          `value cannot be made ${isReadonly2 ? "readonly" : "reactive"}: ${String(
          target
        )}`
        );
      }
      return target;
    }
    if (target["__v_raw"] && !(isReadonly2 && target["__v_isReactive"])) {
      return target;
    }
    const targetType = getTargetType(target);
    if (targetType === 0 /* INVALID */) {
      return target;
    }
    const existingProxy = proxyMap.get(target);
    if (existingProxy) {
      return existingProxy;
    }
    const proxy = new Proxy(
      target,
      targetType === 2 /* COLLECTION */ ? collectionHandlers : baseHandlers
    );
    proxyMap.set(target, proxy);
    return proxy;
  }
  function isReactive(value) {
    if (isReadonly(value)) {
      return isReactive(value["__v_raw"]);
    }
    return !!(value && value["__v_isReactive"]);
  }
  function isReadonly(value) {
    return !!(value && value["__v_isReadonly"]);
  }
  function isShallow(value) {
    return !!(value && value["__v_isShallow"]);
  }
  function isProxy(value) {
    return value ? !!value["__v_raw"] : false;
  }
  function toRaw(observed) {
    const raw = observed && observed["__v_raw"];
    return raw ? toRaw(raw) : observed;
  }
  function markRaw(value) {
    if (!hasOwn(value, "__v_skip") && Object.isExtensible(value)) {
      def(value, "__v_skip", true);
    }
    return value;
  }
  const toReactive = (value) => isObject(value) ? reactive(value) : value;
  const toReadonly = (value) => isObject(value) ? readonly(value) : value;

  function isRef(r) {
    return r ? r["__v_isRef"] === true : false;
  }
  function ref(value) {
    return createRef(value, false);
  }
  function shallowRef(value) {
    return createRef(value, true);
  }
  function createRef(rawValue, shallow) {
    if (isRef(rawValue)) {
      return rawValue;
    }
    return new RefImpl(rawValue, shallow);
  }
  class RefImpl {
    constructor(value, isShallow2) {
      this.dep = new Dep();
      this["__v_isRef"] = true;
      this["__v_isShallow"] = false;
      this._rawValue = isShallow2 ? value : toRaw(value);
      this._value = isShallow2 ? value : toReactive(value);
      this["__v_isShallow"] = isShallow2;
    }
    get value() {
      {
        this.dep.track({
          target: this,
          type: "get",
          key: "value"
        });
      }
      return this._value;
    }
    set value(newValue) {
      const oldValue = this._rawValue;
      const useDirectValue = this["__v_isShallow"] || isShallow(newValue) || isReadonly(newValue);
      newValue = useDirectValue ? newValue : toRaw(newValue);
      if (hasChanged(newValue, oldValue)) {
        this._rawValue = newValue;
        this._value = useDirectValue ? newValue : toReactive(newValue);
        {
          this.dep.trigger({
            target: this,
            type: "set",
            key: "value",
            newValue,
            oldValue
          });
        }
      }
    }
  }
  function triggerRef(ref2) {
    if (ref2.dep) {
      {
        ref2.dep.trigger({
          target: ref2,
          type: "set",
          key: "value",
          newValue: ref2._value
        });
      }
    }
  }
  function unref(ref2) {
    return isRef(ref2) ? ref2.value : ref2;
  }
  function toValue(source) {
    return isFunction(source) ? source() : unref(source);
  }
  const shallowUnwrapHandlers = {
    get: (target, key, receiver) => key === "__v_raw" ? target : unref(Reflect.get(target, key, receiver)),
    set: (target, key, value, receiver) => {
      const oldValue = target[key];
      if (isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      } else {
        return Reflect.set(target, key, value, receiver);
      }
    }
  };
  function proxyRefs(objectWithRefs) {
    return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
  }
  class CustomRefImpl {
    constructor(factory) {
      this["__v_isRef"] = true;
      this._value = void 0;
      const dep = this.dep = new Dep();
      const { get, set } = factory(dep.track.bind(dep), dep.trigger.bind(dep));
      this._get = get;
      this._set = set;
    }
    get value() {
      return this._value = this._get();
    }
    set value(newVal) {
      this._set(newVal);
    }
  }
  function customRef(factory) {
    return new CustomRefImpl(factory);
  }
  function toRefs(object) {
    if (!isProxy(object)) {
      warn(`toRefs() expects a reactive object but received a plain one.`);
    }
    const ret = isArray(object) ? new Array(object.length) : {};
    for (const key in object) {
      ret[key] = propertyToRef(object, key);
    }
    return ret;
  }
  class ObjectRefImpl {
    constructor(_object, _key, _defaultValue) {
      this._object = _object;
      this._key = _key;
      this._defaultValue = _defaultValue;
      this["__v_isRef"] = true;
      this._value = void 0;
    }
    get value() {
      const val = this._object[this._key];
      return this._value = val === void 0 ? this._defaultValue : val;
    }
    set value(newVal) {
      this._object[this._key] = newVal;
    }
    get dep() {
      return getDepFromReactive(toRaw(this._object), this._key);
    }
  }
  class GetterRefImpl {
    constructor(_getter) {
      this._getter = _getter;
      this["__v_isRef"] = true;
      this["__v_isReadonly"] = true;
      this._value = void 0;
    }
    get value() {
      return this._value = this._getter();
    }
  }
  function toRef(source, key, defaultValue) {
    if (isRef(source)) {
      return source;
    } else if (isFunction(source)) {
      return new GetterRefImpl(source);
    } else if (isObject(source) && arguments.length > 1) {
      return propertyToRef(source, key, defaultValue);
    } else {
      return ref(source);
    }
  }
  function propertyToRef(source, key, defaultValue) {
    const val = source[key];
    return isRef(val) ? val : new ObjectRefImpl(source, key, defaultValue);
  }

  class ComputedRefImpl {
    constructor(fn, setter, isSSR) {
      this.fn = fn;
      this.setter = setter;
      /**
       * @internal
       */
      this._value = void 0;
      /**
       * @internal
       */
      this.dep = new Dep(this);
      /**
       * @internal
       */
      this.__v_isRef = true;
      // TODO isolatedDeclarations "__v_isReadonly"
      // A computed is also a subscriber that tracks other deps
      /**
       * @internal
       */
      this.deps = void 0;
      /**
       * @internal
       */
      this.depsTail = void 0;
      /**
       * @internal
       */
      this.flags = 16;
      /**
       * @internal
       */
      this.globalVersion = globalVersion - 1;
      /**
       * @internal
       */
      this.next = void 0;
      // for backwards compat
      this.effect = this;
      this["__v_isReadonly"] = !setter;
      this.isSSR = isSSR;
    }
    /**
     * @internal
     */
    notify() {
      this.flags |= 16;
      if (!(this.flags & 8) && // avoid infinite self recursion
      activeSub !== this) {
        batch(this, true);
        return true;
      }
    }
    get value() {
      const link = this.dep.track({
        target: this,
        type: "get",
        key: "value"
      }) ;
      refreshComputed(this);
      if (link) {
        link.version = this.dep.version;
      }
      return this._value;
    }
    set value(newValue) {
      if (this.setter) {
        this.setter(newValue);
      } else {
        warn("Write operation failed: computed value is readonly");
      }
    }
  }
  function computed(getterOrOptions, debugOptions, isSSR = false) {
    let getter;
    let setter;
    if (isFunction(getterOrOptions)) {
      getter = getterOrOptions;
    } else {
      getter = getterOrOptions.get;
      setter = getterOrOptions.set;
    }
    const cRef = new ComputedRefImpl(getter, setter, isSSR);
    if (debugOptions && !isSSR) {
      cRef.onTrack = debugOptions.onTrack;
      cRef.onTrigger = debugOptions.onTrigger;
    }
    return cRef;
  }

  const TrackOpTypes = {
    "GET": "get",
    "HAS": "has",
    "ITERATE": "iterate"
  };
  const TriggerOpTypes = {
    "SET": "set",
    "ADD": "add",
    "DELETE": "delete",
    "CLEAR": "clear"
  };
  const ReactiveFlags = {
    "SKIP": "__v_skip",
    "IS_REACTIVE": "__v_isReactive",
    "IS_READONLY": "__v_isReadonly",
    "IS_SHALLOW": "__v_isShallow",
    "RAW": "__v_raw",
    "IS_REF": "__v_isRef"
  };

  const WatchErrorCodes = {
    "WATCH_GETTER": 2,
    "2": "WATCH_GETTER",
    "WATCH_CALLBACK": 3,
    "3": "WATCH_CALLBACK",
    "WATCH_CLEANUP": 4,
    "4": "WATCH_CLEANUP"
  };
  const INITIAL_WATCHER_VALUE = {};
  const cleanupMap = /* @__PURE__ */ new WeakMap();
  let activeWatcher = void 0;
  function getCurrentWatcher() {
    return activeWatcher;
  }
  function onWatcherCleanup(cleanupFn, failSilently = false, owner = activeWatcher) {
    if (owner) {
      let cleanups = cleanupMap.get(owner);
      if (!cleanups) cleanupMap.set(owner, cleanups = []);
      cleanups.push(cleanupFn);
    } else if (!failSilently) {
      warn(
        `onWatcherCleanup() was called when there was no active watcher to associate with.`
      );
    }
  }
  function watch(source, cb, options = EMPTY_OBJ) {
    const { immediate, deep, once, scheduler, augmentJob, call } = options;
    const warnInvalidSource = (s) => {
      (options.onWarn || warn)(
        `Invalid watch source: `,
        s,
        `A watch source can only be a getter/effect function, a ref, a reactive object, or an array of these types.`
      );
    };
    const reactiveGetter = (source2) => {
      if (deep) return source2;
      if (isShallow(source2) || deep === false || deep === 0)
        return traverse$1(source2, 1);
      return traverse$1(source2);
    };
    let effect;
    let getter;
    let cleanup;
    let boundCleanup;
    let forceTrigger = false;
    let isMultiSource = false;
    if (isRef(source)) {
      getter = () => source.value;
      forceTrigger = isShallow(source);
    } else if (isReactive(source)) {
      getter = () => reactiveGetter(source);
      forceTrigger = true;
    } else if (isArray(source)) {
      isMultiSource = true;
      forceTrigger = source.some((s) => isReactive(s) || isShallow(s));
      getter = () => source.map((s) => {
        if (isRef(s)) {
          return s.value;
        } else if (isReactive(s)) {
          return reactiveGetter(s);
        } else if (isFunction(s)) {
          return call ? call(s, 2) : s();
        } else {
          warnInvalidSource(s);
        }
      });
    } else if (isFunction(source)) {
      if (cb) {
        getter = call ? () => call(source, 2) : source;
      } else {
        getter = () => {
          if (cleanup) {
            pauseTracking();
            try {
              cleanup();
            } finally {
              resetTracking();
            }
          }
          const currentEffect = activeWatcher;
          activeWatcher = effect;
          try {
            return call ? call(source, 3, [boundCleanup]) : source(boundCleanup);
          } finally {
            activeWatcher = currentEffect;
          }
        };
      }
    } else {
      getter = NOOP;
      warnInvalidSource(source);
    }
    if (cb && deep) {
      const baseGetter = getter;
      const depth = deep === true ? Infinity : deep;
      getter = () => traverse$1(baseGetter(), depth);
    }
    const scope = getCurrentScope();
    const watchHandle = () => {
      effect.stop();
      if (scope && scope.active) {
        remove(scope.effects, effect);
      }
    };
    if (once && cb) {
      const _cb = cb;
      cb = (...args) => {
        _cb(...args);
        watchHandle();
      };
    }
    let oldValue = isMultiSource ? new Array(source.length).fill(INITIAL_WATCHER_VALUE) : INITIAL_WATCHER_VALUE;
    const job = (immediateFirstRun) => {
      if (!(effect.flags & 1) || !effect.dirty && !immediateFirstRun) {
        return;
      }
      if (cb) {
        const newValue = effect.run();
        if (deep || forceTrigger || (isMultiSource ? newValue.some((v, i) => hasChanged(v, oldValue[i])) : hasChanged(newValue, oldValue))) {
          if (cleanup) {
            cleanup();
          }
          const currentWatcher = activeWatcher;
          activeWatcher = effect;
          try {
            const args = [
              newValue,
              // pass undefined as the old value when it's changed for the first time
              oldValue === INITIAL_WATCHER_VALUE ? void 0 : isMultiSource && oldValue[0] === INITIAL_WATCHER_VALUE ? [] : oldValue,
              boundCleanup
            ];
            oldValue = newValue;
            call ? call(cb, 3, args) : (
              // @ts-expect-error
              cb(...args)
            );
          } finally {
            activeWatcher = currentWatcher;
          }
        }
      } else {
        effect.run();
      }
    };
    if (augmentJob) {
      augmentJob(job);
    }
    effect = new ReactiveEffect(getter);
    effect.scheduler = scheduler ? () => scheduler(job, false) : job;
    boundCleanup = (fn) => onWatcherCleanup(fn, false, effect);
    cleanup = effect.onStop = () => {
      const cleanups = cleanupMap.get(effect);
      if (cleanups) {
        if (call) {
          call(cleanups, 4);
        } else {
          for (const cleanup2 of cleanups) cleanup2();
        }
        cleanupMap.delete(effect);
      }
    };
    {
      effect.onTrack = options.onTrack;
      effect.onTrigger = options.onTrigger;
    }
    if (cb) {
      if (immediate) {
        job(true);
      } else {
        oldValue = effect.run();
      }
    } else if (scheduler) {
      scheduler(job.bind(null, true), true);
    } else {
      effect.run();
    }
    watchHandle.pause = effect.pause.bind(effect);
    watchHandle.resume = effect.resume.bind(effect);
    watchHandle.stop = watchHandle;
    return watchHandle;
  }
  function traverse$1(value, depth = Infinity, seen) {
    if (depth <= 0 || !isObject(value) || value["__v_skip"]) {
      return value;
    }
    seen = seen || /* @__PURE__ */ new Set();
    if (seen.has(value)) {
      return value;
    }
    seen.add(value);
    depth--;
    if (isRef(value)) {
      traverse$1(value.value, depth, seen);
    } else if (isArray(value)) {
      for (let i = 0; i < value.length; i++) {
        traverse$1(value[i], depth, seen);
      }
    } else if (isSet(value) || isMap(value)) {
      value.forEach((v) => {
        traverse$1(v, depth, seen);
      });
    } else if (isPlainObject(value)) {
      for (const key in value) {
        traverse$1(value[key], depth, seen);
      }
      for (const key of Object.getOwnPropertySymbols(value)) {
        if (Object.prototype.propertyIsEnumerable.call(value, key)) {
          traverse$1(value[key], depth, seen);
        }
      }
    }
    return value;
  }

  var shim = {exports: {}};

  var useSyncExternalStoreShim_development = {};

  /**
   * @license React
   * use-sync-external-store-shim.development.js
   *
   * Copyright (c) Meta Platforms, Inc. and affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var hasRequiredUseSyncExternalStoreShim_development;

  function requireUseSyncExternalStoreShim_development () {
  	if (hasRequiredUseSyncExternalStoreShim_development) return useSyncExternalStoreShim_development;
  	hasRequiredUseSyncExternalStoreShim_development = 1;
  	((function () {
  	    function is(x, y) {
  	      return (x === y && (0 !== x || 1 / x === 1 / y)) || (x !== x && y !== y);
  	    }
  	    function useSyncExternalStore$2(subscribe, getSnapshot) {
  	      didWarnOld18Alpha ||
  	        void 0 === React.startTransition ||
  	        ((didWarnOld18Alpha = true),
  	        console.error(
  	          "You are using an outdated, pre-release alpha of React 18 that does not support useSyncExternalStore. The use-sync-external-store shim will not work correctly. Upgrade to a newer pre-release."
  	        ));
  	      var value = getSnapshot();
  	      if (!didWarnUncachedGetSnapshot) {
  	        var cachedValue = getSnapshot();
  	        objectIs(value, cachedValue) ||
  	          (console.error(
  	            "The result of getSnapshot should be cached to avoid an infinite loop"
  	          ),
  	          (didWarnUncachedGetSnapshot = true));
  	      }
  	      cachedValue = useState({
  	        inst: { value: value, getSnapshot: getSnapshot }
  	      });
  	      var inst = cachedValue[0].inst,
  	        forceUpdate = cachedValue[1];
  	      useLayoutEffect(
  	        function () {
  	          inst.value = value;
  	          inst.getSnapshot = getSnapshot;
  	          checkIfSnapshotChanged(inst) && forceUpdate({ inst: inst });
  	        },
  	        [subscribe, value, getSnapshot]
  	      );
  	      useEffect(
  	        function () {
  	          checkIfSnapshotChanged(inst) && forceUpdate({ inst: inst });
  	          return subscribe(function () {
  	            checkIfSnapshotChanged(inst) && forceUpdate({ inst: inst });
  	          });
  	        },
  	        [subscribe]
  	      );
  	      useDebugValue(value);
  	      return value;
  	    }
  	    function checkIfSnapshotChanged(inst) {
  	      var latestGetSnapshot = inst.getSnapshot;
  	      inst = inst.value;
  	      try {
  	        var nextValue = latestGetSnapshot();
  	        return !objectIs(inst, nextValue);
  	      } catch (error) {
  	        return true;
  	      }
  	    }
  	    function useSyncExternalStore$1(subscribe, getSnapshot) {
  	      return getSnapshot();
  	    }
  	    "undefined" !== typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ &&
  	      "function" ===
  	        typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStart &&
  	      __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStart(Error());
  	    var React = require$$0,
  	      objectIs = "function" === typeof Object.is ? Object.is : is,
  	      useState = React.useState,
  	      useEffect = React.useEffect,
  	      useLayoutEffect = React.useLayoutEffect,
  	      useDebugValue = React.useDebugValue,
  	      didWarnOld18Alpha = false,
  	      didWarnUncachedGetSnapshot = false,
  	      shim =
  	        "undefined" === typeof window ||
  	        "undefined" === typeof window.document ||
  	        "undefined" === typeof window.document.createElement
  	          ? useSyncExternalStore$1
  	          : useSyncExternalStore$2;
  	    useSyncExternalStoreShim_development.useSyncExternalStore =
  	      void 0 !== React.useSyncExternalStore ? React.useSyncExternalStore : shim;
  	    "undefined" !== typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ &&
  	      "function" ===
  	        typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStop &&
  	      __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStop(Error());
  	  }))();
  	return useSyncExternalStoreShim_development;
  }

  var hasRequiredShim;

  function requireShim () {
  	if (hasRequiredShim) return shim.exports;
  	hasRequiredShim = 1;

  	{
  	  shim.exports = requireUseSyncExternalStoreShim_development();
  	}
  	return shim.exports;
  }

  var shimExports = requireShim();

  /**
   * @internal
   */
  const isServer = typeof window === "undefined";
  /**
   * @internal
   */
  var InternalNameSpace;
  (function (InternalNameSpace) {
      InternalNameSpace["$$__ignore__$$"] = "$$__ignore__$$";
      InternalNameSpace["$$__persist__$$"] = "$$__persist__$$";
      InternalNameSpace["$$__subscribe__$$"] = "$$__subscribe__$$";
      InternalNameSpace["$$__redux_dev_tool__$$"] = "$$__redux_dev_tool__$$";
  })(InternalNameSpace || (InternalNameSpace = {}));

  const jobs = new Set();
  const MAX_UPDATE = 20;
  let process = false;
  let updateCount = 0;
  const flushQueue = () => {
      const all = [...jobs.values()].slice(0);
      jobs.clear();
      for (const job of all) {
          job.notify();
      }
      process = false;
      // fix miss update
      if (jobs.size) {
          updateCount++;
          if (updateCount > MAX_UPDATE) {
              throw new Error(`[reactivity-store] have a infinity update for current store, pendingJobs: ${new Set(jobs)}`);
          }
          flushQueue();
      }
  };
  /**
   * @internal
   */
  const queueJob = (job) => {
      jobs.add(job);
      if (process)
          return;
      process = true;
      updateCount = 0;
      Promise.resolve().then(flushQueue);
  };

  let currentController = null;
  function getCurrentController() {
      return currentController;
  }
  class ControllerEffect extends ReactiveEffect {
      get _isControllerEffect() {
          return true;
      }
      constructor(getter) {
          super(getter);
          {
              this._devVersion = "3.5.16";
          }
      }
  }
  const catchError = (cb, instance) => {
      return () => {
          if (!instance._isActive)
              return;
          {
              instance._devRunCount = instance._devRunCount || 0;
              instance._devRunCount++;
          }
          try {
              const res = cb();
              if (isPromise(res)) {
                  throw new Error(`[reactivity-store] selector should be a pure function, but current is a async function`);
              }
              return res;
          }
          catch (e) {
              {
                  console.error(`[reactivity-store] have an error for current selector, ${e === null || e === void 0 ? void 0 : e.message}, maybe you use the middleware with wrong usage, %o`, instance);
              }
              return null;
          }
      };
  };
  class Controller {
      constructor(_getState, _compare, _lifeCycle, _list, _namespace, _onUpdate) {
          this._getState = _getState;
          this._compare = _compare;
          this._lifeCycle = _lifeCycle;
          this._namespace = _namespace;
          this._onUpdate = _onUpdate;
          this._listeners = new Set();
          // make the state change and component update
          this._updateCount = 0;
          this._isActive = true;
          this.notify = () => {
              var _a;
              if (!this._isActive)
                  return;
              // TODO implement server side initialState
              if (isServer) {
                  console.error(`[reactivity-store] unexpected update for reactivity-store, should not update a state on the server`);
              }
              this._updateCount++;
              try {
                  (_a = this._onUpdate) === null || _a === void 0 ? void 0 : _a.call(this);
              }
              catch (e) {
                  {
                      console.error(`[reactivity-store] have an error for current updater, ${e === null || e === void 0 ? void 0 : e.message}, please check your subscribe, %o`, this);
                  }
                  this._lifeCycle.canUpdateComponent = false;
              }
              this._listeners.forEach((f) => f());
          };
          this._scheduler = () => {
              const p = getCurrentController();
              // eslint-disable-next-line @typescript-eslint/no-this-alias
              currentController = this;
              const newState = this._effect.run();
              currentController = p;
              if (!this._isActive)
                  return;
              const isSame = this._compare(this._state, newState);
              this._state = newState;
              if (!isSame) {
                  if (this._lifeCycle.canUpdateComponent) {
                      if (this._lifeCycle.syncUpdateComponent) {
                          this.notify();
                      }
                      else {
                          queueJob(this);
                      }
                  }
              }
          };
          this.subscribe = (listener) => {
              this._listeners.add(listener);
              return () => this._listeners.delete(listener);
          };
          this.getState = () => {
              return this._updateCount;
          };
          this.getEffect = () => {
              return this._effect;
          };
          this.getSelectorState = () => {
              return this._getStateSafe();
          };
          this.getLifeCycle = () => {
              return this._lifeCycle;
          };
          this._getStateSafe = catchError(_getState, this);
          this._effect = new ControllerEffect(this._getStateSafe);
          this._effect.scheduler = this._scheduler;
          if (this._namespace !== InternalNameSpace.$$__persist__$$ &&
              this._namespace !== InternalNameSpace.$$__subscribe__$$ &&
              this._namespace !== InternalNameSpace.$$__redux_dev_tool__$$) {
              this._list = _list;
              this._list.add(this);
          }
          {
              this._devVersion = "0.3.11";
          }
      }
      // TODO move into constructor function?
      run() {
          const p = getCurrentController();
          // eslint-disable-next-line @typescript-eslint/no-this-alias
          currentController = this;
          this._state = this._effect.run();
          currentController = p;
      }
      stop() {
          var _a, _b;
          this._effect.stop();
          this._listeners.clear();
          (_b = (_a = this._list) === null || _a === void 0 ? void 0 : _a.delete) === null || _b === void 0 ? void 0 : _b.call(_a, this);
          this._isActive = false;
      }
      setActive(d) {
          this._isActive = d;
      }
  }

  /******************************************************************************
  Copyright (c) Microsoft Corporation.

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */
  /* global Reflect, Promise, SuppressedError, Symbol, Iterator */


  function __rest(s, e) {
      var t = {};
      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
          t[p] = s[p];
      if (s != null && typeof Object.getOwnPropertySymbols === "function")
          for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
              if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                  t[p[i]] = s[p[i]];
          }
      return t;
  }

  typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
      var e = new Error(message);
      return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
  };

  /**
   * @internal
   */
  const createLifeCycle = () => ({
      onBeforeMount: [],
      onBeforeUpdate: [],
      onBeforeUnmount: [],
      onMounted: [],
      onUpdated: [],
      onUnmounted: [],
      hasHookInstall: false,
      canUpdateComponent: true,
      syncUpdateComponent: false,
  });

  /* eslint-disable @typescript-eslint/no-unused-expressions */
  function _traverse(value, seen) {
      if (!isObject(value) || value[ReactiveFlags.SKIP] || require$$0.isValidElement(value)) {
          return value;
      }
      seen = seen || new Set();
      if (seen.has(value)) {
          return value;
      }
      seen.add(value);
      if (isRef(value)) {
          traverse(value.value, seen);
      }
      else if (isArray(value)) {
          for (let i = 0; i < value.length; i++) {
              traverse(value[i], seen);
          }
      }
      else if (isSet(value) || isMap(value)) {
          value.forEach((v) => {
              traverse(v, seen);
          });
      }
      else if (isPlainObject(value)) {
          for (const key in value) {
              traverse(value[key], seen);
          }
      }
      return value;
  }
  function traverseShallow(value) {
      if (!isObject(value) || value[ReactiveFlags.SKIP] || require$$0.isValidElement(value)) {
          return value;
      }
      if (isRef(value)) {
          value.value;
      }
      else if (isArray(value)) {
          for (let i = 0; i < value.length; i++) {
              value[i];
          }
      }
      else if (isSet(value) || isMap(value)) {
          value.forEach((v) => {
          });
      }
      else if (isPlainObject(value)) {
          for (const key in value) {
              value[key];
          }
      }
      return value;
  }
  /**
   * @internal
   */
  function traverse(value, seen) {
      {
          const start = Date.now();
          const re = _traverse(value, seen);
          const end = Date.now();
          if (end - start > 5) {
              console.warn(`[reactivity-store] 'traverse' current data: %o take a lot of time`, re);
          }
          return re;
      }
  }
  /**
   * @internal
   */
  function checkHasReactive(value) {
      let hasReactive = false;
      function traverse(value, seen) {
          if (!isObject(value))
              return;
          if (hasReactive)
              return;
          if (isReactive(value) || isRef(value) || isProxy(value)) {
              hasReactive = true;
              return;
          }
          seen = seen || new Set();
          if (seen.has(value)) {
              return;
          }
          seen.add(value);
          if (isArray(value)) {
              for (let i = 0; i < value.length; i++) {
                  traverse(value[i], seen);
              }
          }
          else if (isSet(value) || isMap(value)) {
              value.forEach((v) => {
                  traverse(v, seen);
              });
          }
          else if (isPlainObject(value)) {
              for (const key in value) {
                  traverse(value[key], seen);
              }
          }
          return;
      }
      traverse(value);
      return hasReactive;
  }
  /**
   * @internal
   */
  function checkHasFunction(value) {
      let hasFunction = false;
      function traverse(value, seen) {
          if (hasFunction)
              return;
          if (isFunction(value)) {
              hasFunction = true;
              return;
          }
          seen = seen || new Set();
          if (seen.has(value)) {
              return;
          }
          seen.add(value);
          if (isArray(value)) {
              for (let i = 0; i < value.length; i++) {
                  traverse(value[i], seen);
              }
          }
          else if (isSet(value) || isMap(value)) {
              value.forEach((v) => {
                  traverse(v, seen);
              });
          }
          else if (isPlainObject(value)) {
              for (const key in value) {
                  traverse(value[key], seen);
              }
          }
          return;
      }
      traverse(value);
      return hasFunction;
  }
  /**
   * @internal
   */
  function checkHasSameField(source, target) {
      return Object.keys(source).filter((key) => key in target);
  }
  /**
   * @internal
   */
  function checkHasMiddleware(value) {
      if (value && (value === null || value === void 0 ? void 0 : value["$$__state__$$"]) && (value === null || value === void 0 ? void 0 : value["$$__middleware__$$"])) {
          return true;
      }
  }

  const namespaceMap = {};
  const temp$2 = new Set();
  const defaultCompare$2 = () => false;
  /**
   * @internal
   */
  const setNamespaceMap = (key, value) => {
      namespaceMap[key] = value;
  };
  /**
   * @internal
   */
  const delNamespace = (key) => {
      delete namespaceMap[key];
  };
  /**
   * @internal
   */
  const checkHasKey = (key) => {
      return key in namespaceMap;
  };
  // cache state which has connect to devtool
  const devToolMap = {};
  const devController = {};
  const globalName = "__reactivity-store-redux-devtools__";
  let globalDevTools = null;
  /**
   * @internal
   */
  const getDevToolInstance = () => globalDevTools || window.__REDUX_DEVTOOLS_EXTENSION__.connect({ name: globalName });
  /**
   * @internal
   */
  const sendToDevTools = (action) => {
      const { getUpdatedState } = action, rest = __rest(action, ["getUpdatedState"]);
      try {
          const state = getUpdatedState();
          getDevToolInstance().send(rest, state);
      }
      catch (e) {
          console.log(e);
      }
  };
  /**
   * @internal
   */
  const connectDevTool = (name, actions, readonlyState, reactiveState, options) => {
      if (window && window.__REDUX_DEVTOOLS_EXTENSION__ && typeof window.__REDUX_DEVTOOLS_EXTENSION__.connect === "function") {
          try {
              const devTools = globalDevTools || window.__REDUX_DEVTOOLS_EXTENSION__.connect({ name: globalName });
              globalDevTools = devTools;
              const existController = devController[name];
              if (existController) {
                  existController.stop();
              }
              devToolMap[name] = readonlyState;
              const lifeCycle = createLifeCycle();
              lifeCycle.syncUpdateComponent = true;
              let updateInActionCount = 0;
              const onUpdateWithoutAction = () => {
                  if (updateInActionCount > 0)
                      return;
                  sendToDevTools({
                      type: `subscribeAction-${name}`,
                      getUpdatedState: () => (Object.assign(Object.assign({}, devToolMap), { [name]: readonlyState })),
                  });
              };
              const subscribe = () => {
                  let re = reactiveState;
                  if ((options === null || options === void 0 ? void 0 : options.listener) && typeof (options === null || options === void 0 ? void 0 : options.listener) === "function") {
                      re = options.listener(reactiveState);
                  }
                  if (options === null || options === void 0 ? void 0 : options.shallow) {
                      traverseShallow(re);
                  }
                  else {
                      traverse(re);
                  }
              };
              // create a subscribe controller to listen to the state change, because some state change may not trigger by the `action`
              const controller = new Controller(subscribe, defaultCompare$2, lifeCycle, temp$2, InternalNameSpace.$$__redux_dev_tool__$$, onUpdateWithoutAction);
              controller._devReduxOptions = options;
              devController[name] = controller;
              controller.run();
              const obj = Object.assign({}, devToolMap);
              devTools.init(obj);
              return Object.keys(actions).reduce((p, c) => {
                  p[c] = (...args) => {
                      updateInActionCount++;
                      const len = actions[c].length || 0;
                      const re = actions[c](...args);
                      const action = actions[c];
                      if (isPromise(re)) {
                          re.finally(() => {
                              sendToDevTools({
                                  type: `asyncAction-${name}/${action.name || "anonymous"}`,
                                  $payload: args.slice(0, len),
                                  getUpdatedState: () => (Object.assign(Object.assign({}, devToolMap), { [name]: readonlyState })),
                              });
                              updateInActionCount--;
                          });
                      }
                      else {
                          sendToDevTools({
                              type: `syncAction-${name}/${action.name || "anonymous"}`,
                              $payload: args.slice(0, len),
                              getUpdatedState: () => (Object.assign(Object.assign({}, devToolMap), { [name]: readonlyState })),
                          });
                          updateInActionCount--;
                      }
                      return re;
                  };
                  return p;
              }, {});
          }
          catch (e) {
              {
                  console.warn(`[reactivity-store] connect to redux devtools failed, please check the redux devtools extension`, e);
              }
              return actions;
          }
      }
      else {
          return actions;
      }
  };

  /* eslint-disable @typescript-eslint/no-unsafe-function-type */
  /**
   * @internal
   */
  const useCallbackRef = (callback) => {
      const callbackRef = require$$0.useRef(callback);
      callbackRef.current = callback;
      const memoCallback = require$$0.useCallback((...args) => {
          var _a;
          return (_a = callbackRef.current) === null || _a === void 0 ? void 0 : _a.call(null, ...args);
      }, []);
      return memoCallback;
  };
  /**
   * @internal
   */
  const useSubscribeCallbackRef = (callback, deepSelector) => {
      const callbackRef = require$$0.useRef();
      callbackRef.current = typeof callback === "function" ? callback : null;
      const memoCallback = useCallbackRef((arg) => {
          if (callbackRef.current) {
              const re = callbackRef.current(arg);
              if (deepSelector) {
                  traverse(re);
              }
              else {
                  // fix useState(s => s) not subscribe reactive state update
                  traverseShallow(re);
              }
              return re;
          }
          else {
              // !BREAKING CHANGE, will change the default behavior when the deepSelector is true
              if (deepSelector) {
                  traverse(arg);
              }
              else {
                  traverseShallow(arg);
              }
              return arg;
          }
      });
      return memoCallback;
  };
  /**
   * @internal
   */
  const usePrevValue = (v) => {
      const vRef = require$$0.useRef(v);
      require$$0.useEffect(() => {
          vRef.current = v;
      }, [v]);
      return vRef.current;
  };
  const createHook = (reactiveState, readonlyState, initialState, lifeCycle, deepSelector = true, stableSelector = false, stableCompare = true, namespace, actions = undefined) => {
      const controllerList = new Set();
      // TODO
      if (!isServer && namespace) {
          setNamespaceMap(namespace, initialState);
      }
      let active = true;
      namespace = namespace || InternalNameSpace.$$__ignore__$$;
      // tool function to generate `useSelector` hook
      const generateUseHook = (type) => {
          const currentIsDeep = type === "default" ? deepSelector : type === "deep" || type === "deep-stable";
          const currentIsStable = type === "default" ? stableSelector : type === "deep-stable" || type === "shallow-stable";
          function useReactiveHookWithSelector(selector, compare) {
              const ref = require$$0.useRef();
              const selectorRef = useSubscribeCallbackRef(selector, currentIsDeep);
              const getSelected = useCallbackRef(() => {
                  // 0.1.9
                  // make the returned value as a readonly value, so the only way to change the state is in the `actions` middleware
                  if (selector) {
                      ref.current = selector(Object.assign(Object.assign({}, readonlyState), actions));
                  }
                  else {
                      ref.current = Object.assign(Object.assign({}, readonlyState), actions);
                  }
              });
              const memoCompare = useCallbackRef((p, n) => {
                  if (compare && typeof compare === "function") {
                      return compare(p, n);
                  }
                  return false;
              });
              // may not work will with hmr
              const prevSelector = currentIsStable ? selector : usePrevValue(selector);
              const prevCompare = stableCompare ? compare : usePrevValue(compare);
              const ControllerInstance = require$$0.useMemo(() => new Controller(() => selectorRef(reactiveState), memoCompare, lifeCycle, controllerList, namespace, getSelected), []);
              shimExports.useSyncExternalStore(ControllerInstance.subscribe, ControllerInstance.getState, ControllerInstance.getState);
              // initial
              require$$0.useMemo(() => {
                  ControllerInstance.run();
                  getSelected();
              }, [ControllerInstance, getSelected]);
              // !TODO try to improve the performance
              // rerun when the 'selector' change
              require$$0.useMemo(() => {
                  if (prevSelector !== selector) {
                      ControllerInstance.run();
                      getSelected();
                  }
              }, [ControllerInstance, prevSelector, selector]);
              require$$0.useMemo(() => {
                  if (prevCompare !== compare) {
                      ControllerInstance.run();
                      getSelected();
                  }
              }, [ControllerInstance, prevCompare, compare]);
              {
                  ControllerInstance._devSelector = selector;
                  ControllerInstance._devCompare = compare;
                  ControllerInstance._devActions = actions;
                  ControllerInstance._devWithDeep = currentIsDeep;
                  ControllerInstance._devWithStable = currentIsStable;
                  ControllerInstance._devType = type;
                  ControllerInstance._devState = initialState;
                  ControllerInstance._devResult = ref.current;
              }
              require$$0.useEffect(() => {
                  ControllerInstance.setActive(true);
                  return () => {
                      // fix React strictMode issue
                      {
                          ControllerInstance.setActive(false);
                      }
                  };
              }, [ControllerInstance]);
              return ref.current;
          }
          return useReactiveHookWithSelector;
      };
      const defaultHook = generateUseHook("default");
      const deepHook = generateUseHook("deep");
      const deepStableHook = generateUseHook("deep-stable");
      const shallowHook = generateUseHook("shallow");
      const shallowStableHook = generateUseHook("shallow-stable");
      function useSelector(selector, compare) {
          return defaultHook(selector, compare);
      }
      const typedUseSelector = useSelector;
      typedUseSelector.getState = () => toRaw(initialState);
      typedUseSelector.getLifeCycle = () => lifeCycle;
      typedUseSelector.getActions = () => actions;
      typedUseSelector.getReactiveState = () => reactiveState;
      typedUseSelector.getReadonlyState = () => readonlyState;
      typedUseSelector.useDeepSelector = deepHook;
      typedUseSelector.useDeepStableSelector = deepStableHook;
      typedUseSelector.useShallowSelector = shallowHook;
      typedUseSelector.useShallowStableSelector = shallowStableHook;
      typedUseSelector.subscribe = (selector, cb, shallow) => {
          const subscribeSelector = () => {
              const re = selector(reactiveState);
              if (isPromise(re)) {
                  console.error(`[reactivity-store/subscribe] selector should return a plain object, but current is a promise`);
              }
              if (shallow) {
                  traverseShallow(re);
              }
              else {
                  traverse(re);
              }
              return re;
          };
          const controller = new Controller(subscribeSelector, Object.is, lifeCycle, controllerList, InternalNameSpace.$$__subscribe__$$, () => cb());
          controller.run();
          return () => controller.stop();
      };
      typedUseSelector.getIsActive = () => active;
      typedUseSelector.clear = () => {
          controllerList.forEach((i) => i.stop());
          if (!isServer && namespace) {
              delNamespace(namespace);
          }
          active = false;
      };
      return typedUseSelector;
  };

  /* eslint-disable @typescript-eslint/no-unsafe-function-type */
  /**
   * @internal
   */
  const persistKey = "reactivity-store/persist-";
  /**
   * @internal
   */
  const debounce = (cb, time) => {
      let id = null;
      return ((...args) => {
          clearTimeout(id);
          id = setTimeout(() => cb.call(null, ...args), time);
      });
  };
  /**
   * @internal
   */
  const getFinalState = (state) => {
      if (state["$$__state__$$"])
          return state["$$__state__$$"];
      return state;
  };
  /**
   * @internal
   */
  const getFinalMiddleware = (state) => {
      if (state["$$__state__$$"])
          return (state["$$__middleware__$$"] || {});
      return {};
  };
  /**
   * @internal
   */
  const getFinalActions = (state) => {
      if (state["$$__state__$$"])
          return (state["$$__actions__$$"] || {});
      return {};
  };
  /**
   * @internal
   */
  const getFinalNamespace = (state) => {
      if (state["$$__state__$$"])
          return (state["$$__namespace__$$"] || {});
      return {};
  };
  /**
   * @internal
   */
  const getFinalSelectorOptions = (state) => {
      if (state["$$__state__$$"])
          return (state["$$__selectorOptions__$$"] || {});
      return {};
  };
  // function for help to build external middleware
  /**
   * @internal
   */
  function createMiddleware(setup, options) {
      return () => {
          const state = setup();
          const initialState = getFinalState(state);
          const middleware = getFinalMiddleware(state);
          const actions = getFinalActions(state);
          const namespace = getFinalNamespace(state);
          const selectorOptions = getFinalSelectorOptions(state);
          if (middleware[options.name]) {
              console.warn(`[reactivity-store/middleware] you are using multiple of the '${options.name}' middleware, this is a unexpected usage`);
          }
          middleware[options.name] = true;
          return {
              ["$$__state__$$"]: toRaw(initialState),
              ["$$__actions__$$"]: actions,
              // field to check duplicate middleware
              ["$$__middleware__$$"]: middleware,
              ["$$__namespace__$$"]: namespace,
              ["$$__selectorOptions__$$"]: selectorOptions,
          };
      };
  }

  /**
   * @internal
   */
  const _internalCreateStore = (creator, name = "createStore", lifeCycle) => {
      const state = creator();
      if (isPromise(state)) {
          console.error(`[reactivity-store] '${name}' expect receive a reactive object but got a promise %o, this is a unexpected usage. should not return a promise in this 'creator' function`, state);
      }
      if (!isObject(state)) {
          console.error(`[reactivity-store] '${name}' expect receive a reactive object but got a ${state}, this is a unexpected usage. should return a reactive object in this 'creator' function`);
      }
      if (checkHasMiddleware(state)) {
          console.error(`[reactivity-store] '${name}' not support middleware usage, please change to use 'createState'`);
      }
      if (!checkHasReactive(state)) {
          console.error(`[reactivity-store] '${name}' expect receive a reactive object but got a plain object %o, this is a unexpected usage. should return a reactive object in this 'creator' function`, state);
      }
      const _state = getFinalState(state);
      const rawState = toRaw(_state);
      const reactiveState = reactive(_state);
      const readonlyState = readonly(_state);
      const lifeCycleInstance = lifeCycle || createLifeCycle();
      const useSelector = createHook(reactiveState, readonlyState, rawState, lifeCycleInstance);
      return useSelector;
  };
  /**
   * @internal
   */
  const internalCreateStore = (creator, name = "createStore", lifeCycle) => {
      const scope = effectScope();
      const useSelector = scope.run(() => _internalCreateStore(creator, name, lifeCycle));
      useSelector.scope = scope;
      return useSelector;
  };
  /**
   * @internal
   */
  let globalStoreLifeCycle = null;
  /**
   * @internal
   */
  const setGlobalStoreLifeCycle = (instance) => {
      globalStoreLifeCycle = instance;
  };

  // vue like lifeCycle for react app;
  /**
   * @public
   */
  const onMounted = (cb) => {
      if (!globalStoreLifeCycle)
          throw new Error("[reactivity-store] can not use 'onMounted' outside of the 'createStoreWithComponent' function");
      globalStoreLifeCycle.onMounted.push(cb);
      globalStoreLifeCycle.hasHookInstall = true;
  };
  /**
   * @public
   */
  const onUpdated = (cb) => {
      if (!globalStoreLifeCycle)
          throw new Error("[reactivity-store] can not use 'onUpdated' outside of the 'createStoreWithComponent' function");
      globalStoreLifeCycle.onUpdated.push(cb);
      globalStoreLifeCycle.hasHookInstall = true;
  };
  /**
   * @public
   */
  const onUnmounted = (cb) => {
      if (!globalStoreLifeCycle)
          throw new Error("[reactivity-store] can not use 'onUnmounted' outside of the 'createStoreWithComponent' function");
      globalStoreLifeCycle.onUnmounted.push(cb);
      globalStoreLifeCycle.hasHookInstall = true;
  };
  /**
   * @public
   */
  const onBeforeMount = (cb) => {
      if (!globalStoreLifeCycle)
          throw new Error("[reactivity-store] can not use 'onBeforeMount' outside of the 'createStoreWithComponent' function");
      globalStoreLifeCycle.onBeforeMount.push(cb);
      globalStoreLifeCycle.hasHookInstall = true;
  };
  /**
   * @public
   */
  const onBeforeUpdate = (cb) => {
      if (!globalStoreLifeCycle)
          throw new Error("[reactivity-store] can not use 'onBeforeUpdate' outside of the 'createStoreWithComponent' function");
      globalStoreLifeCycle.onBeforeUpdate.push(cb);
      globalStoreLifeCycle.hasHookInstall = true;
  };
  /**
   * @public
   */
  const onBeforeUnmount = (cb) => {
      if (!globalStoreLifeCycle)
          throw new Error("[reactivity-store] can not use 'onBeforeUnmount' outside of the 'createStoreWithComponent' function");
      globalStoreLifeCycle.onBeforeUnmount.push(cb);
      globalStoreLifeCycle.hasHookInstall = true;
  };

  /* eslint-disable @typescript-eslint/no-unsafe-function-type */
  /**
   * @public
   */
  function withActions(setup, options) {
      return createMiddleware(() => {
          const _initialState = setup();
          const initialState = getFinalState(_initialState);
          const middleware = getFinalMiddleware(_initialState);
          const actions = getFinalActions(_initialState);
          const namespace = getFinalNamespace(_initialState);
          const selectorOptions = getFinalSelectorOptions(_initialState);
          const reactiveState = reactive(initialState);
          const pendingGenerate = options.generateActions;
          const allActions = pendingGenerate === null || pendingGenerate === void 0 ? void 0 : pendingGenerate(reactiveState);
          const batchActions = allActions;
          // check duplicate key
          {
              Object.keys(initialState).forEach((key) => {
                  if (allActions[key]) {
                      console.error(`[reactivity-store/actions] there are duplicate key: [${key}] in the 'setup' and 'generateAction' returned value, this is a unexpected behavior.`);
                  }
              });
              Object.keys(allActions).forEach((key) => {
                  if (typeof allActions[key] !== "function") {
                      console.error(`[reactivity-store/actions] the value[${key}] return from 'generateActions' should be a function, but current is ${allActions[key]} in %o`, allActions);
                  }
              });
              Object.keys(actions).forEach((key) => {
                  if (allActions[key]) {
                      console.error(`[reactivity-store/actions] there are duplicate key: [${key}] in the 'action' return from 'withActions', this is a unexpected behavior.`);
                  }
              });
          }
          return {
              ["$$__state__$$"]: toRaw(reactiveState),
              ["$$__actions__$$"]: Object.assign(Object.assign({}, actions), batchActions),
              ["$$__middleware__$$"]: middleware,
              ["$$__namespace__$$"]: namespace,
              ["$$__selectorOptions__$$"]: selectorOptions,
          };
      }, { name: "withActions" });
  }

  /* eslint-disable @typescript-eslint/no-unsafe-function-type */
  const temp$1 = new Set();
  const defaultCompare$1 = () => false;
  /**
   * @public
   */
  function withPersist(setup, options) {
      return createMiddleware(() => {
          var _a, _b, _c, _d;
          const _initialState = setup();
          const initialState = getFinalState(_initialState);
          const middleware = getFinalMiddleware(_initialState);
          const auctions = getFinalActions(_initialState);
          const namespace = getFinalNamespace(_initialState);
          const selectorOptions = getFinalSelectorOptions(_initialState);
          let hasSet = false;
          if (middleware["withPersist"])
              hasSet = true;
          if (checkHasReactive(initialState)) {
              console.error(`[reactivity-store/persist] the 'setup' which from 'withPersist' should return a plain object, but current is a reactive object %o, you may use 'reactiveApi' in the 'setup' function`, initialState);
          }
          if (!isServer && !hasSet) {
              let re = initialState;
              const storageKey = persistKey + options.key;
              let storage = null;
              try {
                  storage = ((_a = options === null || options === void 0 ? void 0 : options.getStorage) === null || _a === void 0 ? void 0 : _a.call(options)) || (window === null || window === void 0 ? void 0 : window.localStorage);
                  if (!storage) {
                      if (true) {
                          console.error(`[reactivity-store/persist] can't find storage, please check your environment`);
                      }
                      return {
                          ["$$__state__$$"]: toRaw(initialState),
                          ["$$__middleware__$$"]: middleware,
                          ["$$__actions__$$"]: auctions,
                          ["$$__namespace__$$"]: namespace,
                          ["$$__selectorOptions__$$"]: selectorOptions,
                      };
                  }
                  const storageStateString = storage.getItem(storageKey);
                  const storageState = JSON.parse(storageStateString);
                  if ((storageState === null || storageState === void 0 ? void 0 : storageState.version) === (options.version || options.key) && storageState.data) {
                      const cachedState = ((_b = options === null || options === void 0 ? void 0 : options.parse) === null || _b === void 0 ? void 0 : _b.call(options, storageState.data)) || JSON.parse(storageState.data);
                      re = ((_c = options === null || options === void 0 ? void 0 : options.merge) === null || _c === void 0 ? void 0 : _c.call(options, initialState, cachedState)) || Object.assign(initialState, cachedState);
                  }
              }
              catch (e) {
                  {
                      console.error(`[reactivity-store/persist] middleware failed, error: ${e.message}`);
                  }
                  try {
                      (_d = storage.removeItem) === null || _d === void 0 ? void 0 : _d.call(storage, storageKey);
                  }
                  catch (_e) {
                  }
              }
              re = reactive(re);
              const onUpdate = debounce(() => {
                  var _a, _b, _c;
                  try {
                      const stringifyState = ((_a = options === null || options === void 0 ? void 0 : options.stringify) === null || _a === void 0 ? void 0 : _a.call(options, re)) || JSON.stringify(re);
                      const cache = { data: stringifyState, version: options.version || options.key };
                      if (true && options.devLog) {
                          console.log(`[reactivity-store/persist] state changed, try to cache newState: %o`, cache);
                      }
                      (_b = storage.setItem) === null || _b === void 0 ? void 0 : _b.call(storage, storageKey, JSON.stringify(cache));
                  }
                  catch (e) {
                      {
                          console.error(`[reactivity-store/persist] cache newState error, error: %o`, e);
                      }
                      try {
                          (_c = storage.removeItem) === null || _c === void 0 ? void 0 : _c.call(storage, storageKey);
                      }
                      catch (_d) {
                      }
                  }
              }, options.debounceTime || 40);
              const subscribe = () => {
                  let _re = re;
                  if (typeof options.listener === "function") {
                      _re = options.listener(re);
                  }
                  if (isPromise(_re)) {
                      console.error(`[reactivity-store/persist] listener should return a plain object, but current is a promise`);
                      return;
                  }
                  if (options.shallow) {
                      traverseShallow(_re);
                  }
                  else {
                      traverse(_re);
                  }
              };
              const ControllerInstance = new Controller(subscribe, defaultCompare$1, createLifeCycle(), temp$1, InternalNameSpace.$$__persist__$$, onUpdate);
              ControllerInstance.run();
              {
                  ControllerInstance._devPersistOptions = options;
              }
              return {
                  ["$$__state__$$"]: toRaw(re),
                  ["$$__middleware__$$"]: middleware,
                  ["$$__actions__$$"]: auctions,
                  ["$$__namespace__$$"]: namespace,
                  ["$$__selectorOptions__$$"]: selectorOptions,
              };
          }
          else {
              return {
                  ["$$__state__$$"]: toRaw(initialState),
                  ["$$__middleware__$$"]: middleware,
                  ["$$__actions__$$"]: auctions,
                  ["$$__namespace__$$"]: namespace,
                  ["$$__selectorOptions__$$"]: selectorOptions,
              };
          }
      }, { name: "withPersist" });
  }

  /* eslint-disable @typescript-eslint/no-unsafe-function-type */
  /**
   * @public
   */
  function withNamespace(setup, options) {
      return createMiddleware(() => {
          const _initialState = setup();
          const initialState = getFinalState(_initialState);
          const middleware = getFinalMiddleware(_initialState);
          const actions = getFinalActions(_initialState);
          const namespace = getFinalNamespace(_initialState);
          const selectorOptions = getFinalSelectorOptions(_initialState);
          if ((options.namespace === InternalNameSpace.$$__ignore__$$ ||
                  options.namespace === InternalNameSpace.$$__persist__$$ ||
                  options.namespace === InternalNameSpace.$$__subscribe__$$ ||
                  options.namespace === InternalNameSpace.$$__redux_dev_tool__$$)) {
              console.warn(`[reactivity-store/namespace] current namespace: '${options.namespace}' is a internal namespace, try to use another one`);
          }
          if (!isServer &&
              options.namespace !== InternalNameSpace.$$__ignore__$$ &&
              options.namespace !== InternalNameSpace.$$__persist__$$ &&
              options.namespace !== InternalNameSpace.$$__subscribe__$$ &&
              options.namespace !== InternalNameSpace.$$__redux_dev_tool__$$) {
              const alreadyHasNameSpace = checkHasKey(options.namespace);
              if (alreadyHasNameSpace) {
                  console.warn(`[reactivity-store/middleware] you have duplicate namespace '${options.namespace}' for current store, this is a unexpected usage`);
              }
              // setNamespaceMap(options.namespace, initialState);
          }
          return {
              ["$$__state__$$"]: toRaw(initialState),
              ["$$__actions__$$"]: actions,
              ["$$__middleware__$$"]: middleware,
              ["$$__namespace__$$"]: Object.assign(Object.assign({}, namespace), options),
              ["$$__selectorOptions__$$"]: selectorOptions,
          };
      }, { name: "withNamespace" });
  }

  /* eslint-disable @typescript-eslint/no-unsafe-function-type */
  /**
   * @public
   */
  function withSelectorOptions(setup, options) {
      return createMiddleware(() => {
          const _initialState = setup();
          const initialState = getFinalState(_initialState);
          const middleware = getFinalMiddleware(_initialState);
          const actions = getFinalActions(_initialState);
          const namespace = getFinalNamespace(_initialState);
          const selectorOptions = getFinalSelectorOptions(_initialState);
          return {
              ["$$__state__$$"]: toRaw(initialState),
              ["$$__actions__$$"]: actions,
              ["$$__middleware__$$"]: middleware,
              ["$$__namespace__$$"]: namespace,
              ["$$__selectorOptions__$$"]: Object.assign(Object.assign({}, selectorOptions), options),
          };
      }, { name: "withSelectorOptions" });
  }
  /**
   * @public
   * @deprecated
   * use `withSelectorOptions` instead
   */
  const withDeepSelector = withSelectorOptions;

  /**
   * @public
   * @deprecated
   * not recommend to use this function, use `createStore` instead
   */
  function createStoreWithComponent(props) {
      const { setup, render } = props;
      const ComponentWithState = (props) => {
          const useSelector = require$$0.useMemo(() => {
              const lifeCycleInstance = createLifeCycle();
              setGlobalStoreLifeCycle(lifeCycleInstance);
              const useSelector = internalCreateStore(setup, "createStoreWithComponent", lifeCycleInstance);
              setGlobalStoreLifeCycle(null);
              return useSelector;
          }, []);
          const [isMount, setIsMount] = require$$0.useState(false);
          const state = useSelector.getReadonlyState();
          {
              const sameField = checkHasSameField(state, props);
              sameField.forEach((key) => console.warn(`[reactivity-store] duplicate key: [${key}] in Component props and RStore state, this is a unexpected usage`));
          }
          const lifeCycleInstance = useSelector.getLifeCycle();
          const { children } = props, last = __rest(props, ["children"]);
          const _targetRender = render || props.children;
          const targetRender = _targetRender !== null && _targetRender !== void 0 ? _targetRender : (() => {
              lifeCycleInstance.canUpdateComponent = false;
              {
                  console.warn(`[reactivity-store] current reactive component not have a render function`);
              }
          });
          // subscribe reactivity-store update
          useSelector();
          require$$0.useEffect(() => {
              if (lifeCycleInstance.hasHookInstall) {
                  if (!isMount) {
                      lifeCycleInstance.onBeforeMount.forEach((f) => f());
                      lifeCycleInstance.onMounted.forEach((f) => f());
                      setIsMount(true);
                  }
                  else {
                      const lastSync = lifeCycleInstance.syncUpdateComponent;
                      lifeCycleInstance.syncUpdateComponent = true;
                      lifeCycleInstance.canUpdateComponent = false;
                      lifeCycleInstance.onBeforeUpdate.forEach((f) => f());
                      lifeCycleInstance.canUpdateComponent = true;
                      lifeCycleInstance.syncUpdateComponent = lastSync;
                      lifeCycleInstance.onUpdated.forEach((f) => f());
                  }
              }
          });
          require$$0.useEffect(() => {
              return () => {
                  if (lifeCycleInstance.hasHookInstall) {
                      lifeCycleInstance.onBeforeUnmount.forEach((f) => f());
                      lifeCycleInstance.onUnmounted.forEach((f) => f());
                  }
              };
          }, [lifeCycleInstance]);
          require$$0.useEffect(() => () => { var _a; return (_a = useSelector.scope) === null || _a === void 0 ? void 0 : _a.stop(); }, [useSelector]);
          const renderedChildren = targetRender(Object.assign(Object.assign({}, last), state)) || null;
          return renderedChildren;
      };
      return ComponentWithState;
  }

  /**
   * @public
   *
   * @example
   * ```typescript
   * import { createStore, ref } from "r-store";
   *
   * const count = createStore(() => {
   *  const state = ref(0);
   *
   *  const increment = () => {
   *    state.value++;
   *  };
   *
   *  return { state, increment };
   * });
   * ```
   */
  const createStore = (creator) => {
      return internalCreateStore(creator);
  };

  /**
   * @internal
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  function internalCreateState(setup, name, option) {
      var _a, _b, _c;
      let creator = setup;
      if (option === null || option === void 0 ? void 0 : option.withPersist) {
          creator = withPersist(creator, typeof option.withPersist === "string" ? { key: option.withPersist } : option.withPersist);
      }
      if (option === null || option === void 0 ? void 0 : option.withActions) {
          // eslint-disable-next-line @typescript-eslint/ban-ts-comment
          // @ts-ignore
          creator = withActions(creator, { generateActions: option.withActions });
      }
      if (option === null || option === void 0 ? void 0 : option.withNamespace) {
          creator = withNamespace(creator, typeof option.withNamespace === "string" ? { namespace: option.withNamespace, reduxDevTool: true } : option.withNamespace);
      }
      if (typeof (option === null || option === void 0 ? void 0 : option.withDeepSelector) !== "undefined" || typeof (option === null || option === void 0 ? void 0 : option.withStableSelector) !== "undefined") {
          creator = withSelectorOptions(creator, { deepSelector: option.withDeepSelector, stableSelector: option.withStableSelector });
      }
      const lifeCycle = createLifeCycle();
      const state = creator();
      if (!isObject(state)) {
          console.error(`[reactivity-store] '${name}' expect receive a plain object but got a ${state}, this is a unexpected usage. should return a plain object in this 'setup' function`);
      }
      // handle withActions middleware;
      const initialState = getFinalState(state);
      if (isPromise(initialState)) {
          console.error(`[reactivity-store] '${name}' expect receive a plain object but got a promise %o, this is a unexpected usage. should not return a promise in this 'setup' function`, initialState);
      }
      let actions = getFinalActions(state);
      const namespaceOptions = getFinalNamespace(state);
      const selectorOptions = getFinalSelectorOptions(state);
      const rawState = toRaw(initialState);
      const reduxDevTool = namespaceOptions.reduxDevTool && !isServer;
      if (checkHasReactive(rawState)) {
          console.error(`[reactivity-store] '${name}' expect receive a plain object but got a reactive object/field %o, this is a unexpected usage. should not use 'reactiveApi' in this 'setup' function`, rawState);
      }
      if (checkHasFunction(rawState)) {
          console.error(`[reactivity-store] '${name}' has a function field in state %o, this is a unexpected usage. state should be only a plain object with data field`, rawState);
      }
      {
          const sameField = checkHasSameField(rawState, actions);
          sameField.forEach((key) => console.warn(`[reactivity-store] duplicate key: [${key}] in 'state' and 'actions' from createState, this is a unexpected usage`));
      }
      const reactiveState = reactive(initialState);
      const readonlyState = readonly(initialState);
      const deepSelector = (_a = selectorOptions === null || selectorOptions === void 0 ? void 0 : selectorOptions.deepSelector) !== null && _a !== void 0 ? _a : true;
      const stableSelector = (_b = selectorOptions === null || selectorOptions === void 0 ? void 0 : selectorOptions.stableSelector) !== null && _b !== void 0 ? _b : false;
      const stableCompare = (_c = selectorOptions.stableCompare) !== null && _c !== void 0 ? _c : true;
      // TODO
      if (reduxDevTool) {
          actions = connectDevTool(namespaceOptions.namespace, actions, readonlyState, reactiveState, namespaceOptions);
      }
      const useSelector = createHook(reactiveState, readonlyState, rawState, lifeCycle, deepSelector, stableSelector, stableCompare, namespaceOptions.namespace, actions);
      return useSelector;
  }

  /* eslint-disable @typescript-eslint/no-empty-object-type */
  /* eslint-disable @typescript-eslint/no-unsafe-function-type */
  // `createState` provider
  /**
   * @public
   *
   * @example
   * ```typescript
   * import { createState } from "r-store";
   *
   * const count = createState(() => ({state: 0}), {
   *  withPersist: "count",
   *  withActions: (state) => ({
   *   increment: () => {
   *    state.state++;
   *   },
   *  }),
   *  withNamespace: "count",
   *  withDeepSelector: true,
   *  withStableSelector: true,
   * });
   * ```
   */
  function createState(setup, options) {
      return internalCreateState(setup, "createState", options);
  }

  const defaultBatch = (cb) => cb();
  /**
   * @internal
   */
  const batchObject = { current: defaultBatch };
  /**
   * @public
   * @deprecated
   * no need to use this function
   */
  const setBatch = (batch) => {
      batchObject.current = batch;
  };
  /**
   * @public
   * @deprecated
   * no need to use this function
   */
  const getBatch = () => {
      return batchObject.current;
  };
  /**
   * @public
   * @deprecated
   * no need to use this function
   */
  const resetBatch = () => {
      batchObject.current = defaultBatch;
  };
  /**
   * @public
   * @deprecated
   * no need to use this function
   */
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  const wrapperBatchUpdate = (cb) => {
      return ((...args) => batchObject.current(() => (args.length ? cb.call(null, ...args) : cb.call(null))));
  };

  const temp = new Set();
  const defaultCompare = () => false;
  /**
   * @public
   */
  const useReactiveEffect = (effectCallback) => {
      const memoCallback = useCallbackRef(effectCallback);
      require$$0.useEffect(() => {
          let cleanCb = () => void 0;
          const subscribe = () => {
              const clean = memoCallback();
              if (typeof clean === "function") {
                  cleanCb = clean;
              }
              else {
                  cleanCb = () => void 0;
              }
          };
          const controller = new Controller(subscribe, defaultCompare, createLifeCycle(), temp, InternalNameSpace.$$__subscribe__$$, () => {
              // run the effect when the subscribed state change
              cleanCb();
          });
          // run the effect on the component mount
          controller.run();
          return () => {
              cleanCb();
              controller.stop();
          };
      }, []);
  };

  /**
   * @public
   */
  const useReactiveState = (initialState) => {
      const [useSelector] = require$$0.useState(() => {
          const setup = typeof initialState === "function" ? initialState : () => initialState;
          return internalCreateState(setup, "useReactiveState");
      });
      // subscribe reactive store update
      useSelector();
      const setState = require$$0.useMemo(() => (payload) => {
          if (typeof payload === "function") {
              payload(useSelector.getReactiveState());
          }
          else {
              const reactiveObj = useSelector.getReactiveState();
              Object.keys(payload).forEach((key) => {
                  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                  // @ts-expect-error
                  reactiveObj[key] = payload[key];
              });
          }
      }, [useSelector]);
      require$$0.useEffect(() => () => false, [useSelector]);
      // make the state can be used in the `useReactiveEffect` hook
      // use getReactiveState to make effect can track deps
      return [useSelector.getReactiveState(), setState];
  };

  /**
   * @public
   */
  const version = "0.3.11";

  exports.ARRAY_ITERATE_KEY = ARRAY_ITERATE_KEY;
  exports.Controller = Controller;
  exports.EffectFlags = EffectFlags;
  exports.EffectScope = EffectScope;
  exports.ITERATE_KEY = ITERATE_KEY;
  exports.MAP_KEY_ITERATE_KEY = MAP_KEY_ITERATE_KEY;
  exports.ReactiveEffect = ReactiveEffect;
  exports.ReactiveFlags = ReactiveFlags;
  exports.TrackOpTypes = TrackOpTypes;
  exports.TriggerOpTypes = TriggerOpTypes;
  exports.WatchErrorCodes = WatchErrorCodes;
  exports.computed = computed;
  exports.createState = createState;
  exports.createStore = createStore;
  exports.createStoreWithComponent = createStoreWithComponent;
  exports.customRef = customRef;
  exports.effect = effect;
  exports.effectScope = effectScope;
  exports.enableTracking = enableTracking;
  exports.getBatch = getBatch;
  exports.getCurrentController = getCurrentController;
  exports.getCurrentScope = getCurrentScope;
  exports.getCurrentWatcher = getCurrentWatcher;
  exports.isProxy = isProxy;
  exports.isReactive = isReactive;
  exports.isReadonly = isReadonly;
  exports.isRef = isRef;
  exports.isShallow = isShallow;
  exports.markRaw = markRaw;
  exports.onBeforeMount = onBeforeMount;
  exports.onBeforeUnmount = onBeforeUnmount;
  exports.onBeforeUpdate = onBeforeUpdate;
  exports.onEffectCleanup = onEffectCleanup;
  exports.onMounted = onMounted;
  exports.onScopeDispose = onScopeDispose;
  exports.onUnmounted = onUnmounted;
  exports.onUpdated = onUpdated;
  exports.onWatcherCleanup = onWatcherCleanup;
  exports.pauseTracking = pauseTracking;
  exports.proxyRefs = proxyRefs;
  exports.reactive = reactive;
  exports.reactiveReadArray = reactiveReadArray;
  exports.readonly = readonly;
  exports.ref = ref;
  exports.resetBatch = resetBatch;
  exports.resetTracking = resetTracking;
  exports.setBatch = setBatch;
  exports.shallowReactive = shallowReactive;
  exports.shallowReadArray = shallowReadArray;
  exports.shallowReadonly = shallowReadonly;
  exports.shallowRef = shallowRef;
  exports.stop = stop;
  exports.toRaw = toRaw;
  exports.toReactive = toReactive;
  exports.toReadonly = toReadonly;
  exports.toRef = toRef;
  exports.toRefs = toRefs;
  exports.toValue = toValue;
  exports.track = track;
  exports.traverse = traverse$1;
  exports.trigger = trigger;
  exports.triggerRef = triggerRef;
  exports.unref = unref;
  exports.useReactiveEffect = useReactiveEffect;
  exports.useReactiveState = useReactiveState;
  exports.version = version;
  exports.watch = watch;
  exports.withActions = withActions;
  exports.withDeepSelector = withDeepSelector;
  exports.withNamespace = withNamespace;
  exports.withPersist = withPersist;
  exports.withSelectorOptions = withSelectorOptions;
  exports.wrapperBatchUpdate = wrapperBatchUpdate;

}));
