import StyleToObject from 'style-to-object';
import { camelCase } from './utilities.js';

/**
 * Parses CSS inline style to JavaScript object (camelCased).
 */
function StyleToJS(style, options) {
  const output = {};

  if (!style || typeof style !== 'string') {
    return output;
  }

  StyleToObject(style, (property, value) => {
    // skip CSS comment
    if (property && value) {
      output[camelCase(property, options)] = value;
    }
  });

  return output;
}

// For compatibility with CommonJS default export pattern
StyleToJS.default = StyleToJS;

export default StyleToJS;
