"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.get = exports.post = exports.buildHeaders = exports.getDefaultAgent = void 0;
const fetch = require("make-fetch-happen");
const http_proxy_agent_1 = require("http-proxy-agent");
const https_proxy_agent_1 = require("https-proxy-agent");
const http = require("http");
const https = require("https");
const proxy_from_env_1 = require("proxy-from-env");
const details = require('./details.json');
const httpAgentOptions = {
    keepAlive: true,
    keepAliveMsecs: 30 * 1000,
    timeout: 10 * 1000,
};
const httpNoProxyAgent = new http.Agent(httpAgentOptions);
const httpsNoProxyAgent = new https.Agent(httpAgentOptions);
const getDefaultAgent = (url) => {
    const proxy = (0, proxy_from_env_1.getProxyForUrl)(url.href);
    const isHttps = url.protocol === 'https:';
    if (!proxy || proxy === '') {
        return isHttps ? httpsNoProxyAgent : httpNoProxyAgent;
    }
    return isHttps
        ? new https_proxy_agent_1.HttpsProxyAgent(proxy, httpAgentOptions)
        : new http_proxy_agent_1.HttpProxyAgent(proxy, httpAgentOptions);
};
exports.getDefaultAgent = getDefaultAgent;
const buildHeaders = ({ appName, instanceId, etag, contentType, custom, specVersionSupported, connectionId, interval, }) => {
    const head = {};
    if (appName) {
        // TODO: delete
        head['User-Agent'] = appName;
        head['unleash-appname'] = appName;
    }
    if (instanceId) {
        head['UNLEASH-INSTANCEID'] = instanceId;
    }
    if (etag) {
        head['If-None-Match'] = etag;
    }
    if (contentType) {
        head['Content-Type'] = contentType;
    }
    if (specVersionSupported) {
        head['Unleash-Client-Spec'] = specVersionSupported;
    }
    const version = details.version;
    head['unleash-sdk'] = `unleash-node-sdk:${version}`;
    if (custom) {
        Object.assign(head, custom);
    }
    // unleash-connection-id and unleash-sdk should not be overwritten
    if (connectionId) {
        head['unleash-connection-id'] = connectionId;
    }
    // expressed in milliseconds to match refreshInterval and metricsInterval units
    // attach when set explicitly to non-zero value
    head['unleash-interval'] = String(interval);
    return head;
};
exports.buildHeaders = buildHeaders;
const post = ({ url, appName, timeout, instanceId, connectionId, interval, headers, json, httpOptions, }) => fetch(url, {
    timeout: timeout || 10000,
    method: 'POST',
    agent: (httpOptions === null || httpOptions === void 0 ? void 0 : httpOptions.agent) || exports.getDefaultAgent,
    headers: (0, exports.buildHeaders)({
        appName,
        instanceId,
        connectionId,
        interval,
        etag: undefined,
        contentType: 'application/json',
        custom: headers,
    }),
    body: JSON.stringify(json),
    strictSSL: httpOptions === null || httpOptions === void 0 ? void 0 : httpOptions.rejectUnauthorized,
});
exports.post = post;
const get = ({ url, etag, appName, timeout, instanceId, connectionId, interval, headers, httpOptions, supportedSpecVersion, }) => fetch(url, {
    method: 'GET',
    timeout: timeout || 10000,
    agent: (httpOptions === null || httpOptions === void 0 ? void 0 : httpOptions.agent) || exports.getDefaultAgent,
    headers: (0, exports.buildHeaders)({
        appName,
        instanceId,
        interval,
        etag,
        contentType: undefined,
        custom: headers,
        specVersionSupported: supportedSpecVersion,
        connectionId,
    }),
    retry: {
        retries: 2,
        maxTimeout: timeout || 10000,
    },
    strictSSL: httpOptions === null || httpOptions === void 0 ? void 0 : httpOptions.rejectUnauthorized,
});
exports.get = get;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/unleash-client/lib/request.js.map