"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strategy_1 = require("./strategy");
const util_1 = require("./util");
class GradualRolloutSessionIdStrategy extends strategy_1.Strategy {
    constructor() {
        super('gradualRolloutSessionId');
    }
    isEnabled(parameters, context) {
        const { sessionId } = context;
        if (!sessionId) {
            return false;
        }
        const percentage = Number(parameters.percentage);
        const groupId = parameters.groupId || '';
        const normalizedId = (0, util_1.normalizedStrategyValue)(sessionId, groupId);
        return percentage > 0 && normalizedId <= percentage;
    }
}
exports.default = GradualRolloutSessionIdStrategy;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/unleash-client/lib/strategy/gradual-rollout-session-id.js.map