"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strategy_1 = require("./strategy");
const ip_address_1 = require("ip-address");
class RemoteAddressStrategy extends strategy_1.Strategy {
    constructor() {
        super('remoteAddress');
    }
    isEnabled(parameters, context) {
        if (!parameters.IPs) {
            return false;
        }
        return parameters.IPs.split(/\s*,\s*/).some((range) => {
            if (range === context.remoteAddress) {
                return true;
            }
            try {
                const subnetRange = new ip_address_1.Address4(range);
                const remoteAddress = new ip_address_1.Address4(context.remoteAddress || '');
                return remoteAddress.isInSubnet(subnetRange);
            }
            catch (err) {
                return false;
            }
        });
    }
}
exports.default = RemoteAddressStrategy;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/unleash-client/lib/strategy/remote-addresss-strategy.js.map