"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strategy_1 = require("./strategy");
class UserWithIdStrategy extends strategy_1.Strategy {
    constructor() {
        super('userWithId');
    }
    isEnabled(parameters, context) {
        const userIdList = parameters.userIds ? parameters.userIds.split(/\s*,\s*/) : [];
        return userIdList.includes(context.userId);
    }
}
exports.default = UserWithIdStrategy;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/unleash-client/lib/strategy/user-with-id-strategy.js.map