"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.suffixSlash = void 0;
exports.resolveUrl = resolveUrl;
function resolveUrl(from, to) {
    const resolvedUrl = new URL(to, new URL(from, 'resolve://'));
    if (resolvedUrl.protocol === 'resolve:') {
        // `from` is a relative URL.
        const { pathname, search, hash } = resolvedUrl;
        return pathname + search + hash;
    }
    return resolvedUrl.toString();
}
const getUrl = (base, projectName, namePrefix, tags, mode) => {
    const isDeltaPolling = mode && mode.type === 'polling' && mode.format === 'delta';
    const url = resolveUrl(base, isDeltaPolling ? './client/delta' : './client/features');
    const params = new URLSearchParams();
    if (projectName) {
        params.append('project', projectName);
    }
    if (namePrefix) {
        params.append('namePrefix', namePrefix);
    }
    if (tags) {
        tags.forEach((tag) => params.append('tag', tag));
    }
    if (params.toString().length > 0) {
        return `${url}?${params.toString()}`;
    }
    return url;
};
const suffixSlash = (url) => (url.endsWith('/') ? url : `${url}/`);
exports.suffixSlash = suffixSlash;
exports.default = getUrl;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/c595276fa83d83a7c3233d582e4120f92017171c/node_modules/unleash-client/lib/url-utils.js.map