/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class SessionManagerDBus {
    private List<IListener> listeners = new ArrayList<IListener>();
    private Callback g_signal_callback;
    private long g_signal_callbackid;
    private ShutdownHook shutdownHook = new ShutdownHook(this);
    private long sessionManagerProxy;
    private long clientProxy;
    private String clientObjectPath;
    private boolean isGnome;
    private static int dbusTimeoutMsec = 10000;
    private long endSessionResponseCounter = 1L;
    private long endSessionResponseWanted = 0L;

    public SessionManagerDBus() {
        boolean isDisabled;
        boolean bl = isDisabled = System.getProperty("org.eclipse.swt.internal.SessionManagerDBus.disable") != null;
        if (isDisabled) {
            return;
        }
        this.start();
    }

    public void dispose() {
        this.stop();
    }

    public void addListener(IListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        this.listeners.remove(listener);
    }

    private boolean start() {
        if (!(this.connectSessionManager() && this.registerClient() && this.connectClientSignal())) {
            this.stop();
            return false;
        }
        this.shutdownHook.install();
        return true;
    }

    private synchronized void stop() {
        if (this.endSessionResponseWanted != 0L) {
            this.sendEndSessionResponse(true, "", this.endSessionResponseWanted);
        }
        if (this.sessionManagerProxy != 0L && this.clientObjectPath != null) {
            long args = OS.g_variant_new(Converter.javaStringToCString("(o)"), Converter.javaStringToCString(this.clientObjectPath));
            long[] error = new long[1];
            OS.g_dbus_proxy_call_sync(this.sessionManagerProxy, Converter.javaStringToCString("UnregisterClient"), args, 0, dbusTimeoutMsec, 0L, error);
            if (error[0] != 0L) {
                System.err.format("SWT SessionManagerDBus: Failed to UnregisterClient: %s%n", SessionManagerDBus.extractFreeGError(error[0]));
            }
            this.clientObjectPath = null;
        }
        if (this.clientProxy != 0L) {
            if (this.g_signal_callbackid != 0L) {
                OS.g_signal_handler_disconnect(this.clientProxy, this.g_signal_callbackid);
                this.g_signal_callbackid = 0L;
            }
            OS.g_object_unref(this.clientProxy);
            this.clientProxy = 0L;
        }
        if (this.sessionManagerProxy != 0L) {
            OS.g_object_unref(this.sessionManagerProxy);
            this.sessionManagerProxy = 0L;
        }
        if (this.g_signal_callback != null) {
            this.g_signal_callback.dispose();
            this.g_signal_callback = null;
        }
        this.shutdownHook.remove();
    }

    private long wantEndSessionResponse() {
        long responseID;
        this.endSessionResponseWanted = responseID = this.endSessionResponseCounter++;
        return responseID;
    }

    private void sendEndSessionResponse(boolean is_ok, String reason, long responseID) {
        if (responseID != this.endSessionResponseWanted) {
            return;
        }
        this.endSessionResponseWanted = 0L;
        long args = OS.g_variant_new(Converter.javaStringToCString("(bs)"), is_ok, Converter.javaStringToCString(reason));
        long[] error = new long[1];
        OS.g_dbus_proxy_call(this.clientProxy, Converter.javaStringToCString("EndSessionResponse"), args, 0, dbusTimeoutMsec, 0L, 0L, error);
        if (error[0] != 0L) {
            System.err.format("SWT SessionManagerDBus: Failed to EndSessionResponse: %s%n", SessionManagerDBus.extractFreeGError(error[0]));
        }
    }

    private boolean queryReadyToExit() {
        boolean isReady = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            IListener listener = this.listeners.get(i);
            isReady = isReady && listener.isReadyToExit();
        }
        return isReady;
    }

    private void handleQueryEndSession() {
        long responseID = this.wantEndSessionResponse();
        boolean isReady = this.queryReadyToExit();
        this.sendEndSessionResponse(isReady, "", responseID);
    }

    private void handleEndSession() {
        long responseID = this.wantEndSessionResponse();
        this.handleStop();
        this.sendEndSessionResponse(true, "", responseID);
    }

    private void handleStop() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IListener listener = this.listeners.get(i);
            listener.stop();
        }
    }

    private long g_signal_handler(long proxy, long sender_name, long signal_name, long parameters, long user_data) {
        String signalName;
        switch (signalName = Converter.cCharPtrToJavaString(signal_name, false)) {
            case "QueryEndSession": {
                this.handleQueryEndSession();
                break;
            }
            case "EndSession": {
                this.handleEndSession();
                break;
            }
            case "Stop": {
                this.handleStop();
            }
        }
        return 0L;
    }

    private static String extractVariantTupleS(long variant) {
        long childVariant = OS.g_variant_get_child_value(variant, 0);
        long childString = OS.g_variant_get_string(childVariant, null);
        String result = Converter.cCharPtrToJavaString(childString, false);
        OS.g_variant_unref(childVariant);
        return result;
    }

    private static String extractFreeGError(long errorPtr) {
        long errorMessageC = OS.g_error_get_message(errorPtr);
        String errorMessageStr = Converter.cCharPtrToJavaString(errorMessageC, false);
        OS.g_error_free(errorPtr);
        return errorMessageStr;
    }

    private long connectSessionManager(String dbusName, String objectPath, String interfaceName) {
        int sessionManagerFlags = 3;
        long[] error = new long[1];
        long proxy = OS.g_dbus_proxy_new_for_bus_sync(2, sessionManagerFlags, 0L, Converter.javaStringToCString(dbusName), Converter.javaStringToCString(objectPath), Converter.javaStringToCString(interfaceName), 0L, error);
        if (proxy == 0L) {
            String errorText = SessionManagerDBus.extractFreeGError(error[0]);
            System.err.format("SWT SessionManagerDBus: Failed to connect to %s: %s%n", dbusName, errorText);
            return 0L;
        }
        long owner = OS.g_dbus_proxy_get_name_owner(proxy);
        if (owner == 0L) {
            OS.g_object_unref(proxy);
            return 0L;
        }
        OS.g_free(owner);
        return proxy;
    }

    private boolean connectSessionManager() {
        long proxyGnome = this.connectSessionManager("org.gnome.SessionManager", "/org/gnome/SessionManager", "org.gnome.SessionManager");
        if (proxyGnome != 0L) {
            this.sessionManagerProxy = proxyGnome;
            this.isGnome = true;
            return true;
        }
        long proxyXFCE = this.connectSessionManager("org.xfce.SessionManager", "/org/xfce/SessionManager", "org.xfce.Session.Manager");
        if (proxyXFCE != 0L) {
            this.sessionManagerProxy = proxyXFCE;
            this.isGnome = false;
            return true;
        }
        return false;
    }

    private String claimDesktopAutostartID() {
        byte[] DESKTOP_AUTOSTART_ID = Converter.javaStringToCString("DESKTOP_AUTOSTART_ID");
        long valueC = OS.g_getenv(DESKTOP_AUTOSTART_ID);
        if (valueC == 0L) {
            return null;
        }
        String result = Converter.cCharPtrToJavaString(valueC, false);
        OS.g_unsetenv(DESKTOP_AUTOSTART_ID);
        return result;
    }

    private String registerClient(String appID, String clientStartupID) {
        long args = OS.g_variant_new(Converter.javaStringToCString("(ss)"), Converter.javaStringToCString(appID), Converter.javaStringToCString(clientStartupID));
        long[] error = new long[1];
        long clientInfo = OS.g_dbus_proxy_call_sync(this.sessionManagerProxy, Converter.javaStringToCString("RegisterClient"), args, 0, dbusTimeoutMsec, 0L, error);
        if (clientInfo == 0L) {
            return SessionManagerDBus.extractFreeGError(error[0]);
        }
        if (0L == OS.g_variant_n_children(clientInfo)) {
            return "Session manager's response to 'RegisterClient' is invalid";
        }
        this.clientObjectPath = SessionManagerDBus.extractVariantTupleS(clientInfo);
        OS.g_variant_unref(clientInfo);
        return null;
    }

    private boolean registerClient() {
        String errorText;
        String desktopAutostartID;
        String appID = System.getProperty("org.eclipse.swt.internal.SessionManagerDBus.appID");
        if (appID == null) {
            appID = "org.eclipse.swt.Application";
        }
        if ((desktopAutostartID = this.claimDesktopAutostartID()) != null) {
            errorText = this.registerClient(appID, desktopAutostartID);
            if (errorText == null) {
                return true;
            }
            boolean parentLeakedID = errorText.startsWith("GDBus.Error:org.gnome.SessionManager.AlreadyRegistered:");
            if (!parentLeakedID) {
                return false;
            }
        }
        if ((errorText = this.registerClient(appID, "")) == null) {
            return true;
        }
        if (!this.isGnome && errorText.startsWith("GDBus.Error:org.freedesktop.DBus.Error.UnknownMethod: ")) {
            return false;
        }
        System.err.format("SWT SessionManagerDBus: Failed to RegisterClient: %s%n", errorText);
        return false;
    }

    private boolean connectClientSignal() {
        String interfaceName;
        String dbusName;
        if (this.isGnome) {
            dbusName = "org.gnome.SessionManager";
            interfaceName = "org.gnome.SessionManager.ClientPrivate";
        } else {
            dbusName = "org.xfce.SessionManager";
            interfaceName = "org.xfce.Session.Client";
        }
        long[] error = new long[1];
        this.clientProxy = OS.g_dbus_proxy_new_for_bus_sync(2, 0, 0L, Converter.javaStringToCString(dbusName), Converter.javaStringToCString(this.clientObjectPath), Converter.javaStringToCString(interfaceName), 0L, error);
        if (this.clientProxy == 0L) {
            System.err.format("SWT SessionManagerDBus: Failed to connect to Client: %s%n", SessionManagerDBus.extractFreeGError(error[0]));
            return false;
        }
        this.g_signal_callback = new Callback(this, "g_signal_handler", 5);
        this.g_signal_callbackid = OS.g_signal_connect(this.clientProxy, Converter.javaStringToCString("g-signal"), this.g_signal_callback.getAddress(), 0L);
        return true;
    }

    private static class ShutdownHook
    extends Thread {
        private SessionManagerDBus parent;

        public ShutdownHook(SessionManagerDBus parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.stop();
        }

        public void install() {
            try {
                Runtime.getRuntime().addShutdownHook(this);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public void remove() {
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static interface IListener {
        public boolean isReadyToExit();

        public void stop();
    }
}

