/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.eclipse.swt.internal.AsyncReadyCallback;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class SyncDialogUtil {
    static int responseID;
    static Callback dialogResponseCallback;
    static Function<Long, Long> dialogAsyncFinish;
    static Long dialogAsyncValue;

    public static long run(Display display, AsyncReadyCallback callback) {
        SyncDialogUtil.initializeResponseCallback();
        dialogAsyncFinish = callback::await;
        callback.async(dialogResponseCallback.getAddress());
        while (!display.isDisposed() && dialogAsyncValue == null) {
            display.readAndDispatch();
        }
        SyncDialogUtil.disposeResponseCallback();
        return dialogAsyncValue;
    }

    public static int run(Display display, long handle, boolean isNativeDialog) {
        SyncDialogUtil.initializeResponseCallback();
        OS.g_signal_connect(handle, OS.response, dialogResponseCallback.getAddress(), 0L);
        if (isNativeDialog) {
            GTK.gtk_native_dialog_show(handle);
        } else {
            GTK.gtk_widget_show(handle);
        }
        while (!display.isDisposed()) {
            boolean eventsDispatched = OS.g_main_context_iteration(0L, false);
            if (responseID != -1) break;
            if (eventsDispatched) continue;
            display.sleep();
        }
        SyncDialogUtil.disposeResponseCallback();
        return responseID;
    }

    static void initializeResponseCallback() {
        dialogResponseCallback = new Callback(SyncDialogUtil.class, "dialogResponseProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        dialogAsyncValue = null;
        responseID = -1;
    }

    static void disposeResponseCallback() {
        dialogResponseCallback.dispose();
        dialogResponseCallback = null;
        dialogAsyncFinish = null;
    }

    static void dialogResponseProc(long dialog, long response_id, long user_data) {
        if (dialogAsyncFinish != null) {
            dialogAsyncValue = dialogAsyncFinish.apply(response_id);
        }
        responseID = (int)response_id;
    }
}

