/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Adapter;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Optional;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.JsonWriter;
import kotlin.jvm.internal.Intrinsics;

public final class ApolloOptionalAdapter<T>
implements Adapter<Optional<T>> {
    private final Adapter<T> wrappedAdapter;

    public ApolloOptionalAdapter(Adapter<T> wrappedAdapter) {
        Intrinsics.checkNotNullParameter(wrappedAdapter, "wrappedAdapter");
        this.wrappedAdapter = wrappedAdapter;
    }

    @Override
    public Optional<T> fromJson(JsonReader reader, CustomScalarAdapters customScalarAdapters) {
        Optional optional;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue();
            optional = Optional.Absent.INSTANCE;
        } else {
            optional = new Optional.Present<T>(this.wrappedAdapter.fromJson(reader, customScalarAdapters));
        }
        return optional;
    }

    @Override
    public void toJson(JsonWriter writer, CustomScalarAdapters customScalarAdapters, Optional<? extends T> value) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof Optional.Present) {
            this.wrappedAdapter.toJson(writer, customScalarAdapters, ((Optional.Present)value).getValue());
        } else {
            writer.nullValue();
        }
    }
}

