/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.exception.DefaultApolloException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.Source;
import okio.Timeout;

public final class MultipartReader
implements Closeable {
    private static final Companion Companion = new Companion(null);
    private final BufferedSource source;
    private final String boundary;
    private final ByteString dashDashBoundary;
    private final ByteString crlfDashDashBoundary;
    private int partCount;
    private boolean closed;
    private boolean noMoreParts;
    private PartSource currentPart;
    private final Options afterBoundaryOptions;

    public MultipartReader(BufferedSource source2, String boundary) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(boundary, "boundary");
        this.source = source2;
        this.boundary = boundary;
        this.dashDashBoundary = new Buffer().writeUtf8("--").writeUtf8(this.boundary).readByteString();
        this.crlfDashDashBoundary = new Buffer().writeUtf8("\r\n--").writeUtf8(this.boundary).readByteString();
        ByteString[] byteStringArray = new ByteString[]{ByteString.Companion.encodeUtf8("\r\n--" + this.boundary + "--"), ByteString.Companion.encodeUtf8("\r\n"), ByteString.Companion.encodeUtf8("--"), ByteString.Companion.encodeUtf8(" "), ByteString.Companion.encodeUtf8("\t")};
        this.afterBoundaryOptions = Options.Companion.of(byteStringArray);
    }

    public final Part nextPart() {
        PartSource partSource;
        if (!(!this.closed)) {
            boolean $i$a$-check-MultipartReader$nextPart$22 = false;
            String $i$a$-check-MultipartReader$nextPart$22 = "closed";
            throw new IllegalStateException($i$a$-check-MultipartReader$nextPart$22.toString());
        }
        if (this.noMoreParts) {
            return null;
        }
        if (this.partCount == 0 && this.source.rangeEquals(0L, this.dashDashBoundary)) {
            this.source.skip(this.dashDashBoundary.size());
        } else {
            long toSkip;
            while ((toSkip = this.currentPartBytesRemaining(8192L)) != 0L) {
                this.source.skip(toSkip);
            }
            this.source.skip(this.crlfDashDashBoundary.size());
        }
        boolean whitespace = false;
        block8: while (true) {
            switch (this.source.select(this.afterBoundaryOptions)) {
                case 0: {
                    if (this.partCount == 0) {
                        throw new DefaultApolloException("expected at least 1 part", null, 2, null);
                    }
                    this.noMoreParts = true;
                    return null;
                }
                case 1: {
                    int n = this.partCount;
                    this.partCount = n + 1;
                    break block8;
                }
                case 2: {
                    if (whitespace) {
                        throw new DefaultApolloException("unexpected characters after boundary", null, 2, null);
                    }
                    if (this.partCount == 0) {
                        throw new DefaultApolloException("expected at least 1 part", null, 2, null);
                    }
                    this.noMoreParts = true;
                    return null;
                }
                case 3: 
                case 4: {
                    whitespace = true;
                    continue block8;
                }
                case -1: {
                    if (this.source.exhausted()) {
                        throw new DefaultApolloException("premature end of multipart body", null, 2, null);
                    }
                    throw new DefaultApolloException("unexpected characters after boundary", null, 2, null);
                }
                default: {
                    continue block8;
                }
            }
            break;
        }
        List headers = MultipartReader.Companion.readHeaders(this.source);
        this.currentPart = partSource = new PartSource();
        return new Part(headers, Okio.buffer(partSource));
    }

    private final long currentPartBytesRemaining(long maxResult) {
        this.source.require(this.crlfDashDashBoundary.size());
        long delimiterIndex = this.source.getBuffer().indexOf(this.crlfDashDashBoundary);
        return delimiterIndex == -1L ? Math.min(maxResult, this.source.getBuffer().size() - (long)this.crlfDashDashBoundary.size() + 1L) : Math.min(maxResult, delimiterIndex);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.currentPart = null;
        this.source.close();
    }

    private static final class Companion {
        private Companion() {
        }

        private final List<HttpHeader> readHeaders(BufferedSource source2) {
            String line;
            List headers = new ArrayList();
            while (!(((CharSequence)(line = source2.readUtf8LineStrict())).length() == 0)) {
                int index = StringsKt.indexOf$default((CharSequence)line, ':', 0, false, 6, null);
                if (!(index != -1)) {
                    boolean bl = false;
                    String string = "Unexpected header: " + line;
                    throw new IllegalStateException(string.toString());
                }
                Collection collection = headers;
                String string = line.substring(0, index);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                String string2 = ((Object)StringsKt.trim(string)).toString();
                String string3 = line.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                collection.add(new HttpHeader(string2, ((Object)StringsKt.trim(string3)).toString()));
            }
            return headers;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Part
    implements Closeable {
        private final List<HttpHeader> headers;
        private final BufferedSource body;

        public Part(List<HttpHeader> headers, BufferedSource body) {
            Intrinsics.checkNotNullParameter(headers, "headers");
            Intrinsics.checkNotNullParameter(body, "body");
            this.headers = headers;
            this.body = body;
        }

        public final BufferedSource getBody() {
            return this.body;
        }

        @Override
        public void close() {
            this.body.close();
        }
    }

    private final class PartSource
    implements Source {
        @Override
        public void close() {
            if (Intrinsics.areEqual(MultipartReader.this.currentPart, this)) {
                MultipartReader.this.currentPart = null;
            }
        }

        @Override
        public long read(Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-MultipartReader$PartSource$read$22 = false;
                String $i$a$-require-MultipartReader$PartSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-MultipartReader$PartSource$read$22.toString());
            }
            if (!Intrinsics.areEqual(MultipartReader.this.currentPart, this)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            long limit = MultipartReader.this.currentPartBytesRemaining(byteCount);
            return limit == 0L ? -1L : MultipartReader.this.source.read(sink2, limit);
        }

        @Override
        public Timeout timeout() {
            return MultipartReader.this.source.timeout();
        }
    }
}

