/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.smartgit.graphql;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;

public final class SgLoggingInterceptor
implements Interceptor {
    public static final Companion Companion = new Companion(null);
    private final String jsonLoggingPath;
    private String requestOperation;
    private static final AtomicInteger requestIndex = new AtomicInteger(1);

    public SgLoggingInterceptor(String jsonLoggingPath) {
        this.jsonLoggingPath = jsonLoggingPath;
        this.requestOperation = "";
    }

    public final void setRequestOperation(String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.requestOperation = string;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter(chain, "chain");
        long timestamp = System.currentTimeMillis();
        String filename = this.jsonLoggingPath + "/smartgit-apollo." + timestamp + "." + requestIndex.getAndIncrement() + "." + this.requestOperation;
        Request request = chain.request();
        if (this.jsonLoggingPath != null) {
            String outFile = filename + ".out";
            RequestBody content = request.body();
            if (content != null) {
                File writer = new File(outFile);
                Buffer buffer = new Buffer();
                content.writeTo(buffer);
                FilesKt.writeText$default(writer, buffer.readUtf8(), null, 2, null);
            }
        }
        Response response = chain.proceed(request);
        if (this.jsonLoggingPath != null) {
            String outFile = filename + ".in";
            ResponseBody content = response.body();
            if (content != null) {
                File writer = new File(outFile);
                String rawContent = content.source().readString(Charsets.UTF_8);
                try {
                    Json this_$iv = Json.Default;
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    JsonObject test = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), rawContent);
                    Json encoder = JsonKt.Json$default(null, SgLoggingInterceptor::intercept$lambda$0, 1, null);
                    StringFormat $this$encodeToString$iv = encoder;
                    boolean $i$f$encodeToString = false;
                    $this$encodeToString$iv.getSerializersModule();
                    FilesKt.writeText$default(writer, $this$encodeToString$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), test), null, 2, null);
                }
                catch (SerializationException e) {
                    FilesKt.writeText$default(writer, rawContent, null, 2, null);
                }
                catch (IllegalArgumentException e) {
                    FilesKt.writeText$default(writer, rawContent, null, 2, null);
                }
                content.source().getBuffer().writeUtf8(rawContent);
            }
        }
        return response;
    }

    private static final Unit intercept$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter($this$Json, "$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

