/*
 * Decompiled with CFR 0.152.
 */
package kotlin.enums;

import java.io.Serializable;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.internal.Intrinsics;

final class EnumEntriesList<T extends Enum<T>>
extends AbstractList<T>
implements Serializable,
EnumEntries<T> {
    private final T[] entries;

    public EnumEntriesList(T[] entries) {
        Intrinsics.checkNotNullParameter(entries, "entries");
        this.entries = entries;
    }

    @Override
    public int getSize() {
        return this.entries.length;
    }

    @Override
    public T get(int index) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.entries.length);
        return this.entries[index];
    }

    @Override
    public boolean contains(T element) {
        Intrinsics.checkNotNullParameter(element, "element");
        Enum target = (Enum)ArraysKt.getOrNull(this.entries, ((Enum)element).ordinal());
        return target == element;
    }

    @Override
    public int indexOf(T element) {
        Intrinsics.checkNotNullParameter(element, "element");
        int ordinal = ((Enum)element).ordinal();
        Enum target = (Enum)ArraysKt.getOrNull(this.entries, ordinal);
        return target == element ? ordinal : -1;
    }

    @Override
    public int lastIndexOf(T element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.indexOf((Object)element);
    }
}

