/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt__DurationUnitJvmKt;

class DurationUnitKt__DurationUnitKt
extends DurationUnitKt__DurationUnitJvmKt {
    public static final DurationUnit durationUnitByShortName(String shortName) {
        DurationUnit durationUnit;
        Intrinsics.checkNotNullParameter(shortName, "shortName");
        switch (shortName) {
            case "ns": {
                durationUnit = DurationUnit.NANOSECONDS;
                break;
            }
            case "us": {
                durationUnit = DurationUnit.MICROSECONDS;
                break;
            }
            case "ms": {
                durationUnit = DurationUnit.MILLISECONDS;
                break;
            }
            case "s": {
                durationUnit = DurationUnit.SECONDS;
                break;
            }
            case "m": {
                durationUnit = DurationUnit.MINUTES;
                break;
            }
            case "h": {
                durationUnit = DurationUnit.HOURS;
                break;
            }
            case "d": {
                durationUnit = DurationUnit.DAYS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown duration unit short name: " + shortName);
            }
        }
        return durationUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DurationUnit durationUnitByIsoChar(char isoChar, boolean isTimeComponent) {
        DurationUnit durationUnit;
        if (!isTimeComponent) {
            if (isoChar != 'D') throw new IllegalArgumentException("Invalid or unsupported duration ISO non-time unit: " + isoChar);
            durationUnit = DurationUnit.DAYS;
            return durationUnit;
        } else {
            switch (isoChar) {
                case 'H': {
                    durationUnit = DurationUnit.HOURS;
                    return durationUnit;
                }
                case 'M': {
                    durationUnit = DurationUnit.MINUTES;
                    return durationUnit;
                }
                case 'S': {
                    durationUnit = DurationUnit.SECONDS;
                    return durationUnit;
                }
                default: {
                    throw new IllegalArgumentException("Invalid duration ISO time unit: " + isoChar);
                }
            }
        }
    }
}

