/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.flow.internal;

import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.CoroutineStackFrame;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.internal.DownstreamExceptionContext;
import kotlinx.coroutines.flow.internal.NoOpContinuation;
import kotlinx.coroutines.flow.internal.SafeCollector;
import kotlinx.coroutines.flow.internal.SafeCollectorKt;
import kotlinx.coroutines.flow.internal.SafeCollector_commonKt;

public final class SafeCollector<T>
extends ContinuationImpl
implements FlowCollector<T> {
    public final FlowCollector<T> collector;
    public final CoroutineContext collectContext;
    public final int collectContextSize;
    private CoroutineContext lastEmissionContext;
    private Continuation<? super Unit> completion_;

    public SafeCollector(FlowCollector<? super T> collector, CoroutineContext collectContext) {
        super(NoOpContinuation.INSTANCE, EmptyCoroutineContext.INSTANCE);
        this.collector = collector;
        this.collectContext = collectContext;
        this.collectContextSize = ((Number)this.collectContext.fold(0, collectContextSize.1.INSTANCE)).intValue();
    }

    @Override
    public CoroutineStackFrame getCallerFrame() {
        Continuation<? super Unit> continuation = this.completion_;
        return continuation instanceof CoroutineStackFrame ? (CoroutineStackFrame)((Object)continuation) : null;
    }

    @Override
    public StackTraceElement getStackTraceElement() {
        return null;
    }

    @Override
    public CoroutineContext getContext() {
        CoroutineContext coroutineContext = this.lastEmissionContext;
        if (coroutineContext == null) {
            coroutineContext = EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext;
    }

    @Override
    public Object invokeSuspend(Object result2) {
        block1: {
            Object object = result2;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                this.lastEmissionContext = new DownstreamExceptionContext(it, this.getContext());
            }
            Continuation<? super Unit> continuation = this.completion_;
            if (continuation == null) break block1;
            continuation.resumeWith(result2);
        }
        return IntrinsicsKt.getCOROUTINE_SUSPENDED();
    }

    @Override
    public void releaseIntercepted() {
        super.releaseIntercepted();
    }

    @Override
    public Object emit(T value, Continuation<? super Unit> $completion) {
        Object object;
        Continuation<? super Unit> uCont = $completion;
        boolean bl = false;
        try {
            object = this.emit(uCont, value);
        }
        catch (Throwable e) {
            this.lastEmissionContext = new DownstreamExceptionContext(e, uCont.getContext());
            throw e;
        }
        Object object2 = object;
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    private final Object emit(Continuation<? super Unit> uCont, T value) {
        CoroutineContext currentContext = uCont.getContext();
        JobKt.ensureActive(currentContext);
        CoroutineContext previousContext = this.lastEmissionContext;
        if (previousContext != currentContext) {
            this.checkContext(currentContext, previousContext, value);
            this.lastEmissionContext = currentContext;
        }
        this.completion_ = uCont;
        Function3 function3 = SafeCollectorKt.access$getEmitFun$p();
        FlowCollector<T> flowCollector = this.collector;
        Intrinsics.checkNotNull(flowCollector, "null cannot be cast to non-null type kotlinx.coroutines.flow.FlowCollector<kotlin.Any?>");
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type kotlin.coroutines.Continuation<kotlin.Unit>");
        Object result2 = function3.invoke(flowCollector, value, (Continuation)this);
        if (!Intrinsics.areEqual(result2, IntrinsicsKt.getCOROUTINE_SUSPENDED())) {
            this.completion_ = null;
        }
        return result2;
    }

    private final void checkContext(CoroutineContext currentContext, CoroutineContext previousContext, T value) {
        if (previousContext instanceof DownstreamExceptionContext) {
            this.exceptionTransparencyViolated((DownstreamExceptionContext)previousContext, value);
        }
        SafeCollector_commonKt.checkContext(this, currentContext);
    }

    private final void exceptionTransparencyViolated(DownstreamExceptionContext exception, Object value) {
        throw new IllegalStateException(StringsKt.trimIndent("\n            Flow exception transparency is violated:\n                Previous 'emit' call has thrown exception " + exception.e + ", but then emission attempt of value '" + value + "' has been detected.\n                Emissions from 'catch' blocks are prohibited in order to avoid unspecified behaviour, 'Flow.catch' operator can be used instead.\n                For a more detailed explanation, please refer to Flow documentation.\n            ").toString());
    }
}

