/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import kotlin.ExceptionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineExceptionHandlerKt;
import kotlinx.coroutines.internal.CoroutineExceptionHandlerImplKt;
import kotlinx.coroutines.internal.DiagnosticCoroutineContextException;
import kotlinx.coroutines.internal.ExceptionSuccessfullyProcessed;

public final class CoroutineExceptionHandlerImpl_commonKt {
    public static final void handleUncaughtCoroutineException(CoroutineContext context, Throwable exception) {
        for (CoroutineExceptionHandler handler : CoroutineExceptionHandlerImplKt.getPlatformExceptionHandlers()) {
            try {
                handler.handleException(context, exception);
            }
            catch (ExceptionSuccessfullyProcessed _) {
                return;
            }
            catch (Throwable t) {
                CoroutineExceptionHandlerImplKt.propagateExceptionFinalResort(CoroutineExceptionHandlerKt.handlerException(exception, t));
            }
        }
        try {
            ExceptionsKt.addSuppressed(exception, new DiagnosticCoroutineContextException(context));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CoroutineExceptionHandlerImplKt.propagateExceptionFinalResort(exception);
    }
}

