/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;

final class JsonTreeListDecoder
extends AbstractJsonTreeDecoder {
    private final JsonArray value;
    private final int size;
    private int currentIndex;

    public JsonTreeListDecoder(Json json, JsonArray value) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(value, "value");
        super(json, value, null, 4, null);
        this.value = value;
        this.size = this.getValue().size();
        this.currentIndex = -1;
    }

    @Override
    public JsonArray getValue() {
        return this.value;
    }

    @Override
    protected String elementName(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return String.valueOf(index);
    }

    @Override
    protected JsonElement currentElement(String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        return this.getValue().get(Integer.parseInt(tag));
    }

    @Override
    public int decodeElementIndex(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.currentIndex < this.size - 1) {
            int n = this.currentIndex;
            this.currentIndex = n + 1;
            return this.currentIndex;
        }
        return -1;
    }
}

