/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;

public final class Challenge {
    private final String scheme;
    private final Map<String, String> authParams;

    public Challenge(String scheme, Map<String, String> authParams) {
        Intrinsics.checkNotNullParameter(scheme, "scheme");
        Intrinsics.checkNotNullParameter(authParams, "authParams");
        this.scheme = scheme;
        Map newAuthParams = new LinkedHashMap();
        for (Map.Entry<String, String> entry : authParams.entrySet()) {
            String string;
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null) {
                string = null;
            } else {
                String string2;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                String string3 = string2.toLowerCase(locale);
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(locale)");
            }
            String newKey = string;
            newAuthParams.put(newKey, value);
        }
        Map map2 = Collections.unmodifiableMap(newAuthParams);
        Intrinsics.checkNotNullExpressionValue(map2, "unmodifiableMap<String?, String>(newAuthParams)");
        this.authParams = map2;
    }

    public final String scheme() {
        return this.scheme;
    }

    public final String realm() {
        return this.authParams.get("realm");
    }

    public final Charset charset() {
        String charset = this.authParams.get("charset");
        if (charset != null) {
            try {
                Charset charset2 = Charset.forName(charset);
                Intrinsics.checkNotNullExpressionValue(charset2, "forName(charset)");
                return charset2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Charset charset3 = StandardCharsets.ISO_8859_1;
        Intrinsics.checkNotNullExpressionValue(charset3, "ISO_8859_1");
        return charset3;
    }

    public boolean equals(Object other) {
        return other instanceof Challenge && Intrinsics.areEqual(((Challenge)other).scheme, this.scheme) && Intrinsics.areEqual(((Challenge)other).authParams, this.authParams);
    }

    public int hashCode() {
        int result2 = 29;
        result2 = 31 * result2 + this.scheme.hashCode();
        result2 = 31 * result2 + ((Object)this.authParams).hashCode();
        return result2;
    }

    public String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }
}

