/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionSpec;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private int nextModeIndex;
    private boolean isFallbackPossible;
    private boolean isFallback;

    public ConnectionSpecSelector(List<ConnectionSpec> connectionSpecs) {
        Intrinsics.checkNotNullParameter(connectionSpecs, "connectionSpecs");
        this.connectionSpecs = connectionSpecs;
    }

    public final ConnectionSpec configureSecureSocket(SSLSocket sslSocket) throws IOException {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        ConnectionSpec tlsConfiguration = null;
        int n = this.nextModeIndex;
        int n2 = this.connectionSpecs.size();
        while (n < n2) {
            int i;
            ConnectionSpec connectionSpec;
            if (!(connectionSpec = this.connectionSpecs.get(i = n++)).isCompatible(sslSocket)) continue;
            tlsConfiguration = connectionSpec;
            this.nextModeIndex = i + 1;
            break;
        }
        if (tlsConfiguration == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Unable to find acceptable protocols. isFallback=").append(this.isFallback).append(", modes=").append(this.connectionSpecs).append(", supported protocols=");
            Object[] objectArray = sslSocket.getEnabledProtocols();
            Intrinsics.checkNotNull(objectArray);
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
            throw new UnknownServiceException(stringBuilder.append(string).toString());
        }
        this.isFallbackPossible = this.isFallbackPossible(sslSocket);
        tlsConfiguration.apply$okhttp(sslSocket, this.isFallback);
        return tlsConfiguration;
    }

    public final boolean connectionFailed(IOException e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.isFallback = true;
        return !this.isFallbackPossible ? false : (e instanceof ProtocolException ? false : (e instanceof InterruptedIOException ? false : (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException ? false : (e instanceof SSLPeerUnverifiedException ? false : e instanceof SSLException))));
    }

    private final boolean isFallbackPossible(SSLSocket socket) {
        int n = this.nextModeIndex;
        int n2 = this.connectionSpecs.size();
        while (n < n2) {
            int i;
            if (!this.connectionSpecs.get(i = n++).isCompatible(socket)) continue;
            return true;
        }
        return false;
    }
}

