/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;

public final class RealCall
implements Call {
    private final OkHttpClient client;
    private final Request originalRequest;
    private final boolean forWebSocket;
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    private final timeout.1 timeout;
    private final AtomicBoolean executed;
    private Object callStackTrace;
    private ExchangeFinder exchangeFinder;
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    private volatile Exchange exchange;
    private volatile RealConnection connectionToCancel;

    /*
     * WARNING - void declaration
     */
    public RealCall(OkHttpClient client, Request originalRequest, boolean forWebSocket) {
        void $this$timeout_u24lambda_u2d0;
        AsyncTimeout asyncTimeout;
        Intrinsics.checkNotNullParameter(client, "client");
        Intrinsics.checkNotNullParameter(originalRequest, "originalRequest");
        this.client = client;
        this.originalRequest = originalRequest;
        this.forWebSocket = forWebSocket;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        AsyncTimeout asyncTimeout2 = asyncTimeout = new AsyncTimeout(this){
            final /* synthetic */ RealCall this$0;
            {
                this.this$0 = $receiver;
            }

            protected void timedOut() {
                this.this$0.cancel();
            }
        };
        RealCall realCall = this;
        boolean bl = false;
        $this$timeout_u24lambda_u2d0.timeout(this.getClient().callTimeoutMillis(), TimeUnit.MILLISECONDS);
        realCall.timeout = asyncTimeout;
        this.executed = new AtomicBoolean();
        this.expectMoreExchanges = true;
    }

    public final OkHttpClient getClient() {
        return this.client;
    }

    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final RealConnection getConnection() {
        return this.connection;
    }

    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    public final void setConnectionToCancel(RealConnection realConnection) {
        this.connectionToCancel = realConnection;
    }

    public RealCall clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    @Override
    public void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Exchange exchange = this.exchange;
        if (exchange != null) {
            exchange.cancel();
        }
        RealConnection realConnection = this.connectionToCancel;
        if (realConnection != null) {
            realConnection.cancel();
        }
        this.eventListener.canceled(this);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() {
        if (!this.executed.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.timeout.enter();
        this.callStart();
        try {
            this.client.dispatcher().executed$okhttp(this);
            Response response = this.getResponseWithInterceptorChain$okhttp();
            return response;
        }
        finally {
            this.client.dispatcher().finished$okhttp(this);
        }
    }

    @Override
    public void enqueue(Callback responseCallback) {
        Intrinsics.checkNotNullParameter(responseCallback, "responseCallback");
        if (!this.executed.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.callStart();
        this.client.dispatcher().enqueue$okhttp(new AsyncCall(responseCallback));
    }

    private final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response getResponseWithInterceptorChain$okhttp() throws IOException {
        Response response;
        List interceptors = new ArrayList();
        CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.interceptors());
        ((Collection)interceptors).add(new RetryAndFollowUpInterceptor(this.client));
        ((Collection)interceptors).add(new BridgeInterceptor(this.client.cookieJar()));
        ((Collection)interceptors).add(new CacheInterceptor(this.client.cache()));
        ((Collection)interceptors).add(ConnectInterceptor.INSTANCE);
        if (!this.forWebSocket) {
            CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.networkInterceptors());
        }
        ((Collection)interceptors).add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain chain = new RealInterceptorChain(this, interceptors, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            Response response2 = chain.proceed(this.originalRequest);
            if (this.isCanceled()) {
                Util.closeQuietly(response2);
                throw new IOException("Canceled");
            }
            response = response2;
        }
        catch (IOException e) {
            try {
                calledNoMoreExchanges = true;
                IOException iOException = this.noMoreExchanges$okhttp(e);
                if (iOException == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                }
                throw (Throwable)iOException;
            }
            catch (Throwable throwable) {
                if (!calledNoMoreExchanges) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        this.noMoreExchanges$okhttp(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterNetworkInterceptorExchange(Request request, boolean newExchangeFinder) {
        Intrinsics.checkNotNullParameter(request, "request");
        if (!(this.interceptorScopedExchange == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (!(!this.responseBodyOpen)) {
                boolean bl2 = false;
                String string = "cannot make a new request because the previous response is still open: please call response.close()";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (newExchangeFinder) {
            this.exchangeFinder = new ExchangeFinder(this.connectionPool, this.createAddress(request.url()), this, this.eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Exchange initExchange$okhttp(RealInterceptorChain chain) {
        Exchange result2;
        Intrinsics.checkNotNullParameter(chain, "chain");
        RealCall realCall = this;
        synchronized (realCall) {
            boolean $i$a$-synchronized-RealCall$initExchange$32 = false;
            if (!this.expectMoreExchanges) {
                boolean bl = false;
                String string = "released";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.responseBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Unit $i$a$-synchronized-RealCall$initExchange$32 = Unit.INSTANCE;
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull(exchangeFinder);
        ExchangeFinder exchangeFinder2 = exchangeFinder;
        ExchangeCodec codec = exchangeFinder2.find(this.client, chain);
        this.interceptorScopedExchange = result2 = new Exchange(this, this.eventListener, exchangeFinder2, codec);
        this.exchange = result2;
        RealCall realCall2 = this;
        synchronized (realCall2) {
            boolean bl = false;
            this.requestBodyOpen = true;
            this.responseBodyOpen = true;
            Unit unit = Unit.INSTANCE;
        }
        if (this.canceled) {
            throw new IOException("Canceled");
        }
        return result2;
    }

    public final void acquireConnectionNoEvents(RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        if (!(this.connection == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.connection = connection;
        connection.getCalls().add(new CallReference(this, this.callStackTrace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends IOException> E messageDone$okhttp(Exchange exchange, boolean requestDone, boolean responseDone, E e) {
        Intrinsics.checkNotNullParameter(exchange, "exchange");
        if (!Intrinsics.areEqual(exchange, this.exchange)) {
            return e;
        }
        boolean bothStreamsDone = false;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (requestDone && this.requestBodyOpen || responseDone && this.responseBodyOpen) {
                if (requestDone) {
                    this.requestBodyOpen = false;
                }
                if (responseDone) {
                    this.responseBodyOpen = false;
                }
                bothStreamsDone = !this.requestBodyOpen && !this.responseBodyOpen;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen && !this.expectMoreExchanges;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (bothStreamsDone) {
            this.exchange = null;
            RealConnection realConnection = this.connection;
            if (realConnection != null) {
                realConnection.incrementSuccessCount$okhttp();
            }
        }
        if (callDone) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IOException noMoreExchanges$okhttp(IOException e) {
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (this.expectMoreExchanges) {
                this.expectMoreExchanges = false;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (callDone) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends IOException> E callDone(E e) {
        RealCall $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        RealConnection connection = this.connection;
        if (connection != null) {
            Object object;
            RealConnection $this$assertThreadDoesntHoldLock$iv2 = connection;
            boolean $i$f$assertThreadDoesntHoldLock2 = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv2)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv2));
            }
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                boolean bl = false;
                object = this.releaseConnectionNoEvents$okhttp();
            }
            Socket socket = object;
            if (this.connection == null) {
                Socket socket2 = socket;
                if (socket2 != null) {
                    Util.closeQuietly(socket2);
                }
                this.eventListener.connectionReleased(this, connection);
            } else if (!(socket == null)) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
        }
        E result2 = this.timeoutExit(e);
        if (e != null) {
            Call call = this;
            E e2 = result2;
            Intrinsics.checkNotNull(e2);
            this.eventListener.callFailed(call, e2);
        } else {
            this.eventListener.callEnd(this);
        }
        return result2;
    }

    public final Socket releaseConnectionNoEvents$okhttp() {
        int index;
        List<Reference<RealCall>> calls;
        RealConnection connection;
        block6: {
            int n;
            RealConnection realConnection = this.connection;
            Intrinsics.checkNotNull(realConnection);
            RealConnection $this$assertThreadHoldsLock$iv = connection = realConnection;
            boolean $i$f$assertThreadHoldsLock = false;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            List<Reference<RealCall>> $this$indexOfFirst$iv = calls = connection.getCalls();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Reference<RealCall>> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                Reference<RealCall> item$iv;
                Reference<RealCall> it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual(it.get(), this)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (!(index != -1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        calls.remove(index);
        this.connection = null;
        if (calls.isEmpty()) {
            connection.setIdleAtNs$okhttp(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle(connection)) {
                return connection.socket();
            }
        }
        return null;
    }

    private final <E extends IOException> E timeoutExit(E cause) {
        if (this.timeoutEarlyExit) {
            return cause;
        }
        if (!this.timeout.exit()) {
            return cause;
        }
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return (E)e;
    }

    public final void timeoutEarlyExit() {
        if (!(!this.timeoutEarlyExit)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean closeExchange) {
        RealCall realCall = this;
        synchronized (realCall) {
            boolean bl = false;
            if (!this.expectMoreExchanges) {
                boolean bl2 = false;
                String string = "released";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        if (closeExchange) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
        }
        this.interceptorScopedExchange = null;
    }

    private final Address createAddress(HttpUrl url) {
        SSLSocketFactory sslSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (url.isHttps()) {
            sslSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(url.host(), url.port(), this.client.dns(), this.client.socketFactory(), sslSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    public final boolean retryAfterFailure() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull(exchangeFinder);
        return exchangeFinder.retryAfterFailure();
    }

    private final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl$okhttp();
    }

    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    public final class AsyncCall
    implements Runnable {
        private final Callback responseCallback;
        private volatile AtomicInteger callsPerHost;

        public AsyncCall(Callback responseCallback) {
            Intrinsics.checkNotNullParameter(RealCall.this, "this$0");
            Intrinsics.checkNotNullParameter(responseCallback, "responseCallback");
            this.responseCallback = responseCallback;
            this.callsPerHost = new AtomicInteger(0);
        }

        public final AtomicInteger getCallsPerHost() {
            return this.callsPerHost;
        }

        public final void reuseCallsPerHostFrom(AsyncCall other) {
            Intrinsics.checkNotNullParameter(other, "other");
            this.callsPerHost = other.callsPerHost;
        }

        public final String getHost() {
            return RealCall.this.getOriginalRequest().url().host();
        }

        public final RealCall getCall() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeOn(ExecutorService executorService) {
            Intrinsics.checkNotNullParameter(executorService, "executorService");
            Dispatcher $this$assertThreadDoesntHoldLock$iv = RealCall.this.getClient().dispatcher();
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            boolean success = false;
            try {
                executorService.execute(this);
                success = true;
            }
            catch (RejectedExecutionException e) {
                InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                ioException.initCause(e);
                RealCall.this.noMoreExchanges$okhttp(ioException);
                this.responseCallback.onFailure(RealCall.this, ioException);
            }
            finally {
                RealCall.this.getClient().dispatcher().finished$okhttp(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void name$iv;
            String string = Intrinsics.stringPlus("OkHttp ", RealCall.this.redactedUrl$okhttp());
            RealCall realCall = RealCall.this;
            boolean $i$f$threadName = false;
            Thread currentThread$iv = Thread.currentThread();
            String oldName$iv = currentThread$iv.getName();
            currentThread$iv.setName((String)name$iv);
            try {
                boolean bl = false;
                boolean signalledCallback = false;
                realCall.timeout.enter();
                try {
                    Response response = realCall.getResponseWithInterceptorChain$okhttp();
                    signalledCallback = true;
                    this.responseCallback.onResponse(realCall, response);
                }
                catch (IOException e) {
                    if (signalledCallback) {
                        Platform.Companion.get().log(Intrinsics.stringPlus("Callback failure for ", realCall.toLoggableString()), 4, e);
                    } else {
                        this.responseCallback.onFailure(realCall, e);
                    }
                }
                catch (Throwable t) {
                    realCall.cancel();
                    if (!signalledCallback) {
                        IOException canceledException = new IOException(Intrinsics.stringPlus("canceled due to ", t));
                        ExceptionsKt.addSuppressed(canceledException, t);
                        this.responseCallback.onFailure(realCall, canceledException);
                    }
                    throw t;
                }
                finally {
                    realCall.getClient().dispatcher().finished$okhttp(this);
                }
            }
            finally {
                currentThread$iv.setName(oldName$iv);
            }
        }
    }

    public static final class CallReference
    extends WeakReference<RealCall> {
        private final Object callStackTrace;

        public CallReference(RealCall referent, Object callStackTrace) {
            Intrinsics.checkNotNullParameter(referent, "referent");
            super(referent);
            this.callStackTrace = callStackTrace;
        }

        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }
    }
}

